<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<db:script src="/database/utils.js"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="mapForm" 
        method="post"
        destination="/console/database/instance/rsrcmap">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcmap/rsrcmapGeneral"/>

		<uix:formValue 
          name="rowIndex" 
          value=""/>
		<uix:formValue 
          name="source" 
          value=""/>
		<uix:formValue 
          name="itemNum" 
          value=""/>

        <uix:pageLayout
          titleBinding="CONSUMER_GROUP_MAPPING@rsrcMapBundle@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:link textBinding="GENERAL@rsrcMapBundle@servletRequest" />
                <uix:link textBinding="PRIORITIES@rsrcMapBundle@servletRequest"
                  onClick="submitForm('mapForm', true, {event:'prioritiesTab'})"/>
              </uix:subTabBar> 
            </uix:subTabs>

            <%---------------------------
             -   Instruction Text
             ---------------------------%>
            <uix:tableLayout cellSpacing="10">
              <uix:rowLayout> 
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="RSRC_MAPPING_INSTR@rsrcMapBundle@servletRequest"
                  />
              </uix:rowLayout> 
              <uix:rowLayout width="100%" hAlign="left"> 
                 <uix:flowLayout>
<uix:styledText  styleClass="OraInstructionText" textBinding="MAP_TYPE@rsrcMapBundle@servletRequest" />
                <uix:choice id="mapTypeList" name="mapTypeList" onChange="submitForm('mapForm', true, 		{'event':'changeMapType'})"
					selectedValueBinding="selMapType@rsrcmapBean@servletRequest">
					<uix:contents childDataBinding="mapTypeList@rsrcmapBean@servletRequest">
						<uix:option textBinding="jtext" valueBinding="jval"/>
					</uix:contents>
                </uix:choice>

		  </uix:flowLayout>
              </uix:rowLayout> 
            </uix:tableLayout>

            <%---------------------------
             -   Oracle User Map Table  -
             ---------------------------%>
              <%--- Table ---%>
              <%--------------------------------------------------%>
              <%--- NOTE:                                      ---%>
              <%---   This table cannot use copyParams         ---%>
              <%---   due to a bug in the oem:table code       ---%>
              <%---   when generating urls for an lov column.  ---%>
              <%---   Happily, copyParams is not needed here.  ---%>
              <%--------------------------------------------------%>
			<uix:switcher childNameBinding="selMapType@rsrcmapBean@servletRequest">
			<uix:case name="ALL">

				  <uix:table name="ALL"
					 width="100%"
					 tableDataBinding="tableData@rsrcmapBean@servletRequest"
					 summaryBinding="MAP_TYPE@rsrcMapBundle@servletRequest"
					 formSubmitted="true"
					 showAll="yes"
				   alternateTextBinding = "NO_ITEMS_FOUND@rsrcMapBundle@servletRequest"	>
  <uix:tableFormat tableBanding="rowBanding"/>
                <uix:tableSelection>
                  <uix:singleSelection 
                    shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                    selectedIndexBinding="selectedItemIndex@rsrcmapBean@servletRequest"
		    >
                    <uix:submitButton
                      textBinding="ADD_ROW@rsrcMapBundle@servletRequest"
                      shortDescBinding="ADD_ROW@rsrcMapBundle@servletRequest"
                      name="event"
                      value="addRow"
                      formName="mapForm"
                    />
                  </uix:singleSelection>
                </uix:tableSelection>

				   <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
					  <uix:columnHeader>
<%--
<uix:styledText textBinding="PRIORITY@rsrcMapBundle@servletRequest"/> 
--%>
                     <uix:sortableHeader textBinding="PRIORITY@rsrcMapBundle@servletRequest" sortableBinding="prioritySortable@rsrcmapBean@servletRequest"/>
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="priority"/>
						<uix:formValue name="priority" valueBinding="priority"/>
					  </uix:contents>
				   </uix:column>
				   <uix:column>
					  <uix:columnHeader>
<%--
<uix:styledText textBinding="MAP_TYPE@rsrcMapBundle@servletRequest"/>
--%>
                     <uix:sortableHeader textBinding="MAP_TYPE@rsrcMapBundle@servletRequest" sortableBinding="mapTypeSortable@rsrcmapBean@servletRequest"/>
					  </uix:columnHeader>
					  <uix:contents>
						<uix:styledText styleClass="OraText" textBinding="mapType"/>
					  </uix:contents>
				   </uix:column>
				   <uix:column useSeparateRows="true">
					  <uix:columnHeader>

<uix:styledText textBinding="VALUE@rsrcMapBundle@servletRequest"/>
<%--
                     <uix:sortableHeader textBinding="VALUE@rsrcMapBundle@servletRequest" sortable="true"/>
--%>
					  </uix:columnHeader>
					  <uix:contents childDataBinding="value">
			<uix:switcher childNameBinding="noData">
			<uix:case name="true">
					<uix:styledText styleClass="OraInstructionText" textBinding="name"/>
			</uix:case>
			<uix:default>
				<uix:tableLayout borderWidth="0" width="100%">
				<uix:rowLayout>
				<uix:cellFormat width="100%">
					<uix:switcher childNameBinding="valueList">
					<uix:case name="">
						<uix:styledText styleClass="OraDataText" textBinding="EMPTY_ROW@rsrcMapBundle@servletRequest"/>
					</uix:case>
					<uix:default>
						<uix:styledText styleClass="OraInstructionText" textBinding="valueList"/>
					</uix:default>
					</uix:switcher>
<%--
				<uix:list name="mapList" size="4">
				  <uix:contents childDataBinding="valueList">
					<uix:option textBinding="ltext"/>
				  </uix:contents>
				</uix:list>
--%>
				</uix:cellFormat>
				<uix:cellFormat vAlign="bottom">
				<uix:image 
					onClickBinding="changeURL" 
					shortDescBinding="SEARCH_ICON@rsrcMapBundle@servletRequest"
					source="/em/images/database/schr/searchicon_enabled.gif"/>
				</uix:cellFormat>
				</uix:rowLayout>
				</uix:tableLayout>

			</uix:default>
			</uix:switcher>
					  </uix:contents>
				   </uix:column>
				   <uix:column useSeparateRows="true">
					  <uix:columnHeader>

<uix:styledText textBinding="CONSUMER_GROUP@rsrcMapBundle@servletRequest"/>
<%--
                     <uix:sortableHeader textBinding="CONSUMER_GROUP@rsrcMapBundle@servletRequest" sortable="true"/>
--%>
					  </uix:columnHeader>
					  <uix:contents childDataBinding="cg">

			<uix:switcher childNameBinding="noData">
			<uix:case name="true">
						<uix:styledText styleClass="OraText" text=""/>
			</uix:case>
			<uix:default>
				<uix:flowLayout>
						<uix:styledText styleClass="OraText" textBinding="ltext"/>
						<uix:formValue name="cg" valueBinding="ltext"/>
				</uix:flowLayout>
			</uix:default>
			</uix:switcher>

					  </uix:contents>
				   </uix:column>
				   <uix:column useSeparateRows="true">
				   <uix:columnFormat columnDataFormat="iconButtonFormat"/>
					  <uix:columnHeader>
						<uix:styledText textBinding="REMOVE@rsrcMapBundle@servletRequest"/>
					  </uix:columnHeader>
					  <uix:contents childDataBinding="cg">
			<uix:switcher childNameBinding="noData">
			<uix:case name="true">
				<uix:styledText styleClass="OraText" text=""/>
			</uix:case>
			<uix:default>
				<uix:image 
					onClickBinding="deleteCG" 
					shortDescBinding="DELETE@rsrcMapBundle@servletRequest"
					source="<%= request.getContextPath() + \"/images/remove_enabled.gif\" %>"/>
			</uix:default>
			</uix:switcher>
					  </uix:contents>
				   </uix:column>


				  </uix:table>

			</uix:case>

			  <uix:default>
			  <uix:stackLayout>
			  
                    <uix:submitButton
                      shortDescBinding="ADD_ROW@rsrcMapBundle@servletRequest"
                      textBinding="ADD_ROW@rsrcMapBundle@servletRequest"
                      name="event"
                      value="addRow"
                      formName="mapForm"
                    />





				  <uix:table name="ALL"
					 width="100%"
					 tableDataBinding="singleMapList@rsrcmapBean@servletRequest"
					 summaryBinding="MAP_TYPE@rsrcMapBundle@servletRequest"
					 formSubmitted="true"
					 showAll="yes"
				   alternateTextBinding = "NO_ITEMS_FOUND@rsrcMapBundle@servletRequest"	>
  <uix:tableFormat tableBanding="rowBanding"/>

				   <uix:column useSeparateRows="true">
					  <uix:columnHeader>

<uix:styledText textBinding="VALUE@rsrcMapBundle@servletRequest"/>
<%--
                     <uix:sortableHeader textBinding="VALUE@rsrcMapBundle@servletRequest" sortable="true"/>
--%>
					  </uix:columnHeader>
					  <uix:contents childDataBinding="value">
			<uix:switcher childNameBinding="noData">
			<uix:case name="true">
					<uix:styledText styleClass="OraInstructionText" textBinding="name"/>
			</uix:case>
			<uix:default>
				<uix:tableLayout borderWidth="0" width="100%">
				<uix:rowLayout>
				<uix:cellFormat width="100%">
					  <uix:formValue name="priority" valueBinding="priority"/>
					<uix:switcher childNameBinding="valueList">
					<uix:case name="">
						<uix:styledText styleClass="OraDataText" textBinding="EMPTY_ROW@rsrcMapBundle@servletRequest"/>
					</uix:case>
					<uix:default>
						<uix:styledText styleClass="OraInstructionText" textBinding="valueList"/>
					</uix:default>
					</uix:switcher>
<%--
				<uix:list name="mapList" size="4">
				  <uix:contents childDataBinding="valueList">
					<uix:option textBinding="ltext"/>
				  </uix:contents>
				</uix:list>
--%>
				</uix:cellFormat>
				<uix:cellFormat vAlign="bottom">
				<uix:image 
					onClickBinding="changeURL" 
					shortDescBinding="SEARCH@rsrcMapBundle@servletRequest"
					source="/em/images/database/schr/searchicon_enabled.gif"/>
				</uix:cellFormat>
				</uix:rowLayout>
				</uix:tableLayout>

			</uix:default>
			</uix:switcher>
					  </uix:contents>
				   </uix:column>
				   <uix:column useSeparateRows="true">
					  <uix:columnHeader>

<uix:styledText textBinding="CONSUMER_GROUP@rsrcMapBundle@servletRequest"/>
<%--
                     <uix:sortableHeader textBinding="CONSUMER_GROUP@rsrcMapBundle@servletRequest" sortable="true"/>
--%>
					  </uix:columnHeader>
					  <uix:contents childDataBinding="cg">

			<uix:switcher childNameBinding="noData">
			<uix:case name="true">
						<uix:styledText styleClass="OraText" text=""/>
			</uix:case>
			<uix:default>
				<uix:flowLayout>
						<uix:styledText styleClass="OraText" textBinding="ltext"/>
						<uix:formValue name="cg" valueBinding="ltext"/>
				</uix:flowLayout>
			</uix:default>
			</uix:switcher>

					  </uix:contents>
				   </uix:column>
				   <uix:column useSeparateRows="true">
				   <uix:columnFormat columnDataFormat="iconButtonFormat"/>
					  <uix:columnHeader>
						<uix:styledText textBinding="REMOVE@rsrcMapBundle@servletRequest"/>
					  </uix:columnHeader>
					  <uix:contents childDataBinding="cg">
			<uix:switcher childNameBinding="noData">
			<uix:case name="true">
				<uix:styledText styleClass="OraText" text=""/>
			</uix:case>
			<uix:default>
				<uix:image 
					onClickBinding="deleteCG" 
					shortDescBinding="DELETE@rsrcMapBundle@servletRequest"
					source="<%= request.getContextPath() + \"/images/deleteicon_enabled.gif\" %>"/>
			</uix:default>
			</uix:switcher>
					  </uix:contents>
				   </uix:column>


				  </uix:table>



					</uix:stackLayout>
			  </uix:default>
			  </uix:switcher>
              <%---  Add Button
              <uix:submitButton 
                textBinding="ADD_ROW@rsrcMapBundle@servletRequest"
                name="event"
                value="addButton0" 
                formName="mapForm"
              />  
<uix:tip shortDescBinding="TIP_TEXT@rsrcMapBundle@servletRequest" textBinding="TIP_TEXT@rsrcMapBundle@servletRequest"/> 
---%>
          </uix:subTabLayout>

          <%-------------------------
           -  PageButtons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
<jsp:include page="/database/schema/pageButtonInclude.jsp" />
<uix:ref refID="pageButtonInclude" />

<%--
              <uix:submitButton
                name="event" 
                textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                value="showSql"/>

              <uix:submitButton 
                name="event" 
                textBinding="REVERT@uixDBObjectBundle@servletRequest"
                value="revert"/>  

              <uix:submitButton
                name="event" 
                textBinding="APPLY@uixDBObjectBundle@servletRequest"
                value="apply"/>
--%>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

