<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="mapForm" 
        method="post"
        destination="/console/database/instance/rsrcmap">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcmap/rsrcmapPriorities"/>

        <uix:pageLayout
          titleBinding="CONSUMER_GROUP_MAPPING@rsrcMapBundle@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:link textBinding="GENERAL@rsrcMapBundle@servletRequest"
                  onClick="submitForm('mapForm', true, {event:'generalTab'})"/>
                <uix:link textBinding="PRIORITIES@rsrcMapBundle@servletRequest" />
              </uix:subTabBar> 
            </uix:subTabs>

            <%---------------------------
             -   Instruction Section -
             ---------------------------%>
             <uix:tableLayout cellSpacing="5">
               <uix:rowLayout>
                 <uix:styledText 
                   styleClass="OraInstructionText"
                   textBinding="PRIORITY_REORDER_TEXT@rsrcMapBundle@servletRequest"/>
               </uix:rowLayout>
             </uix:tableLayout>

            <%---------------------------
             -   Oracle Priorities List -
             ---------------------------%>
              <oem:shuttle 
                name="Priorities" 
                size="15"
                reorderable="true"
                leadingHeaderBinding="ATTRIBUTE_MAPPINGS@rsrcMapBundle@servletRequest"
                >

                <uix:leading>
                  <oem:list
                    name="mapNames"
                    shortDescBinding="ATTRIBUTE_MAPPINGS@rsrcMapBundle@servletRequest"
                    multiple="true"
                    optionsBinding="priorityList@rsrcmapBean@servletRequest"
                    />
                </uix:leading>

              </oem:shuttle>

            <%---------------------------
             -   Explicit Priority Tip
                <uix:switcher 
                  childNameBinding="allowsExplicitPriorityChanges@rsrcmapBean@servletRequest">
                  <uix:case name="true">
                    <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                        <uix:tip
                          textBinding="EXPLICIT_PRIORITY_MSG@rsrcMapBundle@servletRequest"
                          />
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:case>
                </uix:switcher>
             ---------------------------%>


          </uix:subTabLayout>

          <%-------------------------
           -  PageButtons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

<jsp:include page="/database/schema/pageButtonInclude.jsp" />
<uix:ref refID="pageButtonInclude" />
<%--
              <uix:submitButton
                name="event" 
                textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                value="showSql"/>

              <uix:submitButton 
                name="event" 
                textBinding="REVERT@uixDBObjectBundle@servletRequest"
                value="revert"/>  

              <uix:submitButton
                name="event" 
                textBinding="APPLY@uixDBObjectBundle@servletRequest"
                value="apply"/>
--%>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

