<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="searchObjPageTitle@objectPageBean@servletRequest"/>
      
      <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
      </script>

      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
      
      function lovSelect()
      {
        var proxy = new TableProxy('usersTable');
        var selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
          var selectedElement = proxy.getFormElement('UsersTable', selectedIndex);
          window.opener.document.mapForm["oracleUserMapTable:1:"+document.selectUser.rowIndex.value].value = selectedElement.value;
          window.close();
        }
      }

      </script>

    </uix:metaContainer>

    <uix:body>
    <db:form
      copyParams="target,type,cancelURL,oname,otype"
      name="selectUser" 
      method="post"
      destination="/console/database/instance/rsrcmap"
      >

      <uix:pageLayout 
        titleBinding="RSRC_GROUP_MAPPING_TITLE@rsrcMapBundle@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcmap/selectUser"/>

        <uix:formValue 
          name="rowIndex" 
          valueBinding="rowIndex@servletRequest"/>

          <%-------------------------
           -  Search Filter
           ---------------------------%>
          <uix:header
            textBinding="SEARCH@uixDBObjectBundle@servletRequest">

            <uix:rowLayout>

              <%--- Search Filter Instructions ---%>
              <uix:styledText 
                textBinding="ENTER_OBJECT_NAME@uixDBObjectBundle@servletRequest"/>

              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>

            </uix:rowLayout>

            <uix:tableLayout cellSpacing="2">
              <uix:cellFormat vAlign="top">
                <uix:rowLayout>
                  <uix:stackLayout>

                    <uix:flowLayout>

                      <%--- Search Prompt ---%>
                      <uix:styledText
                        labeledNodeId="searchFilter"
                        textBinding="AVAILABLE_USERS@rsrcMapBundle@servletRequest"/>

                      <%--- Search Input Field ---%>
                      <uix:textInput 
                        id="searchFilter"
                        name="searchFilter"
                        textBinding="searchFilter@defaultBean@servletRequest"/>

                      <%--- Search GO Button ---%>
                      <uix:submitButton 
                        textBinding="GO@uixDBObjectBundle@servletRequest"
                        onFocus="true"
                        selected="true" name="event" value="search"/>

                    </uix:flowLayout>

                    <%--- Search Error Message ---%>
                    <oem:messageBox 
                      messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText"
                      mainTextKey="mainText"/>

                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:tableLayout>
          </uix:header>

          <%-------------------------
           -  Available Users Table
           ---------------------------%>
          <uix:header 
            textBinding="AVAILABLE_USERS@rsrcMapBundle@servletRequest"
            >

            <oem:table 
              summaryBinding="AVAILABLE_USERS@rsrcMapBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%"
              blockSize="10"
              formSubmitted="true"
              name="usersTable" 
              beanKey="rsrcmapBean" 
              dataSourceProp="usersTable" 
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
              destinationBinding="destination@defaultBean" 
              >
              <uix:tableSelection>
                <uix:singleSelection
                  shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                  selectedIndex="0">
                </uix:singleSelection>
              </uix:tableSelection>
            </oem:table>
                  
          </uix:header>
        
          <%-------------------------
           -  PageButtons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:button
                textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                destination="javascript:self.close()" />

              <uix:button 
                textBinding="SELECT@uixDBObjectBundle@servletRequest" 
                destination="javascript:lovSelect()" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
