<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="mapForm" 
        method="post"
        destination="/console/database/instance/rsrcmap">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcmap/selectValue"/>

		<uix:formValue 
          name="mapType" 
          valueBinding="mapType@rsrcmapBean@servletRequest"/>

		<uix:formValue 
          name="delRowIndex" 
          value=""/>

        <uix:pageLayout
          titleBinding="CONSUMER_GROUP_MAPPING@rsrcMapBundle@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>


            <%---------------------------
             -   Instruction Section -
             ---------------------------%>
             <uix:tableLayout  cellSpacing="5" hAlign="center" width="100%">
              <uix:rowLayout>
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="SELECT_PAGE_INSTR@rsrcMapBundle@servletRequest"
                  />
              </uix:rowLayout> 

               <uix:rowLayout>
		   <uix:flowLayout>
			<uix:formValue 
			  name="conGroupMode" 
			  valueBinding="conGroupMode@rsrcmapBean@servletRequest"/>
                 <uix:styledText 
                   styleClass="OraInstructionText"
                   textBinding="SELECT_CG@rsrcMapBundle@servletRequest"/>
			<uix:switcher childNameBinding="conGroupMode@rsrcmapBean@servletRequest">
			<uix:case name="add">
		<uix:choice name="consumerGroup" selectedValueBinding="consumerGroup@rsrcmapBean@servletRequest">
			<uix:contents childDataBinding="conGroup@servletRequest">
				<uix:option textBinding="textKey" valueBinding="textKey"/>
			</uix:contents>
		</uix:choice> 
			</uix:case>
			<uix:case name="edit">
			<uix:flowLayout>
				<uix:formValue 
				  name="consumerGroup" 
				  valueBinding="consumerGroup@rsrcmapBean@servletRequest"/>

                 		<uix:styledText 
		                   styleClass="OraDataText"
		                   textBinding="consumerGroup@rsrcmapBean@servletRequest"/>
			</uix:flowLayout>
			</uix:case>
			</uix:switcher>
		</uix:flowLayout>
               </uix:rowLayout>
             </uix:tableLayout>

                 <uix:header textBinding="pageHeader@rsrcmapBean@servletRequest" />

            <%---------------------------
             -   Oracle Priorities List -
             ---------------------------%>
  	  <uix:tableLayout width="100%" cellSpacing="5"
               renderedBinding="dataAvailability@rsrcmapBean@servletRequest">
           <uix:rowLayout>
              <oem:shuttle 
                name="svalue" 
                size="10"
                reorderable="true"
                leadingHeaderBinding="shuttleLeadingText@rsrcmapBean@servletRequest"
                trailingHeaderBinding="shuttleTrailingText@rsrcmapBean@servletRequest"
                >

                <uix:leading>
                  <oem:list
                    name="availUsers"
                    shortDescBinding="ATTRIBUTE_MAPPINGS@rsrcMapBundle@servletRequest"
                    multiple="true"
                    optionsBinding="availableValues@rsrcmapBean@servletRequest"
                    />
                </uix:leading>

                <uix:trailing>
                  <oem:list
                    name="selUsers"
                    shortDescBinding="ATTRIBUTE_MAPPINGS@rsrcMapBundle@servletRequest"
                    multiple="true"
                    optionsBinding="selectValues@rsrcmapBean@servletRequest"
                    />
                </uix:trailing>

              </oem:shuttle>
           </uix:rowLayout>
  	  </uix:tableLayout> 
<%--- 
code starts here 
----%>
  	  <uix:tableLayout width="100%" cellSpacing="5"
               renderedBinding="showSource@rsrcmapBean@servletRequest">
           <uix:rowLayout>
    <uix:hideShowHeader textBinding="showHideText@rsrcmapBean@servletRequest"
                    renderedBinding="isShowValue@rsrcmapBean@servletRequest"
                    disclosedBinding="statusShowValue@rsrcmapBean@servletRequest"                     
                    formSubmitted="true" id="editData" >                    
             <uix:contents>

				 <uix:table  width="50%"
                           name="otherValue"
                           tableDataBinding="otherValueList@rsrcmapBean@servletRequest"
                           formSubmitted="true" 
                           > 
                   <uix:tableFormat tableBanding="rowBanding"/>
					<uix:column>
						<uix:columnHeader>
							<uix:styledText textBinding="otherValueHeader@rsrcmapBean@servletRequest"/>
						</uix:columnHeader>
						<uix:columnFormat columnDataFormat="textFormat"/>
						<uix:textInput name="name" textBinding="name">
						</uix:textInput>
					</uix:column>
					<uix:column>
						<uix:columnHeader>
              				<uix:styledText textBinding="DELETE@rsrcMapBundle@servletRequest" />
						</uix:columnHeader>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:image onClickBinding="deleteValue"
                                 shortDescBinding="DELETE@rsrcMapBundle@servletRequest"
				 source="<%= request.getContextPath() + \"/images/deleteicon_enabled.gif\" %>"/>
					</uix:column>
					<uix:footer>
					<uix:addTableRow rows="5" 
						shortDescBinding="ADD_ROWS@rsrcMapBundle@servletRequest"
						id="addTableRow3"/>
					</uix:footer>
				 </uix:table>    

             </uix:contents>
            </uix:hideShowHeader>
           </uix:rowLayout>
          </uix:tableLayout>
<%--- 
code ends here 
----%>
<uix:tip renderedBinding="showTip@rsrcmapBean@servletRequest" shortDescBinding="TIP_TEXT@rsrcMapBundle@servletRequest" textBinding="TIP_TEXT@rsrcMapBundle@servletRequest"/> 

          <%-------------------------
           -  PageButtons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton 
                name="event" 
                textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                value="cancelSelect"/>  

              <uix:submitButton
                name="event" 
                textBinding="OK@uixDBObjectBundle@servletRequest"
                shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                value="okSelect"/>



            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

