<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@rsrcmonBean@servletRequest"/>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChoice") %> >
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="monitorForm" 
        method="get"
        destination="/console/database/instance/rsrcmon">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcmon/rsrcmonGeneral"/>

        <uix:pageLayout
          titleBinding="header@rsrcmonBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>



          <%-----------------------------------------
           -  Active Resource Plan Selection        -
           -----------------------------------------%>
            <uix:tableLayout cellSpacing="5" >

            <%-------------  Elapsed Statistics Start Time  ---------------%>
              <uix:rowLayout> 
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                    styleClass="OraPromptText"
                    textBinding="LAST_RESET_PROMPT@rsrcMonitorBundle@servletRequest"
                  />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText 
                    styleClass="OraDataText"
                    textBinding="resetAt@rsrcmonMonitorBean@servletRequest"
                  />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:submitButton 
                    name="event" 
                    textBinding="RESET@rsrcMonitorBundle@servletRequest"
                    value="reset"/>
                </uix:cellFormat>
              </uix:rowLayout>

            <%-------------  Elapsed Statistics Update Setting  ---------------%>
              <uix:rowLayout> 
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                    labeledNodeId="refreshChoice"
                    styleClass="OraPromptText"
                    textBinding="SHOW_ELAPSED_STATISTICS@rsrcMonitorBundle@servletRequest"
                  />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:choice 
                    id="refreshChoice"
                    name="refreshChoice" 
                    onChange="submitForm('configForm', true, {'event':'doLoad','pageNum':'1'})"
                    selectedValueBinding="refreshChoice@servletRequest" >
                      <uix:option
                        textBinding="MANUALLY@rsrcMonitorBundle@servletRequest"
                        value="100000000" />
                      <uix:option
                        textBinding="AUTOMATICALLY_30SEC@rsrcMonitorBundle@servletRequest"
                        value="30"
                        selectedBinding="autoSelected@servletRequest"/>
                  </uix:choice>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:submitButton 
                    name="event" 
                    textBinding="REFRESH@rsrcMonitorBundle@servletRequest"
                    value="showElapsed"/>
                </uix:cellFormat>
              </uix:rowLayout>

            <%-------------  Current Active Plan  ---------------%>
              <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText 
                  styleClass="OraPromptText"
                  textBinding="ACTIVE_PLAN_PROMPT@rsrcMonitorBundle@servletRequest"
                />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:switcher childNameBinding="hasActivePlan@rsrcmonBean@servletRequest">
                  <uix:case name="true">
                    <uix:link
                      textBinding="activePlan@rsrcmonMonitorBean@servletRequest"
                      onClick="submitForm('monitorForm', true, {event:'edit'})"
                    />
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText 
                      styleClass="OraDataText"
                      textBinding="NO_ACTIVE_PLAN@rsrcMonitorBundle@servletRequest"
                    />
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
            </uix:rowLayout>

            <%-------------  Plans Available for Activation  ---------------%>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText 
                  labeledNodeId="selectedPlan"
                  styleClass="OraPromptText"
                  textBinding="AVAILABLE_PLANS_PROMPT@rsrcMonitorBundle@servletRequest"
                />
              </uix:cellFormat>

              <uix:cellFormat>
                <oem:choice
                  id="selectedPlan"
                  name="selectedPlan"
                  selectedValueBinding="selectedPlan@rsrcmonMonitorBean@servletRequest"
                  optionsBinding="alternativePlans@rsrcmonMonitorBean@servletRequest"
                  >
                </oem:choice>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:flowLayout>
                  <uix:submitButton
                    name="event" 
                    textBinding="ACTIVATE@rsrcMonitorBundle@servletRequest"
                    value="activate"
                  />
                </uix:flowLayout>
              </uix:cellFormat>
            </uix:rowLayout> 

          </uix:tableLayout> 

          <%-----------------------------
           -           Charts           -
           -----------------------------%>
          <uix:rowLayout width="80%">

            <uix:cellFormat>
              <%-----------------------------
               -   Consumed CPU Chart    -
               -----------------------------%>
              <oem:chart
                titleBinding="REL_CPU_TIME_CONSUMED@rsrcMonitorBundle@servletRequest"
                chartType="pieChart"
                width="350"
                height="250"
                hideZeroSlices="true"
                showSlicePercentLabels="true"
                legendVisible="true"
                legendPosition="south"
                pieValuesInLegend="percent"
                yAxisNumberFormatBinding="chartNumberFormat@rsrcmonMonitorBean@servletRequest"
                >
                  <oem:boundChartDataSource
                    chartDataSourceBinding="pieChartDataSource@rsrcmonMonitorBean@servletRequest"
                  />
                  <%-- Consumer Group --%>
                  <oem:chartColumn
                    displayLabelBinding="CONSUMER_GROUP@rsrcMonitorBundle@servletRequest"
                    sourceIndex="0"
                    isKey="true"
                  />
                  <%-- Consumed CPU Time --%>
                  <oem:chartColumn
                    displayLabelBinding="CONSUMED_CPU_TIME@rsrcMonitorBundle@servletRequest"
                    sourceIndex="1"
                  />
              </oem:chart>
            </uix:cellFormat>

            <uix:cellFormat>
              <%-----------------------------
               -   CPU Wait Chart    -
               -----------------------------%>
              <oem:chart
                chartType="barChart"
                shadowEffect="3d"
                titleBinding="TOTAL_CPU_WAIT_TIME@rsrcMonitorBundle@servletRequest"
                width="350"
                height="250"
                orientation="horizontal"
                >
                  <oem:boundChartDataSource
                    chartDataSourceBinding="barChartDataSource@rsrcmonMonitorBean@servletRequest"
                  />
                  <%-- Consumer Group --%>
                  <oem:chartColumn
                    displayLabelBinding="CONSUMER_GROUP@rsrcMonitorBundle@servletRequest"
                    sourceIndex="0"
                    isKey="true"
                  />
                  <%-- CPU Wait Time --%>
                  <oem:chartColumn
                    displayLabelBinding="CPU_WAIT_TIME@rsrcMonitorBundle@servletRequest"
                    sourceIndex="2"
                  />
              </oem:chart>
            </uix:cellFormat>

          </uix:rowLayout>

          <%-----------------------
           -   Statistics Table   -
           ------------------------%>
          <uix:header 
            textBinding="CONSUMER_GROUP_STATISTICS@rsrcMonitorBundle@servletRequest"
            >
            <oem:table 
              summaryBinding="CONSUMER_GROUP_STATISTICS@rsrcMonitorBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSize="25"
              formSubmitted="true"
              name="statisticsTable" 
              dataSourceProp="statisticsTable"
              beanKey="rsrcmonMonitorBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>
          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>
