<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>
<%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChoice") %> >
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="monitorForm" 
        method="get"
        destination="/console/database/instance/rsrcmon">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcmon/rsrcmonGeneralPage"/>

        <uix:pageLayout
          titleBinding="header@rsrcmonBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
<uix:messages>
<uix:stackLayout>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>



          <%-----------------------------------------
           -  Active Resource Plan Selection        -
           -----------------------------------------%>
            <uix:tableLayout width="100%" >
	    <uix:rowLayout>
	    <uix:cellFormat hAlign="center">
            <uix:tableLayout cellSpacing="2" width="35%">
	    <uix:rowLayout>
	    <uix:cellFormat>
	    <uix:spacer height="5" />
	    </uix:cellFormat>
	    <uix:cellFormat>
	    <uix:spacer height="5" />
	    </uix:cellFormat>
	    </uix:rowLayout>
	    <uix:rowLayout>
	    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:styledText 
                  styleClass="OraPromptText"
                  textBinding="ACTIVE_PLAN_PROMPT@rsrcMonitorBundle@servletRequest"
                />
	    </uix:cellFormat>
	    <uix:cellFormat hAlign="left">
                <uix:switcher childNameBinding="hasActivePlan@rsrcmonBean@servletRequest">
                  <uix:case name="true">
                    <uix:link
                      textBinding="activePlan@rsrcmonMonitorBean@servletRequest"
                      onClickBinding="editAllocURL@servletRequest"
                    />
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText 
                      styleClass="OraDataText"
                      textBinding="NO_ACTIVE_PLAN@rsrcMonitorBundle@servletRequest"
                    />
                  </uix:case>
                </uix:switcher>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>


          <%-----------------------
           -   Statistics Table   -
           ------------------------%>
          <uix:header 
            textBinding="CONSUMER_GROUP_STATISTICS@rsrcMonitorBundle@servletRequest"
            >
            <uix:tableLayout cellSpacing="5" width="100%"  >


              <uix:rowLayout> 
                <uix:cellFormat hAlign="right">
		<uix:tableLayout  width="100%">
		<uix:rowLayout> 
                <uix:cellFormat hAlign="left">
          <%-----------------------
		<uix:flowLayout>
                  <uix:styledText 
                    labeledNodeId="refreshChoice"
                    styleClass="OraPromptText"
                    textBinding="MONITOR_PERIOD@rsrcMonitorBundle@servletRequest"
                  />
		  <uix:spacer width="5" />
                  <uix:styledText 
                    labeledNodeId="refreshChoice"
                    styleClass="OraDataText"
                    textBinding="REAL_TIME@rsrcMonitorBundle@servletRequest"
                  />
		  </uix:flowLayout>
           ------------------------%>
		</uix:cellFormat>
                <uix:cellFormat hAlign="right">
		<uix:flowLayout>
          <%-----------------------
                <uix:switcher childNameBinding="ioCalibrationStatus@rsrcmonMonitorBean@servletRequest">
                  <uix:case name="IN_PROGRESS">
                  <uix:submitButton 
                    name="event" 
                    textBinding="CALIBRATE_IO@rsrcMonitorBundle@servletRequest"
                    value="calibrate" disabled="true"/>
		  </uix:case>
		  <uix:default>
                  <uix:submitButton 
                    name="event" 
                    textBinding="CALIBRATE_IO@rsrcMonitorBundle@servletRequest"
                    value="calibrate"/>
		  </uix:default>
		  </uix:switcher>
           ------------------------%>
          <uix:styledText styleClass="OraTipText"
            textBinding="PAGE_REFRESHED_TIME@rsrcMonitorBundle@servletRequest"/>
          <uix:spacer width="5" />
          <uix:styledText styleClass="OraTipLabel"
            textBinding="refreshTime@servletRequest"/>
          <uix:spacer width="10" />
                  <uix:submitButton 
                    name="event" 
                    textBinding="REFRESH@rsrcMonitorBundle@servletRequest"
                    shortDescBinding="REFRESH@rsrcMonitorBundle@servletRequest"
                    value="showElapsed"/>
          <uix:spacer width="5" />
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="VIEW_DATA@rsrcMonitorBundle@servletRequest"
                  />
          <uix:spacer width="5" />
                  <uix:choice 
                    id="refreshChoice"
                    name="refreshChoice" 
                    onChange="submitForm('monitorForm', true, {event:'showElapsed'})"
                    selectedValueBinding="refreshChoice@servletRequest" >
                      <uix:option
                        textBinding="MANUALLY@rsrcMonitorBundle@servletRequest"
                        value="100000000" />
                      <uix:option
                        textBinding="AUTOMATICALLY_60SEC@rsrcMonitorBundle@servletRequest"
                        value="60"
                        selectedBinding="autoSelected@servletRequest"/>
                  </uix:choice>
		    </uix:flowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
	      </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>


            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
          <uix:header 
            textBinding="CPU_SCHEDULING@rsrcMonitorBundle@servletRequest"
            >
            <uix:tableLayout cellSpacing="5" >
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
          	<uix:header 
            	textBinding="REL_CPU_TIME_CONSUMED@rsrcMonitorBundle@servletRequest"
            	>
		<oem:chart 
                    chartType="timeSeriesChart"
                    width="700"
                    height="200"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    fill="cumulative"  
                    yAxisLabelBinding="CONSUMED_CPU_TIME@rsrcMonitorBundle@servletRequest"
		    axisMaxBinding="maxRelCPUTimeConsumed@rsrcmonMonitorBean@servletRequest"
		    yAxisNumberFormatBinding="chartNumberFormat@rsrcmonMonitorBean@servletRequest"
              	    legendPosition="east">
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="relCPUTimeConsumedDS@rsrcmonMonitorBean@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
		
		<oem:imageMap imageMapDataSourceBinding="legendData@servletRequest" />
            </oem:chart>              
            </uix:header>
	    </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
          	<uix:header 
            	textBinding="NUMBER_IO_REQUESTS_ISSUED@rsrcMonitorBundle@servletRequest">
		<oem:chart 
                    chartType="timeSeriesChart"
                    width="700"
                    height="200"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    fill="cumulative"  
                    yAxisLabelBinding="IO_REQUESTS_ISSUED@rsrcMonitorBundle@servletRequest"
		    axisMaxBinding="maxIoRequests@rsrcmonMonitorBean@servletRequest"
		    yAxisNumberFormatBinding="chartNumberFormat@rsrcmonMonitorBean@servletRequest"
              	    legendPosition="east">
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="ioRequestsDS@rsrcmonMonitorBean@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
		<oem:imageMap imageMapDataSourceBinding="legendData@servletRequest" />
            </oem:chart>              
            </uix:header>
	    </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
          	<uix:header 
            	textBinding="BYTES_IO_ISSUED@rsrcMonitorBundle@servletRequest"
            	>
		<oem:chart 
                    chartType="timeSeriesChart"
                    width="700"
                    height="200"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    fill="cumulative"  
                    yAxisLabelBinding="BYTES_IO_ISSUED_UNIT@rsrcMonitorBundle@servletRequest"
		    axisMaxBinding="maxBytesIoIssued@rsrcmonMonitorBean@servletRequest"
		    yAxisNumberFormatBinding="chartNumberFormat@rsrcmonMonitorBean@servletRequest"
              	    legendPosition="east">
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="bytesIoIssuedDS@rsrcmonMonitorBean@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
		<oem:imageMap imageMapDataSourceBinding="legendData@servletRequest" />
            </oem:chart>              
            </uix:header>
	    </uix:cellFormat>
            </uix:rowLayout>
            </uix:tableLayout> 
	     </uix:header>


	      </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">

          <uix:header 
            textBinding="IO_SCHEDULING@rsrcMonitorBundle@servletRequest"
            >
            <uix:tableLayout cellSpacing="5" >
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
          	<uix:header 
            	textBinding="TOTAL_CPU_WAIT_TIME@rsrcMonitorBundle@servletRequest"
            	>
		<oem:chart 
                    chartType="timeSeriesChart"
                    width="700"
                    height="200"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    fill="cumulative"  
                    yAxisLabelBinding="CPU_WAIT_TIME@rsrcMonitorBundle@servletRequest"
		    yAxisNumberFormatBinding="chartNumberFormat@rsrcmonMonitorBean@servletRequest"
		    axisMaxBinding="maxTotalCPUWaitTime@rsrcmonMonitorBean@servletRequest"
              	    legendPosition="east">
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="totalCPUWaitTimeDS@rsrcmonMonitorBean@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
		<oem:imageMap imageMapDataSourceBinding="legendData@servletRequest" />
            </oem:chart>              
            </uix:header>
	    </uix:cellFormat>
            </uix:rowLayout> 
<%--
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
          	<uix:header 
            	textBinding="IO_WAIT_TIME@rsrcMonitorBundle@servletRequest"
            	>
		<oem:chart 
                    chartType="timeSeriesChart"
                    width="700"
                    height="200"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    fill="cumulative"  
                    yAxisLabelBinding="IO_WAIT_TIME@rsrcMonitorBundle@servletRequest"
		    axisMaxBinding="maxIoWaitTime@rsrcmonMonitorBean@servletRequest"
		    yAxisNumberFormatBinding="chartNumberFormat@rsrcmonMonitorBean@servletRequest"
              	    legendPosition="east">
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="ioWaitTimeDS@rsrcmonMonitorBean@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
		<oem:imageMap imageMapDataSourceBinding="legendData@servletRequest" />
            </oem:chart>              
            </uix:header>
	    </uix:cellFormat>
              <uix:cellFormat hAlign="right">
	    </uix:cellFormat>
            </uix:rowLayout> 
--%>
            </uix:tableLayout> 
	    </uix:header>
	    </uix:cellFormat>
            </uix:rowLayout> 

<%--
            <uix:rowLayout> 
	    <uix:cellFormat>
	    	<uix:header 
            	textBinding="IO_CALIBRATION@rsrcMonitorBundle@servletRequest"
            	>
		  <uix:table name="ALL"
			 width="100%"
			 tableDataBinding="ioCalibrationsTable@rsrcmonMonitorBean@servletRequest"
			 formSubmitted="true"
			 showAll="yes"
			 alternateTextBinding = "NO_ITEMS_FOUND@rsrcMonitorBundle@servletRequest">
			 <uix:tableFormat tableBanding="rowBanding"/>
			 
			 <uix:column>
                         <uix:columnFormat columnDataFormat="textFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="STATUS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="calibStatus"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="START_DATE@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="calibStartDate"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="END_DATE@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="calibEndDate"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="MAX_IOPS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="calibMbps"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="MAX_MBPS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="calibIops"/>
			  </uix:column>

		  </uix:table>
		 </uix:header>

	    </uix:cellFormat>
            </uix:rowLayout> 
--%>
            <uix:rowLayout> 
	    <uix:cellFormat>
	    	<uix:header 
            	textBinding="QUEUED_SESSIONS@rsrcMonitorBundle@servletRequest"
            	>
		  <uix:table name="ALL"
			 width="100%"
			 tableDataBinding="queuedSessionsTable@servletRequest"
			 formSubmitted="true"
			 showAll="yes"
			 alternateTextBinding = "NO_ITEMS_FOUND@rsrcMonitorBundle@servletRequest">
			 <uix:tableFormat tableBanding="rowBanding"/>
			 
			 <uix:column>
                         <uix:columnFormat columnDataFormat="textFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="CONSUMER_GROUP@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
                    		<uix:link textBinding="consumerGroup" destinationBinding="cgURL" />

			  </uix:column>

			 <uix:columnGroup>
			 <uix:columnHeader>
				<uix:styledText textBinding="CONFIGURED_LIMITS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="MAX_RUN_SESSIONS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="maxRunningSessions"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="QUEUE_TIMEOUT@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="queueTimeout"/>
			  </uix:column>

			 </uix:columnGroup>
			 <uix:columnGroup>
			 <uix:columnHeader>
				<uix:styledText textBinding="STATISTICS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="CURRENT_QUEUED_SESSIONS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="queuedSessions"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="TOTAL_QUEUED_SESSIONS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="cummulativeQueuedSessions"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="TIME_IN_QUEUE@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="timeInQueue"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="QUEUE_TIMEOUTS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="queueTimeOuts"/>
			  </uix:column>
			 </uix:columnGroup>

		  </uix:table>
		 </uix:header>

	    </uix:cellFormat>
            </uix:rowLayout> 
            <uix:rowLayout> 
	    <uix:cellFormat>
	    	<uix:header 
            	textBinding="THRESHOLDS@rsrcMonitorBundle@servletRequest"
            	>
		  <uix:table name="ALL"
			 width="100%"
			 tableDataBinding="thresholdsTable@servletRequest"
			 formSubmitted="true"
			 showAll="yes"
			 alternateTextBinding = "NO_ITEMS_FOUND@rsrcMonitorBundle@servletRequest">
			 <uix:tableFormat tableBanding="rowBanding"/>
			 
			 <uix:column>
                         <uix:columnFormat columnDataFormat="textFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="CONSUMER_GROUP@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
                    <uix:link textBinding="consumerGroup" destinationBinding="cgURL" />

			  </uix:column>

			 <uix:columnGroup>
			 <uix:columnHeader>
				<uix:styledText textBinding="CONFIGURED_LIMITS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="SWITCH_TIME@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="limitForExecTime"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="IO_REQUESTS_ISSUED@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="ioRequests"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="BYTES_IO@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="ioMegabytes"/>
			  </uix:column>
			 </uix:columnGroup>

			 <uix:columnGroup>
			 <uix:columnHeader>
				<uix:styledText textBinding="STATISTICS@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="SWITCH_INTO_GROUP@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="switchesIntoCG"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="SWITCH_OUT_GROUP@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="switchesOutCG"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="ACTIVE_SESSIONS_KILLED@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="sessionsKilled"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="CALL_CANCELLED@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="callsCancelled"/>
			  </uix:column>
			 </uix:columnGroup>


		  </uix:table>
		 </uix:header>

	    </uix:cellFormat>
            </uix:rowLayout> 



            <uix:rowLayout> 
	    <uix:cellFormat>
	    	<uix:header 
            	textBinding="IDLE@rsrcMonitorBundle@servletRequest"
            	>
		  <uix:table name="ALL"
			 width="100%"
			 tableDataBinding="idleSessionsTable@servletRequest"
			 formSubmitted="true"
			 showAll="yes"
			 alternateTextBinding = "NO_ITEMS_FOUND@rsrcMonitorBundle@servletRequest">
			 <uix:tableFormat tableBanding="rowBanding"/>
			 
			 <uix:column>
                         <uix:columnFormat columnDataFormat="textFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="CONSUMER_GROUP@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
                    <uix:link textBinding="consumerGroup" destinationBinding="cgURL" />

			  </uix:column>

			 <uix:columnGroup>
			 <uix:columnHeader>
				<uix:styledText textBinding="IDLE_BLOCKER_LIMIT@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="MAX_IDLE_BLOCKER_TIME@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="maxIdleTimeBlockingSessions"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="BLOCKER_SESSIONS_KILLED@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="blockingSessionsKilled"/>
			  </uix:column>
			  </uix:columnGroup>

			<uix:columnGroup>
			 <uix:columnHeader>
				<uix:styledText textBinding="IDLE_LIMIT@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="MAX_IDLE_TIME@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="maxIdleTime"/>
			  </uix:column>

			 <uix:column>
                         <uix:columnFormat columnDataFormat="numberFormat" /> 
			 <uix:columnHeader>
				<uix:styledText textBinding="IDLE_SESSIONS_KILLED@rsrcMonitorBundle@servletRequest"/> 
			 </uix:columnHeader>
			 <uix:styledText styleClass="OraText" textBinding="idleSessionsKilled"/>
			  </uix:column>
			  </uix:columnGroup>

		  </uix:table>
		 </uix:header>

	    </uix:cellFormat>
            </uix:rowLayout> 

            </uix:tableLayout> 
          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>
