<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@rsrcplnBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="activateConfirmation" 
        method="post" 
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest"
        >

        <uix:pageLayout messageType="confirmation" >

          <uix:formValue 
            name="pageName" 
            value="/database/instance/rsrcpln/rsrcplnActivateConfirmation"/>

          <uix:formValue 
            name="oname" 
            valueBinding="oname@servletRequest" />
          <uix:formValue 
            name="otype" 
            valueBinding="otype@servletRequest" />
          <uix:formValue 
            name="backURL" 
            valueBinding="backURL@servletRequest" />
          <uix:formValue 
            name="cancelURL" 
            valueBinding="cancelURL@servletRequest" />

          <%-------------------------
           -  Confirmation Message
           ---------------------------%>
          <uix:stackLayout>
            <uix:rowLayout>
              <uix:spacer width="40"/>
              <uix:styledText 
                styleClass="OraDataText"
                textBinding="msgText@msgTable@servletRequest"/>
            </uix:rowLayout>
          </uix:stackLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
               
              <uix:button 
                textBinding="NO@uixDBObjectBundle@servletRequest"
                destinationBinding="backURL@servletRequest" 
                />  

              <uix:submitButton 
                textBinding="YES@uixDBObjectBundle@servletRequest" 
                name="event" 
                valueBinding="yesEventValue@servletRequest" 
                formName="activateConfirmation"
                />  
                
            </uix:pageButtonBar>
          </uix:pageButtons>
            
        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

