<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-------------------------------------------
-  Advanced Features tab -- 10i or greater
---------------------------------------------%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@rsrcplnBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="planForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcpln/rsrcplnAdvFeatures"/>

        <uix:pageLayout
          titleBinding="header@rsrcplnBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>
<uix:messages>

          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:contents>
                  <uix:link textBinding="GENERAL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'generalTab'})"/>
                  <uix:link textBinding="ADVANCED_FEATURES@rsrcPlanBundle@servletRequest"/>
                 </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

          <%-------------------------
           -  Alligned Method Fields
           ---------------------------%>
            <uix:tableLayout cellSpacing="5" >

              <uix:rowLayout>
                <%---  Prompt  ---%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText
                    styleClass="OraPromptText"
                    labeledNodeId="cpuMthChoice"
                    textBinding="CPU_METHOD_PROMPT@rsrcPlanBundle@servletRequest"/>
                </uix:cellFormat>

                <%---  Field  ---%>
                <uix:cellFormat>
                  <oem:choice
                    id="cpuMthChoice"
                    name="cpuMthChoice"
                    selectedValueBinding="cpuMthChoice@rsrcplnPlanBean@servletRequest"
                    optionsBinding="cpuMthChoices@rsrcplnPlanBean@servletRequest"
                    >
                  </oem:choice>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <%---  Prompt  ---%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText
                    styleClass="OraPromptText"
                    labeledNodeId="activeSessPoolMthChoice"
                    textBinding="ACTIVE_SESSION_POOL_METHOD_PROMPT@rsrcPlanBundle@servletRequest"/>
                </uix:cellFormat>

                <%---  Field  ---%>
                <uix:cellFormat>
                  <oem:choice
                    id="activeSessPoolMthChoice"
                    name="activeSessPoolMthChoice"
                    selectedValueBinding="activeSessPoolMthChoice@rsrcplnPlanBean@servletRequest"
                    optionsBinding="activeSessPoolMthChoices@rsrcplnPlanBean@servletRequest"
                    >
                  </oem:choice>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>

          <%---------------------------
           -   Directive Table    -
           ---------------------------%>

            <uix:header 
              textBinding="GROUP_DIRECTIVES@rsrcPlanBundle@servletRequest"
              >

              <%--- User Table ---%>
              <oem:table 
                summaryBinding="GROUP_DIRECTIVES@rsrcPlanBundle@servletRequest"
                copyParams="target,type,cancelURL,oname,otype"
                width="80%" 
                blockSize="10"
                formSubmitted="true"
                name="groupDirectiveTable"
                beanKey="rsrcplnGroupDirectiveBean"
                dataSourceProp="groupDirectiveTable"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                >
              </oem:table>

            </uix:header>

          <%---------------------------
           -   CPU Allocation Table    -
           ---------------------------%>

            <uix:header 
              textBinding="CPU_RSRC_ALLOC@rsrcPlanBundle@servletRequest"
              >

              <%--- CPU allocation Table ---%>
              <oem:table 
                summaryBinding="CPU_RSRC_ALLOC@rsrcPlanBundle@servletRequest"
                copyParams="target,type,cancelURL,oname,otype"
                width="80%" 
                blockSize="10"
                formSubmitted="true"
                name="cpuAllocTable"
                beanKey="rsrcplnCpuAllocBean"
                dataSourceProp="cpuAllocTable"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                >
              </oem:table>

            </uix:header>

          </uix:subTabLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton
                name="event" 
                textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                value="showSql"/>

              <uix:switcher childNameBinding="creating@rsrcplnBean@servletRequest">
                <uix:case name="true">
                    <uix:submitButton 
                      name="event" 
                      textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                      value="cancel"/>  
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton 
                      name="event" 
                      textBinding="REVERT@uixDBObjectBundle@servletRequest"
                      value="revert"/>  
                </uix:case>
              </uix:switcher>

              <uix:switcher childNameBinding="creating@rsrcplnBean@servletRequest">
                <uix:case name="true">
                    <uix:submitButton
                      name="event" 
                      textBinding="OK@uixDBObjectBundle@servletRequest"
                      value="apply"/>
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton
                      name="event" 
                      textBinding="APPLY@uixDBObjectBundle@servletRequest"
                      value="apply"/>
                </uix:case>
              </uix:switcher>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

