<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@rsrcplnBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="planForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcpln/rsrcplnExecutionTime"/>

        <uix:pageLayout
          titleBinding="header@rsrcplnBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="4">
                <uix:contents>
                  <uix:link textBinding="GENERAL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'generalTab'})"/>
                  <uix:link textBinding="PARALLELISM@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'parallelismTab'})"/>
                  <uix:link textBinding="SESSION_POOL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'sessionPoolTab'})"/>
                  <uix:link textBinding="UNDO_POOL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'undoPoolTab'})"/>
                  <uix:link textBinding="EXECUTION_TIME@rsrcPlanBundle@servletRequest"/>
                  <uix:link textBinding="GROUP_SWITCHING@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'groupSwitchingTab'})"/>

                  <%--- Only for 10i or higher  ---%>
                  <uix:switcher childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                    <uix:case name="false">
                      <uix:link textBinding="IDLE_TIME@rsrcPlanBundle@servletRequest"
                         onClick="submitForm('planForm', true, {event:'idleTimeTab'})"/>
                    </uix:case>
                  </uix:switcher>

                 </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

            <%---------------------------
             -   Instruction Text
             ---------------------------%>
            <uix:stackLayout>
              <uix:spacer height="5"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="RSRC_EXECUTION_TIME_INSTR@rsrcPlanBundle@servletRequest"
                />
              <uix:spacer height="5"/>
            </uix:stackLayout>

            <%---------------------------
             -   Execution Time Table    -
             ---------------------------%>

            <oem:table 
              copyParams="target,type,cancelURL,oname,otype"
              summaryBinding="EXECUTION_TIME@rsrcPlanBundle@servletRequest"
              width="80%" 
              blockSize="25"
              formSubmitted="true"
              name="executionTimeTable" 
              beanKey="rsrcplnExecutionTimeBean"
              dataSourceProp="executionTimeTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>

          </uix:subTabLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

