<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="planForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcpln/rsrcplnGeneral"/>

        <uix:pageLayout
          titleBinding="header@rsrcplnBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>
<uix:messages>
<uix:stackLayout>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>

          <uix:subTabLayout>

            <%-------------------------
             -  Subtabs
             ---------------------------%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:contents>

                <uix:link textBinding="GENERAL@rsrcPlanBundle@servletRequest"/>

                <uix:link textBinding="PARALLELISM@rsrcPlanBundle@servletRequest"
                   onClick="submitForm('planForm', true, {event:'parallelismTab'})"/>

                <%--- Only for 9.0.1 or higher  ---%>
                <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                  <uix:case name="false">
                    <uix:link textBinding="SESSION_POOL@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'sessionPoolTab'})"/>
                  </uix:case>
                </uix:switcher>

                <%--- Only for 9.0.1 or higher  ---%>
                <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                  <uix:case name="false">
                    <uix:link textBinding="UNDO_POOL@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'undoPoolTab'})"/>
                  </uix:case>
                </uix:switcher>

                <%--- Only for 9.0.1 or higher  ---%>
                <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                  <uix:case name="false">
			<uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
				<uix:case name="false">
				<uix:flowLayout>
					<uix:link textBinding="EXECUTION_TIME@rsrcPlanBundle@servletRequest"
						onClick="submitForm('planForm', true, {event:'executionTimeTab'})"/>
					<uix:spacer width="25" height="0" />
                    			<uix:link textBinding="GROUP_SWITCHING@rsrcPlanBundle@servletRequest"
			                       onClick="submitForm('planForm', true, {event:'groupSwitchingTab'})"/>
				</uix:flowLayout>
				</uix:case>
				<uix:default>
                    			<uix:link textBinding="THRESHOLD@rsrcPlanBundle@servletRequest"
			                       onClick="submitForm('planForm', true, {event:'groupSwitchingTab'})"/>
				</uix:default>
			</uix:switcher>
                  </uix:case>
                </uix:switcher>

                <%--- Only for 10i or higher  ---%>
                <uix:switcher childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                  <uix:case name="false">
                    <uix:link textBinding="IDLE_TIME@rsrcPlanBundle@servletRequest"
                       onClick="submitForm('planForm', true, {event:'idleTimeTab'})"/>
                  </uix:case>
                </uix:switcher>

                 </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

            <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="10">
              <uix:rowLayout> 
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="RSRC_GEN_INSTR@rsrcPlanBundle@servletRequest"
                  />
              </uix:rowLayout> 
            </uix:tableLayout>
            <uix:spacer height="10"/>

            <%---------------------%>
            <%---  Plan Name    ---%>
            <%---------------------%>
            <uix:spacer height="5"/>
              <%---  Prompt  ---%>
              <uix:switcher childNameBinding="creating@rsrcplnBean@servletRequest">
                <%---  CREATE  ---%>
                <uix:case name="true">
            <uix:labeledFieldLayout width="70%">
                  <uix:messagePrompt
                    labeledNodeId="planName"
                    required="yes"
                    promptBinding="PLAN_PROMPT@rsrcPlanBundle@servletRequest"/>
                  <uix:stackLayout>
                    <uix:messageTextInput 
                      id="planName"
                      name="planName"
                      textBinding="planName@rsrcplnPlanBean@servletRequest"
                      columns="50"/>
                    <uix:messageText
                      messageBinding="Plan Name@errors@servletRequest"
                      messageType="error"/>
                  </uix:stackLayout>
            </uix:labeledFieldLayout>
                </uix:case>
                <%---  EDIT  ---%>
                <uix:case name="false">
            <uix:labeledFieldLayout width="70%">
                  <uix:messagePrompt
                    promptBinding="PLAN_PROMPT@rsrcPlanBundle@servletRequest"/>
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="planName@rsrcplnPlanBean@servletRequest"/>
            </uix:labeledFieldLayout>
                </uix:case>
              </uix:switcher>

              <%---  Field  ---%>
              <%---  group name field is *read-only* in edit mode ---%>

            <%--------------------------%>
            <%---  Plan Description  ---%>
            <%--------------------------%>
            <uix:spacer height="5"/>
            <uix:labeledFieldLayout width="70%">
              <%---  Prompt  ---%>
              <uix:styledText
                labeledNodeId="description"
                styleClass="OraPromptText"
                textBinding="DESCRIPTION_PROMPT@rsrcPlanBundle@servletRequest"/>

              <%---  Field  ---%>
              <uix:textInput 
                id="description"
                name="description"
                textBinding="description@rsrcplnPlanBean@servletRequest"
                columns="50"/>
            </uix:labeledFieldLayout>
            <uix:spacer height="5"/>


            <%-------------------------
             -  Plan Activation  ( for RAC, or Pre-10.2 )
             ---------------------------%>
            <uix:switcher childNameBinding="isRac@servletRequest"> 
              <uix:case name="true"> <%-- RAC Case --%>

                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="INSTANCES@racRsrcPlanBundle@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat>
                      <uix:stackLayout>
                        <uix:rowLayout>
                          <uix:styledText
                            styleClass="OraDataText"
                            textBinding="activeInstances@rsrcplnPlanBean@servletRequest"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton 
                            textBinding="EDITACTINST@racRsrcPlanBundle@servletRequest" 
                            name="event" value="editActiveInstance"/>
                        </uix:rowLayout>

                        <uix:styledText 
                          styleClass="OraInlineInfoText" 
                          textBinding="ACT_INST_HINT@racRsrcPlanBundle@servletRequest"/>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

              </uix:case> <%-- End of RAC case --%>

              <uix:default> <%-- Non RAC --%>
                <uix:spacer height="5"/>
                <uix:labeledFieldLayout width="70%">
                <%-- Non RAC --%>
                <%---  Prompt  ---%>
                  <uix:styledText
                    styleClass="OraPromptText"
                    text=""
                    />

                <%---  Field  ---%>
		<uix:flowLayout>
                  <uix:checkBox
                    name="activated"
		    id="activated"
                    checkedBinding="activated@rsrcplnPlanBean@servletRequest"
   		    onClick="submitForm('planForm', true,{event:'changePlnActivate'})"
                    />
                  <uix:styledText
                    styleClass="OraPromptText"
		    labeledNodeId="activated"
                    textBinding="ACTIVATE_PLAN_PROMPT@rsrcPlanBundle@servletRequest"
                    />
		</uix:flowLayout>
                </uix:labeledFieldLayout>
              </uix:default> <%-- End of Non RAC case --%>

            </uix:switcher>

            <%-------------------------
             -  Plan Activation  ( for Non-RAC, 10.2 or Later )
             ---------------------------%>
            <uix:switcher 
              childNameBinding="isRac@servletRequest"> 

              <uix:case name="true"> <%-- RAC Case --%>
                <uix:styledText
                  styleClass="OraPromptText"
                  text=""
                  />
              </uix:case> <%-- End of RAC case --%>

              <uix:default> <%-- Non RAC --%>

                <uix:switcher 
                  childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
		  <uix:flowLayout>
                  <uix:spacer height="5"/>
                  <uix:labeledFieldLayout width="80%">
                    <%---  Prompt  ---%>
                    <uix:styledText
                      styleClass="OraPromptText"
                      text=""
                      />

		    <uix:tableLayout>
		    <uix:cellFormat wrappingDisabled="true">
		    <uix:styledText
                      styleClass="OraPromptText"
                      text=""
                      />
		    </uix:cellFormat>

                    <%---  Field  ---%>
		    <uix:cellFormat wrappingDisabled="true" width="80%">
		    <uix:flowLayout>
                    <uix:checkBox
                      name="autoSwitchPlans"
                      id="autoSwitchPlans"
                      checkedBinding="autoSwitchPlans@rsrcplnPlanBean@servletRequest"
		      disabledBinding="activateDisabled@rsrcplnPlanBean@servletRequest"
                      />
		    <uix:styledText
                      labeledNodeId="autoSwitchPlans"
                      styleClass="OraPromptText"
                      textBinding="AUTO_PLAN_SWITCH_ENABLED@rsrcPlanBundle@servletRequest"
                      />
		    </uix:flowLayout>
		    </uix:cellFormat>
		    </uix:tableLayout>
                  </uix:labeledFieldLayout>

                  <uix:spacer height="5"/>

		  </uix:flowLayout>
		  </uix:case>
		  <uix:default>
                <uix:switcher 
                  childNameBinding="dbVersionPre102@rsrcplnBean@servletRequest">
                  <uix:case name="false">
                  <%-- 10.2 and later (Automatic Plan Switching Control) --%>
                  <uix:spacer height="5"/>
                  <uix:labeledFieldLayout width="70%">
		  <uix:cellFormat wrappingDisabled="true">
		  <uix:flowLayout>
                    <%---  Prompt  ---%>
                    <uix:styledText
                      styleClass="OraPromptText"
                      text=""
                      />

                    <uix:checkBox
                      name="autoSwitchPlans"
                      textBinding="AUTO_PLAN_SWITCH_ENABLED@rsrcPlanBundle@servletRequest"
                      checkedBinding="autoSwitchPlans@rsrcplnPlanBean@servletRequest"
                      />
		      </uix:flowLayout>
		      </uix:cellFormat>
                  </uix:labeledFieldLayout>
                  </uix:case>
                </uix:switcher>
		</uix:default>
		</uix:switcher>

              </uix:default> <%-- End of Non RAC case --%>

            </uix:switcher>




            <%---------------------------
             -   Directive Table        -
             ---------------------------%>

            <uix:header 
              textBinding="SELECTED_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
              >

            <%----------------------------
             -   Mode of Directive Table -
             ----------------------------%>
                <uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
	     <uix:stackLayout>
	     <uix:rowLayout>
              <uix:styledText
                styleClass="OraPromptText"
                textBinding="MODE@rsrcPlanBundle@servletRequest"/>

   	     	<uix:radioButton 
			name="planMode" 
			id="planMode1"
			selectedValueBinding="planMode@rsrcplnPlanBean@servletRequest" 
			value="PERCENTAGE" 
			onClick="submitForm('planForm', true, {event:'changeMode'})"/>
              <uix:styledText
                labeledNodeId="planMode1"
                styleClass="OraPromptText"
                textBinding="PERCENTAGE@rsrcPlanBundle@servletRequest" />

	     	<uix:radioButton name="planMode" selectedValueBinding="planMode@rsrcplnPlanBean@servletRequest" value="ADVANCED" 
			id="planMode2"
			onClick="submitForm('planForm', true, {event:'changeMode'})"/>
              <uix:styledText
                labeledNodeId="planMode2"
                styleClass="OraPromptText"
                textBinding="ADVANCED@rsrcPlanBundle@servletRequest" />
		
	     </uix:rowLayout>
	     </uix:stackLayout>
                  </uix:case>
                </uix:switcher>

              <%---  Modify Button  ---%>
              <uix:tableLayout width="80%"> 
                <uix:rowLayout hAlign="right"> 
                  <uix:cellFormat> 
                    <uix:contents> 
                      <uix:submitButton 
                        textBinding="MODIFY@rsrcPlanBundle@servletRequest"
                        shortDescBinding="MODIFY@rsrcPlanBundle@servletRequest"
                        name="event"
                        value="selectButton" 
                        formName="planForm"
                      />
                    </uix:contents> 
                  </uix:cellFormat> 
                </uix:rowLayout> 
              </uix:tableLayout> 

              <%--- User Table ---%>
              <oem:table 
                summaryBinding="SELECTED_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
                copyParams="target,type,cancelURL,oname,otype"
                width="80%" 
                blockSize="25"
                formSubmitted="true"
                name="cpuAllocTable" 
                id="cpuAllocTable" 
                dataSourceProp="cpuAllocTable"
                beanKey="rsrcplnCpuAllocBean"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                >
              </oem:table>

            </uix:header>

          </uix:subTabLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

