<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="planForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcpln/rsrcplnGroupSwitching"/>

        <uix:pageLayout
          titleBinding="header@rsrcplnBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:stackLayout>	    
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndexBinding="groupSwitchingIndex@rsrcplnBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="GENERAL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'generalTab'})"/>
                  <uix:link textBinding="PARALLELISM@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'parallelismTab'})"/>
                  <uix:link textBinding="SESSION_POOL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'sessionPoolTab'})"/>
                  <uix:link textBinding="UNDO_POOL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'undoPoolTab'})"/>

                <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                  <uix:case name="false">
			<uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
				<uix:case name="false">
					<uix:link textBinding="EXECUTION_TIME@rsrcPlanBundle@servletRequest"
						onClick="submitForm('planForm', true, {event:'executionTimeTab'})"/>
				</uix:case>
				<uix:default>
                  			<uix:link textBinding="THRESHOLD@rsrcPlanBundle@servletRequest"/>
				</uix:default>
			</uix:switcher>
                  </uix:case>
                </uix:switcher>

                <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                  <uix:case name="false">
			<uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
				<uix:case name="false">
                  			<uix:link textBinding="GROUP_SWITCHING@rsrcPlanBundle@servletRequest"/>
				</uix:case>
				<uix:default>
                      			<uix:link textBinding="IDLE_TIME@rsrcPlanBundle@servletRequest"
                         			onClick="submitForm('planForm', true, {event:'idleTimeTab'})"/>
				</uix:default>
			</uix:switcher>
                  </uix:case>
                </uix:switcher>


                  <%--- Only for 10i or higher  ---%>
                  <uix:switcher childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                    <uix:case name="false">
			<uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
				<uix:case name="false">
                      <uix:link textBinding="IDLE_TIME@rsrcPlanBundle@servletRequest"
                         onClick="submitForm('planForm', true, {event:'idleTimeTab'})"/>
                    </uix:case>
                  </uix:switcher>
                    </uix:case>
                  </uix:switcher>

                 </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

            <%---------------------------
             -   Instruction Text
             ---------------------------%>
            <uix:stackLayout>
              <uix:spacer height="5"/>
                <uix:switcher childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                  <uix:case name="true">
                    <%--- Only for pre-10i  ---%>
                    <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="RSRC_GROUP_SWITCHING_INSTR@rsrcPlanBundle@servletRequest"
                      />
                  </uix:case>
                  <uix:case name="false">
                    <%--- Only for 10i or higher  ---%>
                <uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
                    <uix:stackLayout>
                      <uix:tableLayout
                        width="80%" 
                        >
                        <uix:rowLayout>
                          <uix:styledText
                            styleClass="OraInstructionText"
                            textBinding="RSRC_GROUP_SWITCHING_11G_INSTR@rsrcPlanBundle@servletRequest"
                            />
                        </uix:rowLayout>
                      </uix:tableLayout>
                      <uix:spacer height="5"/>
                    </uix:stackLayout>
                  </uix:case>
                  <uix:default>
                    <uix:stackLayout>
                      <uix:tableLayout
                        width="80%" 
                        >
                        <uix:rowLayout>
                          <uix:styledText
                            styleClass="OraInstructionText"
                            textBinding="RSRC_GROUP_SWITCHING_10G_INSTR@rsrcPlanBundle@servletRequest"
                            />
                        </uix:rowLayout>
                      </uix:tableLayout>
                      <uix:spacer height="5"/>
                    </uix:stackLayout>
                  </uix:default>
                </uix:switcher>
                  </uix:case>
                </uix:switcher>
              <uix:spacer height="5"/>
            </uix:stackLayout>

            <%---------------------------
             -   Group Switching Table    -
             ---------------------------%>

            <oem:table 
              summaryBinding="GROUP_SWITCHING@rsrcPlanBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSize="25"
              formSubmitted="true"
              name="groupSwitchingTable"
              beanKey="rsrcplnGroupSwitchingBean"
              dataSourceProp="groupSwitchingTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>

          </uix:subTabLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

