<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="planForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcpln/rsrcplnParallelism"/>

        <uix:pageLayout
          titleBinding="header@rsrcplnBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:contents>

                  <uix:link textBinding="GENERAL@rsrcPlanBundle@servletRequest"
                     onClick="submitForm('planForm', true, {event:'generalTab'})"/>

                  <uix:link textBinding="PARALLELISM@rsrcPlanBundle@servletRequest"/>

                  <%--- Only for 9.0.1 or higher  ---%>
                  <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                    <uix:case name="false">
                      <uix:link textBinding="SESSION_POOL@rsrcPlanBundle@servletRequest"
                         onClick="submitForm('planForm', true, {event:'sessionPoolTab'})"/>
                    </uix:case>
                  </uix:switcher>

                  <%--- Only for 9.0.1 or higher  ---%>
                  <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                    <uix:case name="false">
                      <uix:link textBinding="UNDO_POOL@rsrcPlanBundle@servletRequest"
                         onClick="submitForm('planForm', true, {event:'undoPoolTab'})"/>
                    </uix:case>
                  </uix:switcher>

                  <%--- Only for 9.0.1 or higher  ---%>
                <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                  <uix:case name="false">
			<uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
				<uix:case name="false">
					<uix:link textBinding="EXECUTION_TIME@rsrcPlanBundle@servletRequest"
						onClick="submitForm('planForm', true, {event:'executionTimeTab'})"/>
				</uix:case>
				<uix:default>
                    			<uix:link textBinding="THRESHOLD@rsrcPlanBundle@servletRequest"
			                       onClick="submitForm('planForm', true, {event:'groupSwitchingTab'})"/>
				</uix:default>
			</uix:switcher>
                  </uix:case>
                </uix:switcher>

                <uix:switcher childNameBinding="dbVersionPre901@rsrcplnBean@servletRequest">
                  <uix:case name="false">
			<uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
				<uix:case name="false">
                    			<uix:link textBinding="GROUP_SWITCHING@rsrcPlanBundle@servletRequest"
			                       onClick="submitForm('planForm', true, {event:'groupSwitchingTab'})"/>
				</uix:case>
				<uix:default>
                      			<uix:link textBinding="IDLE_TIME@rsrcPlanBundle@servletRequest"
                         			onClick="submitForm('planForm', true, {event:'idleTimeTab'})"/>
				</uix:default>
			</uix:switcher>
                  </uix:case>
                </uix:switcher>

                  <%--- Only for 10i or higher  ---%>
                  <uix:switcher childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                    <uix:case name="false">
			<uix:switcher childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
				<uix:case name="false">
                      <uix:link textBinding="IDLE_TIME@rsrcPlanBundle@servletRequest"
                         onClick="submitForm('planForm', true, {event:'idleTimeTab'})"/>
                    </uix:case>
                  </uix:switcher>
                    </uix:case>
                  </uix:switcher>

                </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>

            <%---------------------------
             -   Instruction Text
             ---------------------------%>
            <uix:stackLayout>
              <uix:spacer height="5"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="RSRC_PARALLELISM_INSTR@rsrcPlanBundle@servletRequest"
                />
              <uix:spacer height="5"/>
            </uix:stackLayout>

            <%---------------------------
             -   Parallelism Table    -
             ---------------------------%>

            <oem:table 
              summaryBinding="PARALLELISM@rsrcPlanBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSize="25"
              formSubmitted="true"
              name="parallelismTable" 
              beanKey="rsrcplnParallelismBean"
              dataSourceProp="parallelismTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>

          </uix:subTabLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
