<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head
        titleBinding="SELECT_GROUPS_SUBPLANS_HDR@rsrcPlanBundle@servletRequest"
        />
    </uix:metaContainer>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="planForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest"
        >

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcpln/rsrcplnSelectGroupSubplan"
          />

        <uix:pageLayout
          titleBinding="SELECT_GROUPS_SUBPLANS_HDR@rsrcPlanBundle@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

          <%-------------------------
           -  Group/Subplan Selection
           ---------------------------%>
          <oem:shuttle 
            name="Directives" 
            size="15"
            reorderable="false"
            leadingHeaderBinding="AVAILABLE_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
            trailingHeaderBinding="SELECTED_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
            >

            <uix:leading>
              <oem:list
                name="availDirectiveNames"
                multiple="true"
                shortDescBinding="AVAILABLE_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
                optionsBinding="availDirectiveNames@rsrcplnCpuAllocBean@servletRequest"/>
            </uix:leading>

            <uix:trailing>
              <oem:list
                name="selDirectiveNames"
                multiple="true"
                shortDescBinding="SELECTED_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
                optionsBinding="selDirectiveNames@rsrcplnCpuAllocBean@servletRequest"/>
            </uix:trailing>

          </oem:shuttle>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton
                name="event" 
                textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                value="cancelModify"/>

              <uix:submitButton
                name="event" 
                textBinding="OK@uixDBObjectBundle@servletRequest"
                value="modify"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

