<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="planForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcplnBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcpln/rsrcplnView"/>

        <uix:pageLayout
          titleBinding="header@rsrcplnBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:messages>

          <uix:labeledFieldLayout width="70%">

            <%---------------------------------
             -   Plan Name
             ----------------------------------%>
            <uix:styledText
              styleClass="OraPrompText"
              textBinding="PLAN_PROMPT@rsrcPlanBundle@servletRequest"/>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="planName@rsrcplnPlanBean@servletRequest"/>

            <%---------------------------------
             -   Plan Description
             ----------------------------------%>
            <uix:styledText
              styleClass="OraPrompText"
              textBinding="DESCRIPTION_PROMPT@rsrcPlanBundle@servletRequest"/>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="description@rsrcplnPlanBean@servletRequest"/>

            <%---------------------------------
             -   Plan Activation Status
             ----------------------------------%>
            <uix:switcher childNameBinding="isRac@servletRequest"> 
              <%-- Non RAC --%>
              <uix:default>
                <uix:styledText
                  styleClass="OraPrompText"
                  textBinding="ACTIVE_STATUS_PROMPT@rsrcPlanBundle@servletRequest"/>
              </uix:default>
              <%-- RAC Case --%>
              <uix:case name="true">
                <uix:styledText
                  styleClass="OraPrompText"
                  textBinding="INSTANCES@racRsrcPlanBundle@servletRequest"/>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="isRac@servletRequest"> 
              <%-- Non RAC --%>
              <uix:default>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="activateStatusText@rsrcplnPlanBean@servletRequest"/>
              </uix:default>
              <%-- RAC Case --%>
              <uix:case name="true">
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="activeInstances@rsrcplnPlanBean@servletRequest"/>
              </uix:case>
            </uix:switcher>

                <uix:switcher 
                  childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
            <uix:styledText
              styleClass="OraPrompText"
              textBinding="AUTO_PLAN_SWITCH_ENABLED@rsrcPlanBundle@servletRequest"/>
		  </uix:case>
		  </uix:switcher>

                <uix:switcher 
                  childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
            <uix:styledText
              styleClass="OraDataText"
              textBinding="autoSwitchPlans@rsrcplnPlanBean@servletRequest"/>
		  </uix:case>
		  </uix:switcher>
                <uix:switcher 
                  childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
            <uix:styledText
              styleClass="OraPrompText"
              textBinding="SUBPLAN@rsrcPlanBundle@servletRequest"/>
		  </uix:case>
		  </uix:switcher>

                <uix:switcher 
                  childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
            <uix:styledText
              styleClass="OraDataText"
              textBinding="subPlan@rsrcplnPlanBean@servletRequest"/>
		  </uix:case>
		  </uix:switcher>

          </uix:labeledFieldLayout>


          <uix:labeledFieldLayout width="70%">

                <uix:switcher 
                  childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                  <uix:case name="false">
            <uix:styledText
              styleClass="OraPrompText"
              textBinding="ASSOCIATED_WINDOW@rsrcPlanBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>

                <uix:switcher 
                  childNameBinding="dbVersionPre10@rsrcplnBean@servletRequest">
                  <uix:case name="false">
		  <uix:flowLayout>
		  <uix:contents childDataBinding="windowLink@servletRequest">
		  <uix:stackLayout>
		  <uix:spacer height="10" />
		  <uix:link  textBinding="winName" destinationBinding="winDest"/>
		  </uix:stackLayout>
		  </uix:contents>
		  </uix:flowLayout>
		  
                  </uix:case>
                </uix:switcher>


          </uix:labeledFieldLayout>

          <%---------------------------------
           -  Directive CPU level Table
           ----------------------------------%>
          <uix:header 
            textBinding="SELECTED_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
            >
            <oem:table 
              summaryBinding="SELECTED_GROUPS_SUBPLANS@rsrcPlanBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%"
              blockSize="10"
              formSubmitted="true"
              name="cpuAllocViewTable"
              beanKey="rsrcplnCpuAllocBean"
              dataSourceProp="cpuAllocViewTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>
          </uix:header>

          <%---------------------------
           -  View Directive Table
           ---------------------------%>
          <uix:header 
            textBinding="DIRECTIVE_VALUES_TABLE@rsrcPlanBundle@servletRequest"
            >
            <oem:table 
              summaryBinding="DIRECTIVE_VALUES_TABLE@rsrcPlanBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSize="10"
              formSubmitted="true"
              name="viewDirectiveTable" 
              beanKey="rsrcplnViewDirectiveBean"
              dataSourceProp="viewDirectiveTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>
          </uix:header>

          <%---------------------------
           -  Group Switching Table
           ---------------------------%>
                <uix:switcher 
                  childNameBinding="dbVersion11@rsrcplnBean@servletRequest">
                  <uix:case name="true">
          <uix:header 
            textBinding="THRESHOLD@rsrcPlanBundle@servletRequest"
            >
            <oem:table 
              summaryBinding="GROUP_SWITCHING_TABLE@rsrcPlanBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSize="10"
              formSubmitted="true"
              name="groupSwitchingViewTable"
              beanKey="rsrcplnGroupSwitchingBean"
              dataSourceProp="groupSwitchingViewTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>
          </uix:header>
                  </uix:case>
                  <uix:default>
          <uix:header 
            textBinding="GROUP_SWITCHING_TABLE@rsrcPlanBundle@servletRequest"
            >
            <oem:table 
              summaryBinding="GROUP_SWITCHING_TABLE@rsrcPlanBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSize="10"
              formSubmitted="true"
              name="groupSwitchingViewTable"
              beanKey="rsrcplnGroupSwitchingBean"
              dataSourceProp="groupSwitchingViewTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>
          </uix:header>
                  </uix:default>
		  </uix:switcher>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
              <uix:ref refID="storagePageButtonViewInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

