<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                
<%-- HTML Form --%>
<db:form name="attributesForm"  destination="attributes" copyParams="target,type">
 
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

         <uix:spacer height="10"/>
        <uix:tableLayout width="100%" >
               
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="aTab"
                           tableDataBinding="attributesList@defaultBean@servletRequest"
                           summaryBinding="header@objectBean@servletRequest"
                           columnFormatsBinding="attributesColFormats@defaultBean@pageContext"
                           columnHeaderDataBinding="attributesColHeader@defaultBean@servletRequest"                           
                           alternateTextBinding = "NO_ITEM_FOUND@bundle@servletRequest"
                           blockSizeBinding="attributesBlockSize@defaultBean@servletRequest"
                           minValueBinding="attributesMinValue@defaultBean@servletRequest" 
                           maxValueBinding="attributesMaxValue@defaultBean@servletRequest" >
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/> 
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                               
                     <uix:styledText textBinding="attr"/> 
                     <uix:textInput name="attr"  textBinding="val"  />
                     <uix:styledText textBinding="des"/>
                   </uix:contents>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>        
 <uix:spacer height="15"/>                                 
  <uix:tip textBinding="TIME_ZONE_TIP@bundle@servletRequest"/> 
 <uix:spacer height="15"/>    
 
  <oem:relatedLinks />
  
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



