<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="ChainTopoMsg"
	    class="oracle.sysman.db.rsc.inst.ChainTopoMsg"/>
  <uix:bundle name="JobsMsg"
	    class="oracle.sysman.db.rsc.inst.JobsMsg"/>        
 
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

       <uix:header textBinding="ICON_LEGEND_HEADER@ChainTopoMsg" messageType="info">
       

           <uix:tableLayout  cellSpacing="5">
             <uix:rowLayout vAlign="top">
               <uix:cellFormat hAlign="left">

                 <uix:header textBinding="STATUS@JobsMsg">
                  <uix:tableLayout cellSpacing="8">

                   <uix:rowLayout hAlign="left">
                     <uix:rawText textBinding="failedSVG@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="FAILED@JobsMsg"/>
                   </uix:rowLayout>
		    
                   <uix:rowLayout hAlign="left">
                     <uix:rawText textBinding="pausedSVG@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="PAUSED@JobsMsg"/>
                   </uix:rowLayout>
                   
                    <uix:rowLayout hAlign="left">
                     <uix:rawText textBinding="runningSVG@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="RUNNING@JobsMsg"/>
                   </uix:rowLayout>
		    
                   <uix:rowLayout hAlign="left">
                     <uix:rawText textBinding="scheduledSVG@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="SCHEDULED@JobsMsg"/>
                   </uix:rowLayout>
                   
                     <uix:rowLayout hAlign="left">
                     <uix:rawText textBinding="stoppedSVG@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="STOPPED@JobsMsg"/>
                   </uix:rowLayout>
                   
                   <uix:rowLayout hAlign="left">
                     <uix:rawText textBinding="succeededSVG@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="SUCCEEDED@JobsMsg"/>
                   </uix:rowLayout>
		    
                  </uix:tableLayout>
                 </uix:header>
                 
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
           
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

