<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.instance.scheduler.ChainConstants" %>
<%@ page import="oracle.sysman.emo.adm.instance.scheduler.ChainRuleDataSource" %>
<%@ page import="org.apache.log4j.Category" %>
<%@ page import="java.util.Enumeration" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="chainsBundle"
              class="oracle.sysman.db.rsc.inst.ChainsMsg"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      { 
          
      }
      </script>
    </uix:metaContainer>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>
<%-- HTML Form --%>
<db:form name="ruleForm" destination="chain" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="omode" valueBinding="omode@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 <uix:formValue name="rulesTable:selected" valueBinding="selectedIndexUI@rulesBean@servletRequest"/>
 
 <uix:pageLayout titleBinding="ruleHeader@rulesBean@servletRequest">
 
 <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %> 
  
 <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
   
                <uix:styledText styleClass="OraInstructionText"                               
                            textBinding="RULE_INFO_TEXT@chainsBundle"/>
    <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
                  
  
  <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
            
              <uix:tableLayout cellSpacing="5">
              
                <uix:contents>
                
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="RULE_NAME@bundle@servletRequest"/> 
                     </uix:cellFormat>
                     <uix:switcher childNameBinding="ruleMode@rulesBean@servletRequest">
                      <uix:case name="<%=ChainConstants.ADD_RULE%>">
                     <%--Caution: Dont take the textInput name as "name" as it will collide with form name property--%>
            				   <uix:tableLayout borderWidth="0"
					   cellSpacing="0">
                        			<uix:contents>
							
						   <uix:rowLayout>
                   					<uix:contents>
							 <uix:cellFormat columnSpan="3">
						      	    <uix:radioButton name="systemGeneratedFlag"
				                          textBinding="RULE_SYSTEM_DEF@bundle@servletRequest"
				                          value="TRUE"
					selectedValueBinding="systemGeneratedFlag@ruleBean@rulesBean@servletRequest"/>
							 </uix:cellFormat>
							</uix:contents>
						    </uix:rowLayout>
							
							<uix:rowLayout>
                   					<uix:contents>
							<uix:cellFormat>
				                      <uix:radioButton name="systemGeneratedFlag"
				                          textBinding="RULE_SPECIFY_NAME@bundle@servletRequest"
							  value="FALSE"
				                          selectedValueBinding="systemGeneratedFlag@ruleBean@rulesBean@servletRequest">
				                       </uix:radioButton>
						       </uix:cellFormat>
						       <uix:spacer width="5"/>
						       <uix:cellFormat>
						       <uix:stackLayout>
                       					 <uix:contents>
				                       <uix:textInput name="displayRuleName" textBinding="displayRuleName@ruleBean@rulesBean@servletRequest"/>
						       <uix:messageText messageBinding="ruleName@errors@servletRequest" messageType="error"/>
					     	     </uix:contents>
						     </uix:stackLayout>
						      </uix:cellFormat>
						      </uix:contents>
						      </uix:rowLayout>
						     
						     </uix:contents>
						     </uix:tableLayout>
                     </uix:case>
                     <uix:case name="<%=ChainConstants.EDIT_RULE%>">
                     <uix:styledText styleClass="OraDataText" textBinding="ruleName@ruleBean@rulesBean@servletRequest"/>
                     </uix:case>
                     </uix:switcher>
                   </uix:contents>
                </uix:rowLayout>
                
                 <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="RULE_DESCR@bundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				 <uix:textInput name="comment" textBinding="comment@ruleBean@rulesBean@servletRequest" columns="65"/>
                   </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="RULE_COND@bundle@servletRequest" required="yes"/> 
                     </uix:cellFormat>
                     <uix:stackLayout>
                        <uix:contents>
                          <uix:messageTextInput name="condition" textBinding="condition@ruleBean@rulesBean@servletRequest" columns="90" rows="6" tipBinding="RULE_COND_INFO@bundle@servletRequest"/>
                      
                         <uix:messageText messageBinding="condition@errors@servletRequest" messageType="error"/>
                        </uix:contents>
                      </uix:stackLayout>
                      
                   </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right"  wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="RULE_ACTION@bundle@servletRequest" required="yes"/> 
                     </uix:cellFormat>
                     <uix:stackLayout>
                        <uix:contents>
                          <%--Caution: Dont take the textInput name as "action" as it will collide with form action property--%>
                         <uix:messageTextInput name="ruleAction" textBinding="ruleAction@ruleBean@rulesBean@servletRequest" tipBinding="RULE_ACTION_INFO@bundle@servletRequest"/>
                     
                         <uix:messageText messageBinding="ruleAction@errors@servletRequest" messageType="error"/>
                        </uix:contents>
                      </uix:stackLayout>
                   </uix:contents>
                </uix:rowLayout>
                
                </uix:contents>
              </uix:tableLayout>
              
                                                         
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 
    
 </uix:tableLayout>
     
 <uix:spacer height="20"/>    
 <uix:tableLayout>
     <uix:rowLayout>
    
	<uix:cellFormat>
	  <uix:tip>
		<uix:contents>
		<uix:styledText styleClass="OraTipText"
		     textBinding="RULE_SPECIFICATION_TEXT@bundle@servletRequest"/>
		<uix:styledText styleClass="OraTipText"
			 textBinding="RULE_SPECIFICATION@bundle@servletRequest" 
	 destination="http://www.oracle.com/pls/db102/to_xlink?xlink=ARPLS138"/>
		</uix:contents>
	</uix:tip>
      </uix:cellFormat>
     </uix:rowLayout>
   </uix:tableLayout>     
     
     
<uix:pageButtons>
  <uix:pageButtonBar>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          name="event" 
                          value="<%=ChainConstants.RULE_CANCEL%>" />
   <uix:submitButton textBinding="CONTINUE@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="<%=ChainConstants.RULE_OK%>"/>
  </uix:pageButtonBar>
  </uix:pageButtons>
  

   </uix:pageLayout> 
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
