<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.adm.instance.scheduler.ChainConstants" %>
<%@ page import="oracle.sysman.emo.adm.instance.scheduler.ChainRuleDataSource" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>

<uix:buildTree nodeID="chainRules">
  <uix:dataScope>
  
    <uix:bundle name="bundle" class="oracle.sysman.db.rsc.inst.ChainsMsg"/>
    <uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.DBObjectMsg"/>          
    <uix:tableLayout width="80%">
    
      <uix:stackLayout>
        <uix:header textBinding="RULES@bundle@servletRequest">
        
        <uix:spacer height="1" renderedBinding="<%=ChainConstants.IS_ENABLED%>"/>
          <uix:rowLayout width="100%" renderedBinding="<%=ChainConstants.IS_ENABLED%>">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                    <uix:submitButton textBinding="ADD@bundle@servletRequest" 
                    name="event" 
                    value="<%=ChainConstants.ADD_RULE%>"/>
              </uix:cellFormat>
          </uix:rowLayout>              
        <uix:spacer height="1" renderedBinding="<%=ChainConstants.IS_ENABLED%>"/>
        
        
        <uix:stackLayout>
          <uix:table name="<%=ChainConstants.RULES_TABLE%>"
             width="100%"
             tableDataBinding="<%=UIXDataSource.S_ROW_DATA_ATTR%>"
             summaryBinding="RULES@bundle@servletRequest"
             formSubmitted="true"
             showAll="yes"
             alternateTextBinding = "NO_RULES_FOUND@bundle@servletRequest"
             blockSizeBinding="<%=UIXDataSource.S_BLOCK_SIZE_ATTR%>" 
             maxValueBinding="<%=UIXDataSource.S_NUM_ROWS_ATTR%>"
             valueBinding="<%=UIXDataSource.S_START_INDEX_ATTR%>" >
             
          <uix:tableFormat tableBanding="rowBanding"/>
          
                     
          <uix:tableSelection>
             <uix:singleSelection selectedIndexBinding="<%=ChainConstants.SELECTEDINDEX_UI%>" renderedBinding="<%=ChainConstants.IS_ENABLED%>" shortDescBinding="SELECT_A_VALUE@DBMsgBundle">
                  <uix:submitButton 
                    textBinding="EDIT@bundle@servletRequest" 
                    name="event" 
                    value="<%=ChainConstants.EDIT_RULE%>"
                    renderedBinding="<%=ChainConstants.IS_ENABLED%>"/>
                    <uix:submitButton 
                    textBinding="DELETE@bundle@servletRequest" 
                    name="event" 
                    value="<%=ChainConstants.DELETE_RULE%>"
                    renderedBinding="<%=ChainConstants.IS_ENABLED%>"/>
                  </uix:singleSelection>
           </uix:tableSelection>
             
           <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="RULE_NAME@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_RULE_NAME_SORT%>"/>
              <%--<uix:styledText textBinding="RULE_NAME@bundle@servletRequest"/>--%>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="<%=ChainConstants.RULE_NAME_COL%>"/>
            </uix:column>
            
             <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="RULE_COND@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_RULE_COND_SORT%>"/>
              <%--<uix:styledText textBinding="RULE_COND@bundle@servletRequest"/>--%>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="<%=ChainConstants.RULE_COND_COL%>"/>
            </uix:column>
            
             <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="RULE_ACTION@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_RULE_ACTION_SORT%>"/>
              <%--<uix:styledText textBinding="RULE_ACTION@bundle@servletRequest"/>--%>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="<%=ChainConstants.RULE_ACTION_COL%>"/>
            </uix:column>
            
             <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="RULE_DESCR@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_RULE_DESC_SORT%>"/>
              <%--<uix:styledText textBinding="RULE_DESCR@bundle@servletRequest"/>--%>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="<%=ChainConstants.RULE_DESC_COL%>"/>
            </uix:column>
           
          </uix:table>
        </uix:stackLayout>
        </uix:header>
      </uix:stackLayout>
    </uix:tableLayout>
  </uix:dataScope> 
</uix:buildTree> 
