<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<%@ page import="oracle.sysman.emo.adm.instance.scheduler.ChainConstants" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.adm.LovCollection" %>

<script>
  function lovCallBack(data){
    f2 = callBackLovField();
    index=f2.lastIndexOf(":");
    f1="stepsTable:stepObjectSchema:"+f2.substring(index+1,f2.length);  

    if ((i=data.indexOf('".')) > 0)
    {
      document.forms[0][f1].value=data.substring(0,i+1);
      document.forms[0][f2].value = data.substring(i+2, data.length);   
    }
    else if ((i=data.indexOf('.')) >= 0) 
    {
      document.forms[0][f1].value = data.substring(0,i);
      document.forms[0][f2].value = data.substring(i+1, data.length);
    }
  }
	function getLovId(index){
		var lovId = '';
		if(index==0)
			lovId = '<%=LovCollection.LIST_PROGRAM%>';
		else if(index==1)
			lovId = '<%=LovCollection.LIST_CHAIN%>';
		else if(index==2)
			lovId = '<%=LovCollection.LIST_EVENTSCHEDULE%>';
		return lovId;
	}

</script> 

<uix:buildTree nodeID="chainSteps">
  <uix:dataScope>
  
    <uix:bundle name="bundle" class="oracle.sysman.db.rsc.inst.ChainsMsg"/>
    <uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.DBObjectMsg"/>
      
    <uix:tableLayout width="80%">
    
      <uix:stackLayout>
        <uix:header textBinding="STEPS@bundle@servletRequest">  
       
        <uix:stackLayout>
          <uix:table name="<%=ChainConstants.STEPS_TABLE%>"
             width="100%"
             tableDataBinding="<%=UIXDataSource.S_ROW_DATA_ATTR%>"
             summaryBinding="STEPS@bundle@servletRequest"
             formSubmitted="true"
             showAll="yes"
             alternateTextBinding = "NO_STEPS_FOUND@bundle@servletRequest"
             blockSizeBinding="<%=UIXDataSource.S_BLOCK_SIZE_ATTR%>" 
             maxValueBinding="<%=UIXDataSource.S_NUM_ROWS_ATTR%>"
             valueBinding="<%=UIXDataSource.S_START_INDEX_ATTR%>" >
             
          <uix:tableFormat tableBanding="rowBanding"/>
          
            <uix:tableSelection>
             <uix:singleSelection selectedIndexBinding="<%=ChainConstants.SELECTEDINDEX_UI%>" renderedBinding="<%=ChainConstants.IS_ENABLED%>" shortDescBinding="SELECT_A_VALUE@DBMsgBundle">
                  <uix:submitButton 
                    textBinding="DELETE@bundle@servletRequest" 
                    name="event" 
                    value="<%=ChainConstants.DELETE_STEP%>"
                    renderedBinding="<%=ChainConstants.IS_ENABLED%>"/> 
              </uix:singleSelection>
           </uix:tableSelection>
             
           <uix:column>
              <uix:columnHeader>
              	<uix:sortableHeader textBinding="STEP_NAME@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_STEP_NAME_SORT%>"/>
                <%--<uix:styledText textBinding="STEP_NAME@bundle@servletRequest" />--%>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:switcher childNameBinding="<%=ChainConstants.IS_NEW%>">
                <uix:case name="true">
                  <uix:textInput name="<%=ChainConstants.STEP_NAME_COL%>"
                                 textBinding="<%=ChainConstants.STEP_NAME_COL%>">
                  </uix:textInput>
                </uix:case>
              <uix:case name="false">
                <uix:styledText textBinding="<%=ChainConstants.STEP_NAME_COL%>"/>
              </uix:case>
              </uix:switcher>
            </uix:column>
            
            <uix:column>
              <uix:columnHeader>
                <%--<uix:styledText textBinding="STEP_TYPE@bundle@servletRequest"/>--%>
                <uix:sortableHeader textBinding="STEP_TYPE@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_STEP_TYPE_SORT%>"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:switcher childNameBinding="<%=ChainConstants.IS_ENABLED%>">
              <uix:case name="true">
                <uix:choice name="<%=ChainConstants.STEP_TYPE_COL%>"
                                 selectedValueBinding="<%=ChainConstants.STEP_TYPE_COL%>">
                    <uix:contents childDataBinding="<%=ChainConstants.STEP_TYPE_LIST%>">
                    	<uix:option textBinding="textKey" valueBinding="valueKey"/>
                    </uix:contents>
                 </uix:choice> 
              </uix:case>
              <uix:case name="false">
                <uix:styledText textBinding="<%=ChainConstants.STEP_TYPE_COL%>"/>
              </uix:case>
              </uix:switcher>
            </uix:column>
            
            <uix:column>
              <uix:columnHeader>
                <%--<uix:styledText textBinding="STEP_OBJECT@bundle@servletRequest"/>--%>
                <uix:sortableHeader textBinding="STEP_OBJECT@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_STEP_OBJECT_SORT%>"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:switcher childNameBinding="<%=ChainConstants.IS_ENABLED%>">
              <uix:case name="true">
                <uix:rowLayout>
               <uix:textInput name="<%=ChainConstants.STEP_OBJECT_SCHEMA_COL%>"
                                 textBinding="<%=ChainConstants.STEP_OBJECT_SCHEMA_COL%>"  columns="15" />
                <uix:styledText text="."/>                                 
                <uix:messageLovField 
                              name="<%=ChainConstants.STEP_OBJECT_COL%>" 
                              textBinding="<%=ChainConstants.STEP_OBJECT_COL%>"
                              onClickBinding="<%=ChainConstants.STEP_LOV_URL%>"  columns="15" />
                              
                </uix:rowLayout>
              </uix:case>
              <uix:case name="false">
                <uix:link textBinding="<%=ChainConstants.STEP_OSCHEMA_COL%>" destinationBinding="<%=ChainConstants.STEP_OBJECT_URL%>"/>
              </uix:case>
              </uix:switcher>
            </uix:column>
            
             <uix:column renderedBinding="<%=ChainConstants.IS_NOT_CREATE_MODE%>">
              <uix:columnHeader>
                <%--uix:styledText textBinding="STEP_SKIP@bundle@servletRequest"/>--%>
                <uix:sortableHeader textBinding="STEP_SKIP@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_STEP_SKIP_SORT%>"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:switcher childNameBinding="<%=ChainConstants.IS_ENABLED%>">
              <uix:case name="true">
                     <uix:choice name="<%=ChainConstants.STEP_SKIP_COL%>"
                                 selectedValueBinding="<%=ChainConstants.STEP_SKIP_COL%>">
                            <uix:contents childDataBinding="<%=ChainConstants.BOOL_TYPE_LIST%>">
                            	<uix:option textBinding="textKey" valueBinding="valueKey"/>
                            </uix:contents>
                      </uix:choice> 
              </uix:case>
              <uix:case name="false">
                <uix:styledText textBinding="<%=ChainConstants.STEP_SKIP_COL%>"/>
              </uix:case>
              </uix:switcher>
            </uix:column>
            
             <uix:column renderedBinding="<%=ChainConstants.IS_NOT_CREATE_MODE%>">
              <uix:columnHeader>
                <%--<uix:styledText textBinding="STEP_PAUSE@bundle@servletRequest"/>--%>
                <uix:sortableHeader textBinding="STEP_PAUSE@bundle@servletRequest" sortableBinding="<%=ChainConstants.UI_STEP_PAUSE_SORT%>"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:switcher childNameBinding="<%=ChainConstants.IS_ENABLED%>">
              <uix:case name="true">
                    <uix:choice name="<%=ChainConstants.STEP_PAUSE_COL%>"
                                 selectedValueBinding="<%=ChainConstants.STEP_PAUSE_COL%>">
                            <uix:contents childDataBinding="<%=ChainConstants.BOOL_TYPE_LIST%>">
                            	<uix:option textBinding="textKey" valueBinding="valueKey"/>
                            </uix:contents>
                      </uix:choice> 
              </uix:case>
              <uix:case name="false">
                <uix:styledText textBinding="<%=ChainConstants.STEP_PAUSE_COL%>"/>
              </uix:case>
              </uix:switcher>
            </uix:column>
            
              
            
            <uix:columnFooter>
              <uix:submitButton textBinding="ADD_STEPS@bundle" 
                                shortDescBinding="ADD_STEPS@bundle" 
                                name="event" 
                                value="<%= ChainConstants.ADD_STEPS %>"
                                renderedBinding="<%=ChainConstants.IS_ENABLED%>"/>
            </uix:columnFooter>
            
           
          </uix:table>
        </uix:stackLayout>
        </uix:header>
      </uix:stackLayout>
    </uix:tableLayout>
  </uix:dataScope> 
</uix:buildTree> 
