<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      { 
          
      }
     </script>
    </uix:metaContainer>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<jsp:useBean
    id="objectBean"
    scope="request"
    type="oracle.sysman.emo.adm.instance.scheduler.Chain"/>
    
<uix:body>
<%-- HTML Form --%>
<db:form name="generalForm" method="post" destination="chain" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="omode" valueBinding="omode@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 
 <uix:pageLayout titleBinding="header@objectBean@servletRequest">
 
 <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %> 
  
 <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
   
   <%-- START: General Info --%>
    <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
                  
  <%-- START: TAB CONTENTS starts here --%>
  
  <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
            
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="NAME@bundle@servletRequest" required="yes"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                       
                    <uix:stackLayout>
                    <uix:contents>
                     
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:textInput name="chainName" textBinding="chainName@objectBean@servletRequest" />
                        </uix:case>   
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="chainName@objectBean@servletRequest"/>
                        </uix:case>         
                      </uix:switcher>                  
                      <uix:messageText messageBinding="chainName@errors@servletRequest" messageType="error"/>
                    </uix:contents>
                  </uix:stackLayout>
                  
                 	
					 <uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                        <uix:cellFormat hAlign="right" width="60%">
		                     	 <uix:messagePrompt promptBinding="RULESET_NAME@bundle@servletRequest"/> 
		                     </uix:cellFormat>                     
		     	      	</uix:case>
              		</uix:switcher>
              		<uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:styledText styleClass="OraDataText" textBinding="rulesetName@objectBean@servletRequest"/>   
				      	</uix:case>
              		</uix:switcher>
                  
                                 				 
                  </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest" required="yes"/>          
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/> 
                        </uix:case>
                      </uix:switcher>
                     </uix:cellFormat> 
                     
                     <%-- SWITCHER: schema --%>
                       <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                         <uix:case name="true"> 
                          <uix:stackLayout>               
                              <uix:messageLovField 
                              name="schemaName" textBinding="schemaName@objectBean@servletRequest"
                              shortDescBinding="SEL_OWNER_DESC@bundle@servletRequest" 
                              onClick="startLov('schemaName', 'ListSchema')" />
                              
                              
                            <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/> 
                        </uix:stackLayout>
                         </uix:case>   
                         <uix:case name="false">
                           <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>   
                         </uix:case>         
                       </uix:switcher>
                    <%-- SWITCHER: schema --%>  
                    
                     <uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:cellFormat hAlign="right">
		                     	 <uix:messagePrompt promptBinding="RULESET_OWNER@bundle@servletRequest"/> 
		                     </uix:cellFormat>                     
		     	      	</uix:case>
              		</uix:switcher>
              		<uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:styledText styleClass="OraDataText" textBinding="rulesetOwner@objectBean@servletRequest"/>   
				      	</uix:case>
              		</uix:switcher>
                    
                                         
                  </uix:contents>
                </uix:rowLayout>
                
               <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="ENABLED@bundle@servletRequest"/> 
                     </uix:cellFormat>      
                     <uix:cellFormat>         
                      <uix:radioButton name="enabled"
                          textBinding="YES@bundle@servletRequest"
                          value="TRUE"
                          selectedValueBinding="enabled@objectBean@servletRequest" />      
                      <uix:radioButton name="enabled"
                          textBinding="NO@bundle@servletRequest"
                          value="FALSE"
                          selectedValueBinding="enabled@objectBean@servletRequest" /> 
                     </uix:cellFormat>                          
                   </uix:contents>
                </uix:rowLayout>
                </uix:contents> 
              </uix:tableLayout>  
                
              <uix:tableLayout cellSpacing="5">
               <uix:contents>
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="COMMENT@bundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				 <uix:textInput name="comments" textBinding="comments@objectBean@servletRequest" columns="100"/>
                   </uix:contents>
                </uix:rowLayout>
                
                </uix:contents>
              </uix:tableLayout>
              
                                                         
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 
    
 </uix:tableLayout>
    <%-- END: General Info --%>         

      <uix:dataScope currentDataBinding="stepsBean@servletRequest">
      <%--<%@ include file="chainSteps.jspf" %>--%>
      <jsp:include page="/database/instance/scheduler/chainSteps.jsp" />
      <uix:ref refID="chainSteps" />
    </uix:dataScope>
    
    <uix:dataScope currentDataBinding="rulesBean@servletRequest">
      <jsp:include page="/database/instance/scheduler/chainRules.jsp" />
      <uix:ref refID="chainRules" />
    </uix:dataScope>

                  
      <uix:tableLayout cellSpacing="15">
        <uix:contents>
          <uix:rowLayout>
            <uix:tableLayout cellSpacing="5">
             <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat>
                        <uix:messagePrompt promptBinding="EVAL_INTERVAL@bundle@servletRequest"/> 
                       </uix:cellFormat>                     
                       <uix:textInput name="evalInterval" textBinding="evalInterval@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>
          </uix:rowLayout>
          
           <uix:rowLayout>
          <uix:tableLayout cellSpacing="5">
             <uix:contents>
             	<uix:rowLayout>
					<uix:cellFormat>
					  <uix:tip>
					    <uix:styledText styleClass="OraTipText"
					                    textBinding="EVALINTERVAL_NOTE@bundle@servletRequest" />
					  </uix:tip>
					</uix:cellFormat>
				</uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>
          
         </uix:rowLayout>
      
        </uix:contents>
      </uix:tableLayout>       
                                                         
      

   <uix:hideShowHeader textBinding="TOPOLOGY@bundle@servletRequest"
                    renderedBinding="isShowChain@objectBean@servletRequest"
                    disclosedBinding="showTopo@objectBean@servletRequest"                     
                    formSubmitted="true" id="topo" >     
        
        <%
        if (objectBean.isCreating())
        {
        %>
          <jsp:include page="/database/instance/scheduler/chainTopoCreate.jsp" />
          <uix:ref refID="chainTopoCreate" />        
        <%
        }
        else {
        %>        
          <jsp:include page="/database/instance/scheduler/chainTopo.jsp" />
          <uix:ref refID="chainTopo" />         
        <%
        }
        %>
    </uix:hideShowHeader>  
    
    <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

  </uix:pageLayout> 
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
