<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      { 
          
      }
     </script>
    </uix:metaContainer>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>
<%-- HTML Form --%>
<db:form name="viewForm" destination="chain" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="omode" valueBinding="omode@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 
 <uix:pageLayout titleBinding="viewHeader@objectBean@@servletRequest">
 
 <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %> 
  
 <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
   
   <%-- START: General Info --%>
    <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
                  
  <%-- START: TAB CONTENTS starts here --%>
  
  <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
            
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                  <uix:rowLayout>
                     <uix:cellFormat hAlign="right" >
                       <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
                     </uix:cellFormat>
                     <uix:styledText styleClass="OraDataText" 
                                     textBinding="chainName@objectBean@servletRequest" />
                                     
                      <uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:cellFormat hAlign="right" width="40%">
		                     	 <uix:messagePrompt promptBinding="RULESET_NAME@bundle@servletRequest"/> 
		                     </uix:cellFormat>                     
		     	      	</uix:case>
              		</uix:switcher>
              		<uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:styledText styleClass="OraDataText" textBinding="rulesetName@objectBean@servletRequest"/>   
				      	</uix:case>
              		</uix:switcher>
                     
                     
                   </uix:rowLayout>
            
                   <uix:rowLayout>
                     <uix:cellFormat hAlign="right" >
                       <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/>
                     </uix:cellFormat>
                     <uix:link textBinding="schemaName@objectBean@servletRequest" destinationBinding="ownerLink@objectBean@servletRequest"/>
                                     
                                     
                      <uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:cellFormat hAlign="right">
		                     	 <uix:messagePrompt promptBinding="RULESET_OWNER@bundle@servletRequest"/> 
		                     </uix:cellFormat>                     
		     	      	</uix:case>
              		</uix:switcher>
              		<uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:link textBinding="rulesetOwner@objectBean@servletRequest" destinationBinding="ruleSetOwnerLink@objectBean@servletRequest"/>  
				      	</uix:case>
              		</uix:switcher>
                    
                                     
                   </uix:rowLayout>
            
                   <uix:rowLayout>
                     <uix:cellFormat hAlign="right" >
                       <uix:messagePrompt promptBinding="ENABLED@bundle@servletRequest"/>
                     </uix:cellFormat>
                     <uix:styledText styleClass="OraDataText" 
                                     textBinding="enabled@objectBean@servletRequest" />
                                     
                       <uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:cellFormat hAlign="right">
		                     	 <uix:messagePrompt promptBinding="USER_RULESET@bundle@servletRequest"/> 
		                     </uix:cellFormat>                     
		     	      	</uix:case>
              		</uix:switcher>
              		<uix:switcher  childNameBinding="editing@objectBean@servletRequest">
	                    <uix:case name="true">
	                         <uix:styledText styleClass="OraDataText" textBinding="userRuleset@objectBean@servletRequest"/>   
				      	</uix:case>
              		</uix:switcher>
                    
                     
                   </uix:rowLayout>
            
                   <uix:rowLayout>
                     <uix:cellFormat hAlign="right" >
                       <uix:messagePrompt promptBinding="COMMENT@bundle@servletRequest"/>
                     </uix:cellFormat>
                     <uix:styledText styleClass="OraDataText" 
                                     textBinding="comments@objectBean@servletRequest" />
                   </uix:rowLayout>
                            
                </uix:contents>
              </uix:tableLayout>
              
                                                         
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 
    
 </uix:tableLayout>
    <%-- END: General Info --%>
    <uix:dataScope currentDataBinding="stepsBean@servletRequest">
      <jsp:include page="/database/instance/scheduler/chainSteps.jsp" />
      <uix:ref refID="chainSteps" />
    </uix:dataScope>
    
     <uix:dataScope currentDataBinding="rulesBean@servletRequest">
      <jsp:include page="/database/instance/scheduler/chainRules.jsp" />
      <uix:ref refID="chainRules" />
    </uix:dataScope>
    
    
      <uix:tableLayout cellSpacing="15">
        <uix:contents>
          <uix:rowLayout>
            <uix:tableLayout cellSpacing="5">
             <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat>
                        <uix:messagePrompt promptBinding="EVAL_INTERVAL@bundle@servletRequest"/> 
                       </uix:cellFormat>                     
                         <uix:styledText styleClass="OraDataText" 
                                     textBinding="evalInterval@objectBean@servletRequest" />
                  </uix:contents>
                </uix:rowLayout>
      
            </uix:contents>
          </uix:tableLayout>
           </uix:rowLayout>
          
           <uix:rowLayout>
          <uix:tableLayout cellSpacing="5">
             <uix:contents>
             	<uix:rowLayout>
					<uix:cellFormat>
					  <uix:tip>
					    <uix:styledText styleClass="OraTipText"
					                    textBinding="EVALINTERVAL_NOTE@bundle@servletRequest" />
					  </uix:tip>
					</uix:cellFormat>
				</uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>
          
         </uix:rowLayout>
      
        </uix:contents>
      </uix:tableLayout>       
                  
    <uix:hideShowHeader textBinding="TOPOLOGY@bundle@servletRequest"
                    renderedBinding="isShowChain@objectBean@servletRequest"
                    disclosedBinding="showTopo@objectBean@servletRequest"                     
                    formSubmitted="true" id="topo" >                    
      <jsp:include page="/database/instance/scheduler/chainTopo.jsp" />
      <uix:ref refID="chainTopo" />    
    </uix:hideShowHeader> 
    <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
    <uix:ref refID="pageButtonViewInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

  </uix:pageLayout> 
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>