<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      {          
      }
     </script>
    </uix:metaContainer>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                
<%-- HTML Form --%>
<db:form name="generalForm"  destination="class" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="state" valueBinding="state@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
<%-- 
  <uix:subTabLayout>
    
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
        <uix:link textBinding="GENERAL@bundle@servletRequest"
                   onClick="submitForm('generalForm', true, {event:'goto1'})"/>      
     </uix:subTabBar>
    </uix:subTabs>
  --%>
  
    <%-- START: TAB CONTENTS starts here --%>


        <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
               <uix:spacer height="10"/>  
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="NAME@bundle@servletRequest" required="yes" labeledNodeId="className"/> 
                     </uix:cellFormat>        
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:textInput id="className" name="className" textBinding="className@objectBean@servletRequest" />
                        </uix:case>   
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="className@objectBean@servletRequest"/>
                        </uix:case>         
                      </uix:switcher>                             				 
                   </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="DESCRIPTION@bundle@servletRequest" labeledNodeId="comments"/> 
                     </uix:cellFormat>                     
            				 <uix:textInput id="comments" name="comments" textBinding="comments@objectBean@servletRequest" />
                   </uix:contents>
                </uix:rowLayout>
                
              <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOGGING_LEVEL@bundle@servletRequest" labeledNodeId="loggingLevel"/> 
                     </uix:cellFormat>    
                     <uix:stackLayout>
                     <uix:choice id="loggingLevel" name="loggingLevel"
                                 selectedValueBinding="loggingLevel@objectBean@servletRequest"                                
                                 shortDescBinding="LOGGING_LEVEL@bundle@servletRequest">
                                 <uix:contents childDataBinding="loggingList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                     </uix:choice>      
                    </uix:stackLayout>
                   </uix:contents>
                </uix:rowLayout>                

                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOG_HISTORY@bundle@servletRequest" labeledNodeId="logHistory"/> 
                     </uix:cellFormat>    
                     <uix:textInput id="logHistory" name="logHistory" textBinding="logHistory@objectBean@servletRequest" />       
                   </uix:contents>
                </uix:rowLayout>     
                
               <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="RSC_CON_GRP@bundle@servletRequest"/> 
                     </uix:cellFormat>         
                     <uix:messageLovField
                              name="rscGroup" textBinding="rscGroup@objectBean@servletRequest"
                              shortDescBinding="SEL_RCG_DESC@bundle@servletRequest"
                              onClickBinding="rscgrpURL@servletRequest" />                                                
                   </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="SERVICE@bundle@servletRequest" labeledNodeId="service"/> 
                     </uix:cellFormat>                     
                         <uix:messageLovField
                              name="service" textBinding="service@objectBean@servletRequest"
                              shortDescBinding="SEL_SERVICE_DESC@bundle@servletRequest"
                              onClickBinding="serviceURL@servletRequest" /> 
                   </uix:contents>
                </uix:rowLayout>

                </uix:contents>
              </uix:tableLayout>
              
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   

<%--                
  </uix:subTabLayout> 
  --%>
  
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




