<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                
<%-- HTML Form --%>
<db:form name="viewForm"  destination="class" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="state" valueBinding="state@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
<uix:pageLayout titleBinding="viewHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>

    <%-- START: TAB CONTENTS starts here --%>


        <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
            
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				 <uix:styledText styleClass="OraDataText" textBinding="className@objectBean@servletRequest" />
                   </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOGGING_LEVEL@bundle@servletRequest"/> 
                     </uix:cellFormat>    
                     <uix:styledText styleClass="OraDataText" textBinding="displayLoggingLevel@objectBean@servletRequest" />       
                   </uix:contents>
                </uix:rowLayout>  
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LOG_HISTORY@bundle@servletRequest"/> 
                     </uix:cellFormat>    
                     <uix:styledText styleClass="OraDataText" textBinding="logHistory@objectBean@servletRequest" />       
                   </uix:contents>
                </uix:rowLayout>  
                
               <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="RSC_CON_GRP@bundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				 <uix:styledText styleClass="OraDataText" textBinding="rscGroup@objectBean@servletRequest" />
                   </uix:contents>
                </uix:rowLayout>
                
                               
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="SERVICE@bundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				 <uix:styledText styleClass="OraDataText" textBinding="service@objectBean@servletRequest" />
                   </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="DESCRIPTION@bundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				 <uix:styledText styleClass="OraDataText" textBinding="comments@objectBean@servletRequest" />
                   </uix:contents>
                </uix:rowLayout>
                
                </uix:contents>
              </uix:tableLayout>
              
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- View Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
    <uix:ref refID="pageButtonViewInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




