<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="classesForm" destination="classes" copyParams="target,type">    
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="JOB_CLASSES@bundle@servletRequest">
       
        <%@ include file="../refreshTime.jspf" %>
         <uix:spacer height="5"/>
        <uix:tableLayout width="100%" >
          <uix:rowLayout>
           <uix:styledText styleClass="OraInstructionText" textBinding="CLASS_DESC@bundle@servletRequest" />
          </uix:rowLayout>
          
          <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                    <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
              </uix:cellFormat>
          </uix:rowLayout>    
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="classes"
                           tableDataBinding="classList@defaultBean@servletRequest"
                           columnFormatsBinding="classColFormats@defaultBean@pageContext"
                           columnHeaderDataBinding="classColHeader@defaultBean@servletRequest" 
                           alternateTextBinding = "NO_CLASSES_FOUND@bundle@servletRequest"
                           blockSizeBinding="classBlockSize@defaultBean@servletRequest"
                           valueBinding="classValue@defaultBean@servletRequest" 
                           minValueBinding="classMinValue@defaultBean@servletRequest" 
                           maxValueBinding="classMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="JOB_CLASSES@bundle@servletRequest" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                  <%--    <uix:styledText textBinding="text"/> --%>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                               
                     <uix:link textBinding="name" destinationBinding="classDest" />  
                     <uix:styledText textBinding="logging_level"/> 
                     <uix:styledText textBinding="log_history"/>
                     <uix:styledText textBinding="consumer_group"/>     
                     <uix:styledText textBinding="service"/>                      
                     <uix:styledText textBinding="comments"/> 
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="JOB_CLASSES@bundle@servletRequest">
                      <uix:submitButton textBinding="EDIT@bundle@servletRequest" name="event" value="edit" /> 
                      <uix:submitButton textBinding="VIEW@bundle@servletRequest" name="event" value="view" />
                      <uix:submitButton textBinding="DELETE@bundle@servletRequest" name="event" value="delete" /> 
                      <uix:submitButton textBinding="CREATE_LIKE@bundle@servletRequest" name="event" value="create_like" /> 
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
<%--        
        <uix:spacer height="10"/>

          <uix:tableLayout>
            <uix:rowLayout>
              <uix:spacer height="10"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText styleClass="OraInstructionText"                               
                            textBinding="RELATED_LINK@bundle@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:link textBinding="JOBS@bundle@servletRequest"
                   destinationBinding="jobsURL@servletRequest"/> 
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
 --%>                  
         <oem:relatedLinks />
        </uix:header>    
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

