<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  
  <uix:document>
    <uix:metaContainer>      
      <uix:head titleBinding="CONFIRMATION@uixDBObjectBundle@servletRequest"/>    
    </uix:metaContainer>    
    
    <uix:body>      
      <db:form name="delForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">        
        <uix:formValue name="event"/>        
	    <uix:formValue name="backURL" valueBinding="backURL@servletRequest"/>        
        
        <uix:pageLayout>                  
          <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->          
          <%@ include file="/database/global.jspf" %>            
          
          <oem:messageBox messageType="error"                   
            errorTableBinding="errors@servletRequest"                  
            titleTextKey="titleText" mainTextKey="mainText"/>          
            
	  <uix:switcher childNameBinding="hasDependentJobs@defaultBean@servletRequest">
	    <uix:case name="false">
          <uix:header textBinding="CONFIRMATION@uixDBObjectBundle@servletRequest" icon="/em/images/confirmation.gif">            
            <uix:tableLayout>              
              <uix:rowLayout>              
                <%--                
                <uix:spacer width="40"/>              
                --%>                
                <uix:styledText styleClass="OraDataText"                                
                    textBinding="msgText@msgTable@servletRequest"/>              
              </uix:rowLayout>              
              <uix:rowLayout>                
                <uix:spacer height="10"/>              
              </uix:rowLayout>              
		<%--
              <uix:rowLayout>                
                <uix:tableLayout>                  
                  <uix:rowLayout>                    
                    <uix:cellFormat hAlign="right">                      
                      <uix:messagePrompt promptBinding="FORCE_DROP@ResourceBundle@servletRequest" />                    
                    </uix:cellFormat>                    
                    <uix:cellFormat hAlign="left">                      
                      <uix:radioButton textBinding="YES@uixDBObjectBundle@servletRequest"                         
                        name="dropForce"                                                             
                        selectedValueBinding="dropForce@defaultBean@servletRequest"                                                             
                        value="TRUE"/>                    
                     </uix:cellFormat>                  
                   </uix:rowLayout>                  
                   <uix:rowLayout>                    
                     <uix:cellFormat>                    
                     </uix:cellFormat>                    
                     <uix:cellFormat hAlign="left">                      
                       <uix:radioButton textBinding="NO@uixDBObjectBundle@servletRequest"                         
                        name="dropForce"                                                             
                        selectedValueBinding="dropForce@defaultBean@servletRequest"                                                             
                        value="FALSE" />                    
                      </uix:cellFormat>                  
                    </uix:rowLayout>                
                  </uix:tableLayout>              
                </uix:rowLayout>            
		--%>
              </uix:tableLayout>          
            </uix:header>          
	      </uix:case>
	      <uix:case name="true">
          <uix:header textBinding="WARNING@uixDBObjectBundle@servletRequest" icon="/em/images/confirmation.gif">
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:styledText styleClass="OraDataText"
                    textBinding="warnMsg@defaultBean@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout>
		<uix:spacer height="5"/>
              </uix:rowLayout>
	      <uix:rowLayout>
		<%--
		<uix:list name="dependentJobs" disabled="true" size="5">
		  <uix:contents childDataBinding="dependentJobs@defaultBean@serletRequest">
		    <uix:option textBinding="text"/>
		  </uix:contents>
		</uix:list>
		--%>
		<oem:list name="dependentJobs" optionsBinding="dependentJobs@defaultBean@servletRequest" disabled="false" size="10"/>
	      </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:styledText styleClass="OraDataText"
                    textBinding="DEL_MSG@ResourceBundle@servletRequest"/>
              </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
	      </uix:case>
	    </uix:switcher>
            
            <uix:pageButtons>            
              <uix:pageButtonBar>              
                <uix:submitButton textBinding="NO@uixDBObjectBundle@servletRequest"                      
                    name="event" value="noDelete"/>             
                <%--              
                <uix:button textBinding="YES@uixDBObjectBundle@servletRequest"                       
                    destinationBinding="deleteURL@servletRequest"/>              
                --%>              
                <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest"                      
                    name="event" value="doDelete"/>             
              </uix:pageButtonBar>          
            </uix:pageButtons>        
          </uix:pageLayout>        
        </db:form>                
      </uix:body>  
    </uix:document>
  </uix:renderingContext> 
