<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      {     }
     </script>
    </uix:metaContainer>
    
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                
<%-- HTML Form method="post"  --%>
<db:form name="generalForm" method="post" destination="job"
copyParams="target,type,cancelURL">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="state" valueBinding="state@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
  <uix:formValue name="jnum" valueBinding="jobNum@objectBean@servletRequest" /> 
 
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
        <uix:link textBinding="GENERAL@bundle@servletRequest"
                   onClick="submitForm('generalForm', true, {event:'goto1'})"/>
        <uix:link textBinding="SCHEDULE@bundle@servletRequest"
                   onClick="submitForm('generalForm', true, {event:'goto2'})"/>
        <uix:link textBinding="OPTIONS@bundle@servletRequest"
                   onClick="submitForm('generalForm', true, {event:'goto3'})"/>
     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>
    
        <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
            
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="NAME@bundle@servletRequest" required="yes" labeledNodeId="jobName"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                       
                    <uix:stackLayout>
                    <uix:contents>
                     
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:textInput id="jobName" name="jobName" textBinding="jobName@objectBean@servletRequest" />
                        </uix:case>   
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="jobName@objectBean@servletRequest"/>
                        </uix:case>         
                      </uix:switcher>                  
                      <uix:messageText messageBinding="jobName@errors@servletRequest" messageType="error"/>
                    </uix:contents>
                  </uix:stackLayout>               				 
                  </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest" required="yes"/>          
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/> 
                        </uix:case>
                      </uix:switcher>
                     </uix:cellFormat> 
                     
                     <%-- SWITCHER: schema --%>
                       <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                         <uix:case name="true"> 
                          <uix:stackLayout>                                 
                           <uix:messageLovField
                              name="schemaName" textBinding="schemaName@objectBean@servletRequest"
                              shortDescBinding="SEL_OWNER_DESC@bundle@servletRequest"
                              onClickBinding="schemaURL@servletRequest" />
                            <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/> 
                        </uix:stackLayout>
                         </uix:case>   
                         <uix:case name="false">
                           <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>   
                         </uix:case>         
                       </uix:switcher>
                    <%-- SWITCHER: schema --%>  
                                         
                  </uix:contents>
                </uix:rowLayout>   

                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="ENABLED@bundle@servletRequest"/> 
                     </uix:cellFormat>      
                     <uix:cellFormat>         
                      <uix:radioButton name="enabled"
                          textBinding="YES@bundle@servletRequest"
                          value="TRUE"
                          selectedValueBinding="enabled@objectBean@servletRequest" />      
                      <uix:radioButton name="enabled"
                          textBinding="NO@bundle@servletRequest"
                          value="FALSE"
                          selectedValueBinding="enabled@objectBean@servletRequest" /> 
                     </uix:cellFormat>                          
                   </uix:contents>
                </uix:rowLayout>
                                 
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="DESCRIPTION@bundle@servletRequest" labeledNodeId="comment"/> 
                     </uix:cellFormat>                     
            				 <uix:textInput id="comment" name="comment" textBinding="comment@objectBean@servletRequest" columns="65"/>
                   </uix:contents>
                </uix:rowLayout>
                
               <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                      <uix:messagePrompt promptBinding="LOGGING_LEVEL@bundle@servletRequest" labeledNodeId="loggingLevel"/> 
                      </uix:stackLayout>                        
                     </uix:cellFormat>    
                     <uix:stackLayout>
                     <uix:choice id="loggingLevel" name="loggingLevel"
                                 selectedValueBinding="loggingLevel@objectBean@servletRequest"                                
                                 shortDescBinding="LOGGING_LEVEL@bundle@servletRequest">
                                 <uix:contents childDataBinding="loggingList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                     </uix:choice>      
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="LOGGING_LEVEL_DESC@bundle@servletRequest" />                                
                     </uix:stackLayout>
                   </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="JOB_CLASS@bundle@servletRequest"/> 
                     </uix:cellFormat>    
                     <uix:tableLayout>
                       <uix:rowLayout>
                         <uix:messageLovField
                              name="displayJobClass" textBinding="displayJobClass@objectBean@servletRequest"
                              shortDescBinding="SEL_JOB_CLASS_DESC@bundle@servletRequest"
                              onClickBinding="jobclassURL@servletRequest" />
                        <uix:spacer width="10"/>                                      
                        <uix:submitButton textBinding="CREATE_CLASS@bundle@servletRequest" name="event" value="create_class" />                                     
                       </uix:rowLayout>
                     </uix:tableLayout>
                   </uix:contents>
                  </uix:rowLayout>         


                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="PERSISTENT@bundle@servletRequest" labeledNodeId="persistent"/> 
                      </uix:stackLayout> 
                     </uix:cellFormat>
                     <uix:stackLayout>                     
            				 <uix:choice id="persistent" name="persistent"
                                 selectedValueBinding="persistent@objectBean@servletRequest"                                
                                 shortDescBinding="PERSISTENT@bundle@servletRequest">
                                 <uix:contents childDataBinding="booleanList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                     </uix:choice>         
           				   <uix:styledText styleClass="OraInlineInfoText" textBinding="PERSISTENT_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>                                    
                    </uix:contents>
                </uix:rowLayout>
                
                 <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="RESTARTABLE@bundle@servletRequest" labeledNodeId="restartable"/> 
                      </uix:stackLayout> 
                     </uix:cellFormat>
                     <uix:stackLayout>                     
            				 <uix:choice id="restartable" name="restartable"
                                 selectedValueBinding="restartable@objectBean@servletRequest"                                
                                 shortDescBinding="RESTARTABLE@bundle@servletRequest">
                                 <uix:contents childDataBinding="booleanList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                     </uix:choice>         
           				   <uix:styledText styleClass="OraInlineInfoText" textBinding="RESTARTABLE_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>                                    
                    </uix:contents>
                </uix:rowLayout>   
         
                 
		<uix:rowLayout  renderedBinding="isVer11Higher@objectBean@servletRequest">
                   <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="DESTINATION@bundle@servletRequest" labeledNodeId="jobDestination"/>
                     </uix:cellFormat>
			<uix:stackLayout>
			<uix:tableLayout>
                       <uix:rowLayout>
                     <uix:textInput id="jobDestination" name="jobDestination" textBinding="jobDestination@objectBean@servletRequest"/> 
		   <uix:spacer width="10"/>
                       <uix:messagePrompt promptBinding="CREDENTIAL_NAME@bundle@servletRequest" labeledNodeId="credentialName"/><uix:spacer width="5"/>
                     
                                         <uix:choice id="credentialName" name="credentialName" 
				selectedValueBinding="credentialName@objectBean@servletRequest" 
                                 shortDescBinding="CREDENTIAL_NAME@bundle@servletRequest">
                                 <uix:contents childDataBinding="credentialNameList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                     </uix:choice>
			</uix:rowLayout>
			</uix:tableLayout>
			<uix:tableLayout>	
			<uix:rowLayout>
			<uix:cellFormat columnSpan="5">
			<uix:styledText styleClass="OraInlineInfoText" textBinding="REMOTE_JOB_DESC@bundle@servletRequest" />		
			</uix:cellFormat>
                          </uix:rowLayout>
                     </uix:tableLayout> 
</uix:stackLayout>                
                    </uix:contents>
                </uix:rowLayout>
                
 
                </uix:contents>
              </uix:tableLayout>
              
              <uix:spacer height="10"/>         
              <uix:header textBinding="COMMAND@bundle@servletRequest">
                  <uix:tableLayout width="100%">
                   
                    <uix:rowLayout>
                    <uix:spacer height="10"/> 
                    </uix:rowLayout>
                     <uix:rowLayout>
                     <uix:cellFormat hAlign="left" width="50%">
                        <uix:styledText styleClass="OraInstructionText" textBinding="COMMAND_DESC@bundle@servletRequest" />
                      </uix:cellFormat>                      
                    </uix:rowLayout>                                                                       
                  </uix:tableLayout>
                  <uix:spacer height="10"/> 
                  
              <uix:switcher  childNameBinding="cmdType@objectBean@servletRequest">
                <uix:case name="1">
                <uix:tableLayout>
                 <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="COMMAND_TYPE@bundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="5" />
                   <uix:styledText styleClass="OraDataText" 
                                  textBinding="PROGRAM@bundle@servletRequest" />
                   <uix:spacer width="10" />                                  
                   <uix:submitButton textBinding="CHANGE_CMD_TYPE@bundle@servletRequest" name="event" value="selectProgType" />                                  
                 </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="PROGRAM_NAME@bundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="5" />
                   <uix:styledText styleClass="OraDataText" 
                                  textBinding="programSchemaName@objectBean@servletRequest" />
                 </uix:rowLayout>
                 </uix:tableLayout>
               </uix:case>
               <uix:case name="2">
               <uix:stackLayout>
                <uix:tableLayout >
                 <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="COMMAND_TYPE@bundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="5" />
                   <uix:styledText styleClass="OraDataText" 
                                  textBinding="PLSQL@bundle@servletRequest" />
                   <uix:spacer width="10" />                                  
                   <uix:submitButton textBinding="CHANGE_CMD_TYPE@bundle@servletRequest" name="event" value="selectProgType" /> 
                 </uix:rowLayout>                 
                </uix:tableLayout>                 
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="PLSQL_TEXT@bundle@servletRequest" labeledNodeId="plsql"/>
                    </uix:cellFormat>   
                    <uix:textInput id="plsql" name="plsql" textBinding="plsql@objectBean@servletRequest" columns="90" rows="10" />
            				</uix:contents>
                  </uix:rowLayout>         
                </uix:tableLayout>                  
               </uix:stackLayout>                
               </uix:case>

              <uix:case name="3">
                <uix:tableLayout>
                 <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="COMMAND_TYPE@bundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="5" />
                   <uix:styledText styleClass="OraDataText" 
                                  textBinding="PROC@bundle@servletRequest" />
                   <uix:spacer width="10" />                                  
                   <uix:submitButton textBinding="CHANGE_CMD_TYPE@bundle@servletRequest" name="event" value="selectProgType" />                                  
                 </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="PROC@bundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="5" />
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="procSchemaName@objectBean@servletRequest" />                  
                  </uix:rowLayout>
                 </uix:tableLayout>
               </uix:case>
               <uix:case name="4">
                <uix:stackLayout>
                <uix:tableLayout cellSpacing="5">
                 <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="COMMAND_TYPE@bundle@servletRequest"/>
                    </uix:cellFormat>       
                    <uix:spacer width="5" />
                    <uix:tableLayout>     
                     <uix:rowLayout>
                      <uix:styledText styleClass="OraDataText" 
                                  textBinding="EXECUTABLE@bundle@servletRequest" />
                      <uix:spacer width="10" />                                  
                      <uix:submitButton textBinding="CHANGE_CMD_TYPE@bundle@servletRequest" name="event" value="selectProgType" />                                  
                      </uix:rowLayout>                      
                    </uix:tableLayout>
                 </uix:rowLayout>                                
                  <uix:rowLayout>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="EXECUTABLE_NAME@bundle@servletRequest" labeledNodeId="exe"/> 
                      </uix:stackLayout> 
                     </uix:cellFormat>   
                     <uix:spacer width="5" />
                     <uix:stackLayout>              
            				 <uix:textInput id="exe" name="exe" textBinding="exe@objectBean@servletRequest"  columns="60"/>
            				   <uix:styledText styleClass="OraInlineInfoText" textBinding="INC_FULL_PATH@bundle@servletRequest" />
          				    </uix:stackLayout>  
                  </uix:rowLayout>
                 </uix:tableLayout>
                </uix:stackLayout>
               </uix:case>
               
              <uix:case name="5">
                <uix:tableLayout>
                 <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="COMMAND_TYPE@bundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="5" />
                   <uix:styledText styleClass="OraDataText" 
                                  textBinding="CHAIN@bundle@servletRequest" />
                   <uix:spacer width="10" />                                  
                   <uix:submitButton textBinding="CHANGE_CMD_TYPE@bundle@servletRequest" name="event" value="selectProgType" />                                  
                 </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:messagePrompt promptBinding="CHAIN@bundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="5" />
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="chainSchemaName@objectBean@servletRequest" />                  
                  </uix:rowLayout>
                 </uix:tableLayout>
               </uix:case>
               
             </uix:switcher> 
         <uix:spacer height="10" />
         
                <%-- argument table --%>

    
         
         <uix:switcher  childNameBinding="argState@objectBean@servletRequest">
           <uix:case name="1">
                 <uix:header textBinding="ARGUMENTS@bundle@servletRequest">
                    <uix:rowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="ARG_DESC@bundle@servletRequest" />
                    </uix:rowLayout>  
             <uix:tableLayout cellSpacing="10" width="100%" >
               <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="ptab"       
                           tableDataBinding="progArgList@objectBean@servletRequest"
                           columnFormatsBinding="progArgColFormats@objectBean@servletRequest"
                           columnHeaderDataBinding="progArgHeader@objectBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@bundle@servletRequest"
                           blockSizeBinding="progArgBlockSize@objectBean@servletRequest"
                           valueBinding="progArgValue@objectBean@servletRequest" 
                           minValueBinding="progArgMinValue@objectBean@servletRequest" 
                           maxValueBinding="progArgMaxValue@objectBean@servletRequest"                           
                           formSubmitted="true"
                           summaryBinding="ARGUMENTS@bundle@servletRequest" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                    <uix:styledText textBinding="text"/> 
                   </uix:columnHeaderStamp>
                   
                     <uix:contents>             
                     <uix:dataScope>                                       
                       <uix:styledText textBinding="name" />     
                       <uix:formValue name="name" valueBinding="name"  />     
                     </uix:dataScope>
                     <uix:dataScope>
                       <uix:styledText textBinding="order"  />                      
                       <uix:formValue name="order" valueBinding="order"  />              
                     </uix:dataScope>
                     <uix:dataScope>
                     <uix:choice  name="default"
                                  selectedValueBinding="use_default" 
                                  onChange="submitForm('generalForm', true, {event:'changeOption'})"
                                  shortDescBinding="COLUMN_HEADER" > 
                                 <uix:contents childDataBinding="optionList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                      </uix:choice>      
                     <%--
                       <uix:styledText textBinding="default" />                                  
                       <uix:formValue name="default" valueBinding="default"  />                                
                       --%>
                     </uix:dataScope>       
                      <uix:dataScope>
                      <uix:switcher childNameBinding="use_default" >
                        <uix:case name="FALSE">      
                          <uix:textInput name="argVal"  columns="45" textBinding="argVal" shortDescBinding="COLUMN_HEADER"/> 
                       </uix:case>
                        <uix:default>
                         <uix:styledText textBinding="defVal" />  
                        </uix:default>
                      </uix:switcher>
                     </uix:dataScope>
                     <uix:dataScope>
                     <uix:styledText textBinding="type"/>                            
                     <uix:formValue name="type" valueBinding="type"  />                      
                     </uix:dataScope>

                   </uix:contents>
                 </uix:table>    
               </uix:rowLayout>                        
             </uix:tableLayout>                             
             </uix:header> 
           </uix:case>
           
           <uix:case name="2">
            <uix:header textBinding="ARGUMENTS@bundle@servletRequest">
                    <uix:rowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="ARG_DESC@bundle@servletRequest" />
                    </uix:rowLayout>  
             <uix:tableLayout cellSpacing="10" width="100%" >
               <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="ptab"
                           tableDataBinding="progArgList@objectBean@servletRequest"
                           columnFormatsBinding="inlineArgColFormats@objectBean@pageContext"
                           columnHeaderDataBinding="inlineArgHeader@objectBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@bundle@servletRequest"
                           blockSizeBinding="progArgBlockSize@objectBean@servletRequest"
                           valueBinding="progArgValue@objectBean@servletRequest" 
                           minValueBinding="progArgMinValue@objectBean@servletRequest" 
                           maxValueBinding="progArgMaxValue@objectBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="ARGUMENTS@bundle@servletRequest" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                    <uix:styledText textBinding="text"/> 
                   </uix:columnHeaderStamp>
                   
                     <uix:contents>             
                     <uix:textInput name="order" columns="10" textBinding="order" shortDescBinding="COLUMN_HEADER" />                      
                     <uix:textInput name="argVal"  columns="80" textBinding="argVal" shortDescBinding="COLUMN_HEADER" />
                      
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="ARGUMENTS@bundle@servletRequest">
                      <uix:submitButton textBinding="DELETE@bundle@servletRequest" name="event" value="delete_arg" /> 
                   </uix:singleSelection>
                  
                  </uix:tableSelection>   
                   <uix:columnFooter>
                    <uix:submitButton textBinding="ADD_ROW@bundle@servletRequest" 
                        name="event" value="add_arg"/>
                  </uix:columnFooter>                            
                   
                 </uix:table>    
               </uix:rowLayout>                        
             </uix:tableLayout>                             
            </uix:header>
<%--                       
             <uix:tableLayout cellSpacing="10" width="100%" >
               <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="inlineArgTab"
                           tableDataBinding="inlineArgList@objectBean@servletRequest"
                           columnFormatsBinding="inlineArgColFormats@objectBean@pageContext"
                           columnHeaderDataBinding="inlineArgHeader@objectBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@bundle@servletRequest"
                           blockSizeBinding="inlineArgBlockSize@objectBean@servletRequest"
                           valueBinding="inlineArgValue@objectBean@servletRequest" 
                           minValueBinding="inlineArgMinValue@objectBean@servletRequest" 
                           maxValueBinding="inlineArgMaxValue@objectBean@servletRequest"
                           formSubmitted="true" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                    <uix:styledText textBinding="text"/> 
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                                                    
                     <uix:textInput name="inlineArgTab"  textBinding="order" />                      
                     <uix:textInput name="inlineArgTab"  columns="80" textBinding="argValue" />
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0">
                      <uix:submitButton textBinding="DELETE@bundle@servletRequest" name="event" value="delete_row" /> 
                   </uix:singleSelection>
                  
                  </uix:tableSelection>   
                   <uix:columnFooter>
                    <uix:submitButton textBinding="ADD_ROW@bundle@servletRequest" 
                        name="event" value="add_rows"/>
                  </uix:columnFooter>                            
                 </uix:table>    

               </uix:rowLayout>                        
             </uix:tableLayout>                
 --%>             
           </uix:case>           
         </uix:switcher>     

      </uix:header>
                                                                                        
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




