<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="histForm" destination="jobs" copyParams="target,type,sname,oname,filter"> 
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
        <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="JOBS@bundle@servletRequest">
        <%@ include file="../refreshTime.jspf" %>

        <uix:spacer height="1"/>
        <uix:rowLayout width="100%" >
           <uix:cellFormat hAlign="right" vAlign="top" width="100%">
             <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
           </uix:cellFormat>
        </uix:rowLayout> 
        
        <%--
        ---- Subtabs
        --%>
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="2">
              <uix:link textBinding="ALL@bundle@servletRequest"    
                          destinationBinding="tab1@servletRequest"/>                      
              <uix:link textBinding="RUNNING@bundle@servletRequest"
                           destinationBinding="tab2@servletRequest"/>
              <uix:link textBinding="HISTORY@bundle@servletRequest"
                           destinationBinding="tab4@servletRequest"/>
                           
            </uix:subTabBar>
          </uix:subTabs>
        <uix:tableLayout cellSpacing="5" width="100%" >
          <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                    <uix:submitButton textBinding="PURGE_ALL_LOGS@bundle@servletRequest" name="event" value="purgeAll"/>
              </uix:cellFormat>
          </uix:rowLayout>             
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="history"
                           tableDataBinding="histList@defaultBean@servletRequest"
                           columnHeaderDataBinding="histColHeader@defaultBean@servletRequest"
                           columnFormatsBinding="histColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_JOB_HIST_FOUND@bundle@servletRequest"
                           blockSizeBinding="histBlockSize@defaultBean@servletRequest"
                           valueBinding="histValue@defaultBean@servletRequest" 
                           minValueBinding="histMinValue@defaultBean@servletRequest" 
                           maxValueBinding="histMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="HISTORY@bundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                    <uix:image sourceBinding="statusIcon"  destinationBinding="statusDest" shortDescBinding="completion_status" />
<%--                     <uix:styledText textBinding="completion_status"/>   
                    --%>
                    
                     <uix:styledText textBinding="name" destinationBinding="jobDest"/>      
                     <uix:link textBinding="owner" destinationBinding="ownerDest" />
                    <%--  <uix:styledText textBinding="log_id"/>  --%>
                                         
                    <%--  <uix:styledText textBinding="operation"/>  --%>   
                     <uix:styledText textBinding="log_date"/>  
                     <uix:styledText textBinding="run_duration"/>           
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="HISTORY@bundle@servletRequest">
                     <uix:submitButton textBinding="VIEW_JOB_STATUS@bundle@servletRequest" name="event" value="viewStatus" /> 
                     <uix:submitButton textBinding="PURGE_LOG@bundle@servletRequest" name="event" value="purge" />
                     <uix:submitButton textBinding="VIEW_DEFINITION@bundle@servletRequest" name="event" value="view" />
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
        <uix:spacer height="10"/>
<%--        
        <uix:checkBox name="showOps" textBinding="SHOW_OPS@bundle@servletRequest" checkedBinding="showOps@defaultBean@servletRequest" 
            onClick="submitForm('histForm', true, {event:'showOps'})" />
--%>            
        </uix:subTabLayout>    
        
        <oem:relatedLinks />        
       </uix:header>    
<%--       
        <uix:pageButtons> 
         <uix:pageButtonBar>         
            <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
         </uix:pageButtonBar>  
       </uix:pageButtons>
 --%>       
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

