<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

 <uix:styleSheet/>
  <db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      {          
      }
     </script>
    </uix:metaContainer>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                

<%-- HTML Form --%>
<db:form name="jobCommandForm"  destination="job" copyParams="target,type">
  <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
  <uix:formValue name="state" valueBinding="state@servletRequest"/> 
  <uix:formValue name="oname" valueBinding="oname@servletRequest" />
  <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
<uix:pageLayout titleBinding="SELECT_PROG@bundle@servletRequest">

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:rowLayout>
    <uix:cellFormat hAlign="left" >
      <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_PROGRAM@bundle@servletRequest" />
    </uix:cellFormat>
  </uix:rowLayout>   
   <uix:spacer height ="10"/> 
  <%-- START: TAB CONTENTS starts here --%>
   <uix:tableLayout cellSpacing="4">
              <uix:rowLayout>
                   <uix:contents>
                     <uix:tableLayout>
                     <uix:rowLayout>
                     <uix:cellFormat hAlign="left">
                      <uix:radioButton name="cmdType"
                          textBinding="PROGRAM_NAME@bundle@servletRequest"
                          value="1"
                          selectedValueBinding="cmdType@objectBean@servletRequest" />                      
                     </uix:cellFormat>    
                     <uix:spacer width="10"/>  
                     <uix:textInput name="programSchema"  textBinding="programSchema@objectBean@servletRequest" columns="15" />
                     <uix:styledText text="."/>                     
                      <uix:messageLovField
                              name="program" textBinding="program@objectBean@servletRequest"
                              shortDescBinding="SEL_PROG_DESC@bundle@servletRequest"
                              onClickBinding="progURL@servletRequest" />
                     <uix:spacer width="10"/> 
                     <uix:submitButton textBinding="CREATE_PROGRAM@bundle@servletRequest" name="event" value="create_program" />
                     </uix:rowLayout>
                     </uix:tableLayout>
                   </uix:contents>                   
                  </uix:rowLayout>                   

                   <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="left">
                      <uix:radioButton name="cmdType"
                          textBinding="INLINE_PLSQL@bundle@servletRequest"
                          value="2"
                          selectedValueBinding="cmdType@objectBean@servletRequest" />                      
                     </uix:cellFormat>                       
            				</uix:contents>
                  </uix:rowLayout>    

                   <uix:rowLayout>
                   <uix:contents>
                     <uix:tableLayout>
                     <uix:rowLayout>
                     <uix:cellFormat hAlign="left">
                      <uix:radioButton name="cmdType"
                          textBinding="INLINE_SP@bundle@servletRequest"
                          value="3"
                          selectedValueBinding="cmdType@objectBean@servletRequest" />                      
                     </uix:cellFormat>   
                     <uix:spacer width="10"/>  
                     <uix:textInput name="procSchema"  textBinding="procSchema@objectBean@servletRequest" columns="15" />
                     <uix:styledText text="."/>                     
                      <uix:messageLovField
                              name="proc" textBinding="proc@objectBean@servletRequest"
                              shortDescBinding="SEL_PROC_DESC@bundle@servletRequest"
                              onClickBinding="procURL@servletRequest" /> 
                      </uix:rowLayout>        
                      </uix:tableLayout>
            				</uix:contents>
                    
                  </uix:rowLayout>    

                   <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="left">
                      <uix:radioButton name="cmdType"
                          textBinding="INLINE_EXE@bundle@servletRequest"
                          value="4"
                          selectedValueBinding="cmdType@objectBean@servletRequest" />                      
                     </uix:cellFormat>                       
            				</uix:contents>
                  </uix:rowLayout>         
                  
                 <uix:rowLayout renderedBinding="isVer102Higher@objectBean@servletRequest">
                     <uix:tableLayout>
                     <uix:rowLayout>
                     <uix:cellFormat hAlign="left">
                      <uix:radioButton name="cmdType"
                          textBinding="CHAIN@bundle@servletRequest"
                          value="5"
                          selectedValueBinding="cmdType@objectBean@servletRequest" />                      
                     </uix:cellFormat>   
                     <uix:spacer width="10"/>  
                     
                     <uix:textInput name="chainSchema"  textBinding="chainSchema@objectBean@servletRequest" columns="15" />
                     <uix:styledText text="."/>
                     <uix:messageLovField
                              name="chain" textBinding="chain@objectBean@servletRequest"
                              shortDescBinding="SEL_CHAIN_DESC@bundle@servletRequest"
                              onClickBinding="chainURL@servletRequest" /> 
                      <uix:spacer width="10"/> 
                      <uix:submitButton textBinding="CREATE_CHAIN@bundle@servletRequest" name="event" value="create_chain" />                              
                      </uix:rowLayout>        
                      </uix:tableLayout>
                  </uix:rowLayout>                      
   </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   


  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelCmd" />
    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="okCmd" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>

</uix:body> 
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




