<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                

<%-- HTML Form --%>
<db:form name="viewForm"  destination="jobs" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 
<uix:pageLayout titleBinding="viewHeader@jobHistBean@servletRequest">
  <uix:formValue name="oname" valueBinding="oname@servletRequest" />
  <uix:formValue name="sname" valueBinding="sname@servletRequest" />       
  
  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>
  <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
    <%-- START: TAB CONTENTS starts here --%>
    
      <uix:header textBinding="GENERAL@bundle@servletRequest">              
        <uix:tableLayout cellSpacing="5" width="100%">
        
      <uix:cellFormat vAlign="top" hAlign="left">
      <uix:tableLayout cellSpacing="5">
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="name@jobHistBean@servletRequest" />
       </uix:rowLayout>
       
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="LOG_ID@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="logID@jobHistBean@servletRequest" />
       </uix:rowLayout>
       </uix:tableLayout>
      </uix:cellFormat> 
      
      <uix:cellFormat vAlign="top" hAlign="left">
      <uix:tableLayout cellSpacing="5">
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="owner@jobHistBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="USER_NAME@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="userName@jobHistBean@servletRequest" />
       </uix:rowLayout>
      </uix:tableLayout>
      </uix:cellFormat>

      <uix:cellFormat vAlign="top" hAlign="left">      
      <uix:tableLayout cellSpacing="5">      
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="OPERATION@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="operation@jobHistBean@servletRequest" />
       </uix:rowLayout>
       
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="STATUS@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="status@jobHistBean@servletRequest" />
       </uix:rowLayout>
      </uix:tableLayout>
      </uix:cellFormat>
      
      </uix:tableLayout> 
                
   
     
    <uix:tableLayout width="100%" cellSpacing="5" >
      <uix:cellFormat vAlign="top" hAlign="left">      
       <uix:rowLayout>
         <uix:cellFormat hAlign="right">
           <uix:messagePrompt promptBinding="LOG_DATE@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:spacer width="5" />
         <uix:styledText styleClass="OraDataText" 
                         textBinding="logDate@jobHistBean@servletRequest" />
       </uix:rowLayout>

      <uix:switcher  childNameBinding="showLogInfo@jobHistBean@servletRequest">
       <uix:case name="true">   
       <uix:rowLayout>
         <uix:cellFormat hAlign="right">
           <uix:messagePrompt promptBinding="LOG_INFO@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:spacer width="5" />
         <uix:styledText styleClass="OraDataText" 
                         textBinding="logInfo@jobHistBean@servletRequest" />
       </uix:rowLayout>
       </uix:case>
     </uix:switcher>
      </uix:cellFormat>             
     </uix:tableLayout> 

     </uix:header>  
     
      <uix:switcher  childNameBinding="showDetails@jobHistBean@servletRequest">
          <uix:case name="true">  
          
      <uix:header textBinding="RUN_DETAILS@bundle@servletRequest">                        
      <uix:tableLayout cellSpacing="5"> 

       <uix:cellFormat vAlign="top" hAlign="left">
         <uix:tableLayout cellSpacing="5">     
         <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="REQ_START_DATE@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="reqStartDate@jobHistBean@servletRequest" />
       </uix:rowLayout>
               
      <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="ACT_START_DATE@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="actualStartDate@jobHistBean@servletRequest" />
       </uix:rowLayout>
       
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="ERROR_NO@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="errorNo@jobHistBean@servletRequest" />
       </uix:rowLayout>
        </uix:tableLayout>
      </uix:cellFormat>
      
       <uix:cellFormat vAlign="top" hAlign="left">
         <uix:tableLayout cellSpacing="5">     
      <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="RUN_DURATION@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="runDuration@jobHistBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="CPU_TIME@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="cpuUsed@jobHistBean@servletRequest" />
       </uix:rowLayout>   

        </uix:tableLayout>
      </uix:cellFormat>

       <uix:cellFormat vAlign="top" hAlign="left">
         <uix:tableLayout cellSpacing="5">                                     
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="INSTANCE_ID@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="instID@jobHistBean@servletRequest" />
       </uix:rowLayout>                                                      
          
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="SESSION_ID@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="sessionID@jobHistBean@servletRequest" />
       </uix:rowLayout>            

       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="PROCESS_ID@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="processID@jobHistBean@servletRequest" />
       </uix:rowLayout>      
       
        </uix:tableLayout>
      </uix:cellFormat>  
      </uix:tableLayout>  

    <uix:tableLayout width="100%" cellSpacing="5" >
      <uix:cellFormat vAlign="top" hAlign="left">      

            <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="DETAILS@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="details@jobHistBean@servletRequest" />
       </uix:rowLayout>  
      </uix:cellFormat>  
      </uix:tableLayout>  
       

      </uix:header>
          </uix:case>
       </uix:switcher>

    <%-- END: TAB CONTENTS ends here --%>   

       <uix:pageButtons> 
         <uix:pageButtonBar>   
           <uix:button textBinding="OK@bundle@servletRequest" destinationBinding="jobHistDest@servletRequest" />
         </uix:pageButtonBar>  
       </uix:pageButtons>
                       
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




