<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  
  <uix:document>    
    <%@ include file="/oemTitle.jspf" %>      
    
    <uix:body>      
      <uix:contents>      
        <db:form name="delForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">        
	      <uix:formValue name="backURL" valueBinding="backURL@servletRequest"/>        
	      
          <uix:pageLayout titleBinding="header@defaultBean@servletRequest">                   
            <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->          
            <%@ include file="/database/global.jspf" %>
            
            <%--          <uix:header textBinding="OPEN_WINDOW@ResourceBundle@servletRequest">          --%>
            <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                msgBundleBinding="ResourceBundle"  titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout cellSpacing="5">              
              <uix:rowLayout>                
                <uix:styledText styleClass="OraInstructionText"                                
                    textBinding="OPEN_WINDOW_TEXT@ResourceBundle@servletRequest"/>              
              </uix:rowLayout>              
              <uix:rowLayout>                
                <uix:spacer height="5"/>              
              </uix:rowLayout>              
              <uix:rowLayout>                
                <uix:cellFormat> 
                  <uix:messagePrompt promptBinding="DURATION@ResourceBundle@servletRequest" labeledNodeId="openDurationHour"/>                  
                  <uix:spacer width="5"/>                  
                  <uix:textInput id="openDurationHour" name="openDurationHour"                         
                      textBinding="openDurationHour@defaultBean@servletRequest"                         
                      columns="10"/>                  
                  <uix:styledText styleClass="OraInstructionText" textBinding="HOURS@scheduleBundle@servletRequest"/>                  
                  <uix:textInput name="openDurationMinute"                         
                      textBinding="openDurationMinute@defaultBean@servletRequest"                         
                      columns="10" shortDescBinding="DURATION@ResourceBundle@servletRequest" />                  
                  <uix:styledText styleClass="OraInstructionText" textBinding="MINUTES@scheduleBundle@servletRequest" />                
                </uix:cellFormat>              
              </uix:rowLayout>   
              <uix:rowLayout>                
                <uix:spacer width="10"/>              
              </uix:rowLayout>              
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">                      
                        <uix:messagePrompt promptBinding="FORCE_OPEN@ResourceBundle@servletRequest" />                    
                      </uix:cellFormat>                    
                      <uix:cellFormat hAlign="left">                      
                        <uix:radioButton textBinding="YES@uixDBObjectBundle@servletRequest"                         
                            name="openForce"                                                             
                            selectedValueBinding="openForce@defaultBean@servletRequest"                                                             
                            value="TRUE"/>                    
                      </uix:cellFormat>                  
                    </uix:rowLayout>                  
                    <uix:rowLayout>                    
                      <uix:cellFormat>                    
                      </uix:cellFormat>                    
                      <uix:cellFormat hAlign="left">                      
                        <uix:radioButton textBinding="NO@uixDBObjectBundle@servletRequest"                         
                            name="openForce"                                                             
                            selectedValueBinding="openForce@defaultBean@servletRequest"                                                             
                            value="FALSE" />                    
                      </uix:cellFormat>                  
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>            
            <%--          </uix:header>          --%>          
          
            <uix:pageButtons>            
              <uix:pageButtonBar>              
                <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest"                       
                    destinationBinding="backURL@servletRequest"/>              
                <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"                      
                    name="event" value="doOpen"/>             
              </uix:pageButtonBar>          
            </uix:pageButtons>        
          </uix:pageLayout>        
        </db:form>                  
      </uix:contents>    
    </uix:body>  
  </uix:document>
</uix:renderingContext> 
