<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                
<%-- HTML Form --%>
<db:form name="optionsForm" method="post"  destination="job" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
<uix:formValue name="optionsForm" value="true"/> 
 <uix:formValue name="state" valueBinding="state@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" />  
 <uix:formValue name="jnum" valueBinding="jobNum@objectBean@servletRequest" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="2">
        <uix:link textBinding="GENERAL@bundle@servletRequest"
                   onClick="submitForm('optionsForm', true, {event:'goto1'})"/>
        <uix:link textBinding="SCHEDULE@bundle@servletRequest"
                   onClick="submitForm('optionsForm', true, {event:'goto2'})"/>
        <uix:link textBinding="OPTIONS@bundle@servletRequest"
                   onClick="submitForm('optionsForm', true, {event:'goto3'})"/>
     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>


        <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
            
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                 <uix:rowLayout renderedBinding="isVer102Higher@objectBean@servletRequest">
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="RAISE_EVENTS@bundle@servletRequest"/>
                      </uix:stackLayout>
                     </uix:cellFormat>
                     <uix:stackLayout>                     
			<uix:tableLayout cellSpacing="5">
			  <uix:rowLayout>
			    <uix:contents>
			      <uix:checkBox name="eventStarted" textBinding="JOB_STARTED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventStarted@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			      <uix:checkBox name="eventSucceeded" textBinding="JOB_SUCCEEDED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventSucceeded@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			      <uix:checkBox name="eventFailed" textBinding="JOB_FAILED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventFailed@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			    </uix:contents>
			  </uix:rowLayout>
			  <uix:rowLayout>
			    <uix:contents>
			      <uix:checkBox name="eventStopped" textBinding="JOB_STOPPED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventStopped@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			      <uix:checkBox name="eventBroken" textBinding="JOB_BROKEN@bundle@servletRequest" value="TRUE" selectedValueBinding="eventBroken@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			      <uix:checkBox name="eventDisabled" textBinding="JOB_DISABLED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventDisabled@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			    </uix:contents>
			  </uix:rowLayout>
			  <uix:rowLayout>
			    <uix:contents>
			      <uix:checkBox name="eventCompleted" textBinding="JOB_COMPLETED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventCompleted@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			      <uix:checkBox name="eventChainStalled" textBinding="JOB_CHAIN_STALLED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventChainStalled@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			      <uix:checkBox name="eventSchLimitReached" textBinding="JOB_SCH_LIM_REACHED@bundle@servletRequest" value="TRUE" selectedValueBinding="eventSchLimitReached@objectBean@servletRequest"/>
			      <uix:spacer width="5"/>
			    </uix:contents>
			  </uix:rowLayout>
			  <uix:rowLayout renderedBinding="isEditing@objectBean@servletRequest">
			    <uix:contents>
			      <uix:checkBox name="eventOverMaxDuration" readOnly="true" textBinding="JOB_OVER_MAX_DUR@bundle@servletRequest" value="TRUE" selectedValueBinding="eventOverMaxDuration@objectBean@servletRequest"/>
			    </uix:contents>
			  </uix:rowLayout>
			 </uix:tableLayout>
			 <uix:styledText styleClass="OraInlineInfoText" textBinding="RAISE_EVENTS_DESC@bundle@servletRequest" />
          		</uix:stackLayout>               				 
                   </uix:contents>
                </uix:rowLayout>               

                <uix:rowLayout renderedBinding="isVer102Higher@objectBean@servletRequest">
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="MAX_RUN_DURATION@bundle@servletRequest"/> 
                      </uix:stackLayout>
                     </uix:cellFormat>
                     <uix:stackLayout>                     
            				 <uix:textInput name="maxRunDuration" textBinding="maxRunDuration@objectBean@servletRequest" />
           				   <uix:styledText styleClass="OraInlineInfoText" textBinding="MAX_RUN_DURATION_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>               				 
                   </uix:contents>
                </uix:rowLayout>             
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/>   
                       <uix:messagePrompt promptBinding="START_PRIORITY@bundle@servletRequest" labeledNodeId="priority"/> 
                      </uix:stackLayout>  
                     </uix:cellFormat>
                     <uix:stackLayout>                     
            				    <uix:choice id="priority" name="priority"
                                 selectedValueBinding="priority@objectBean@servletRequest"                                
                                 shortDescBinding="START_PRIORITY@bundle@servletRequest">
                                 <uix:contents childDataBinding="priorityList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                        </uix:choice>  
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="PRIORITY_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>               				 
                   </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="SCHEDULE_LIMIT@bundle@servletRequest" labeledNodeId="scheduleLimit"/> 
                      </uix:stackLayout>
                     </uix:cellFormat>
                     <uix:stackLayout>                     
            				 <uix:textInput id="scheduleLimit" name="scheduleLimit" textBinding="scheduleLimit@objectBean@servletRequest" />
           				   <uix:styledText styleClass="OraInlineInfoText" textBinding="SCHEDULE_LIMIT_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>               				 
                   </uix:contents>
                </uix:rowLayout>                
                
               <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="MAX_RUNS@bundle@servletRequest" labeledNodeId="maxRuns"/> 
                      </uix:stackLayout> 
                     </uix:cellFormat>       
                     <uix:stackLayout>              
            				 <uix:textInput id="maxRuns" name="maxRuns" textBinding="maxRuns@objectBean@servletRequest" />
            				   <uix:styledText styleClass="OraInlineInfoText" textBinding="MAX_RUNS_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>            				 
                   </uix:contents>
                </uix:rowLayout>
                


                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="MAX_FAILURES@bundle@servletRequest" labeledNodeId="maxFailues"/> 
                      </uix:stackLayout> 
                     </uix:cellFormat>
                     <uix:stackLayout>                     
            				 <uix:textInput id="maxFailues" name="maxFailues" textBinding="maxFailues@objectBean@servletRequest" />
           				   <uix:styledText styleClass="OraInlineInfoText" textBinding="MAX_FAILURES_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>               				 
                   </uix:contents>
                </uix:rowLayout>                
                                                                             
                                                                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="JOB_WEIGHT@bundle@servletRequest" labeledNodeId="jobWeight"/> 
                      </uix:stackLayout> 
                     </uix:cellFormat>                     
                      <uix:stackLayout>
            				   <uix:textInput id="jobWeight" name="jobWeight" textBinding="jobWeight@objectBean@servletRequest" />
            				   <uix:styledText styleClass="OraInlineInfoText" textBinding="JOB_WEIGHT_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>
                   </uix:contents>
                </uix:rowLayout> 
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:stackLayout>  
                       <uix:spacer height="5"/> 
                       <uix:messagePrompt promptBinding="INSTANCE_STICK@bundle@servletRequest" labeledNodeId="instStick"/> 
                      </uix:stackLayout> 
                     </uix:cellFormat>    
                     <uix:stackLayout>                 
            				 <uix:choice id="instStick" name="instStick"
                                 selectedValueBinding="instStick@objectBean@servletRequest"                                
                                 shortDescBinding="INSTANCE_STICK@bundle@servletRequest">
                                 <uix:contents childDataBinding="booleanList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                                 </uix:contents>
                     </uix:choice>         
           				   <uix:styledText styleClass="OraInlineInfoText" textBinding="INSTANCE_STICK_DESC@bundle@servletRequest" />
          				    </uix:stackLayout>                                    
                    </uix:contents>
                </uix:rowLayout>
                
                </uix:contents>
              </uix:tableLayout>
              
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout> 
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
