 <!-- ================  Program Page =================== -->

<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%--
<jsp:useBean id="objectBean" scope="request"   type="oracle.sysman.emo.adm.instance.scheduler.Program"/>
--%>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="progForm" method="post" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">
        <uix:formValue name="pageName" value="/database/instance/scheduler/programPage"/>
        <uix:formValue name="event"/>

        <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
 
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info"
                   errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                   errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

<%--
          <uix:header textBinding="GENERAL@DBObjectMsgBundle@servletRequest">
--%>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                    <uix:case name="true">                   
                      <uix:messagePrompt promptBinding="NAME@DBObjectMsgBundle@servletRequest" required="yes" labeledNodeId="objectName"/> 
                    </uix:case>
                    <uix:case name="false">
                      <uix:messagePrompt promptBinding="NAME@DBObjectMsgBundle@servletRequest"/>
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
                <uix:stackLayout>
                  <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                    <uix:case name="true">                    
                      <uix:textInput id="objectName" name="objectName" textBinding="objectName@defaultBean@servletRequest" />
                    </uix:case>
                    <uix:case name="false">
                      <uix:styledText styleClass="OraDataText" textBinding="objectName@defaultBean@servletRequest"/>
                    </uix:case>
                  </uix:switcher>
                  <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="SCHEMA@DBObjectMsgBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:lovField name="schemaName"                            
                              textBinding="schemaName@defaultBean@servletRequest"
                              onClickBinding="schemaDestination@defaultBean@servletRequest" />
              </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText" textBinding="schemaName@defaultBean@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="ENABLED@DBObjectMsgBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:radioButton name="enabled"
                         value="TRUE"
                         selectedValueBinding="enabled@defaultBean@servletRequest"
                         textBinding="YES@DBObjectMsgBundle@servletRequest" />
                  <uix:radioButton name="enabled"
                         value="FALSE"
                         selectedValueBinding="enabled@defaultBean@servletRequest"
                         textBinding="NO@DBObjectMsgBundle@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:messagePrompt promptBinding="COMMENT@ResourceBundle@servletRequest" labeledNodeId="comment"/>
                </uix:cellFormat>
                <uix:textInput id="comment" name="comment" textBinding="comment@defaultBean@servletRequest" columns="80"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="TYPE@DBObjectMsgBundle@servletRequest" labeledNodeId="programType"/>
                </uix:cellFormat>
                <uix:choice id="programType" name="programType" onChange="submitForm('progForm', true, {'event':'changeType'})"
                         selectedValueBinding="programType@defaultBean@servletRequest">
                  <uix:option text="PLSQL_BLOCK" value="PLSQL_BLOCK"/>                    
		  <uix:option text="STORED_PROCEDURE" value="STORED_PROCEDURE"/>
                  <uix:option text="EXECUTABLE" value="EXECUTABLE"/>
                </uix:choice>
              </uix:rowLayout>
              <uix:switcher childNameBinding="programType@defaultBean@servletRequest">
                <uix:case name="PLSQL_BLOCK">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top">
                          <uix:messagePrompt promptBinding="SOURCE@DBObjectMsgBundle@servletRequest" required="yes" labeledNodeId="PLSQLBlock"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
                      <uix:textInput id="PLSQLBlock" name="PLSQLBlock" textBinding="PLSQLBlock@defaultBean@servletRequest"
                             columns="80" rows="10"/>
                      <uix:messageText messageBinding="PLSQLBlock@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:case>
                <uix:case name="STORED_PROCEDURE">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="PROCEDURE_NAME@DBObjectMsgBundle@servletRequest" required="yes"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="PROCEDURE_NAME@DBObjectMsgBundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                    <uix:stackLayout>
                      <uix:rowLayout>
<%--                      
                        <uix:textInput name="storedProcedureSchema"  textBinding="storedProcedure@objectBean@servletRequest" columns="15" />
                        <uix:styledText text="."/>
                        <uix:textInput name="storedProcedure" textBinding="storedProcedure@defaultBean@servletRequest"
				onChange="submitForm(document.forms[0].name, 1,{event:'setProcName'})" />
--%>
			<uix:styledText styleClass="OraDataText" textBinding="displayStoredProcedure@defaultBean@servletRequest"/>		
      
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="SELECT_PROC@ResourceBundle@servletRequest"
                            name="event" value="selectSchemaAndObject"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="VIEW_PROC@ResourceBundle@servletRequest"
                            name="event" value="viewProcedureDetail"/>
                      </uix:rowLayout>
                      <uix:messageText messageBinding="storedProcedure@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:case>
                <uix:case name="EXECUTABLE">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top">
                          <uix:messagePrompt promptBinding="EXECUTABLE_NAME@ResourceBundle@servletRequest" required="yes" labeledNodeId="executable"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
                      <uix:textInput id="executable" name="executable" textBinding="executable@defaultBean@servletRequest"
                             columns="80" rows="1"/>
			<uix:styledText styleClass="OraInlineInfoText" textBinding="INC_FULL_PATH@ResourceBundle@servletRequest"/>
                      <uix:messageText messageBinding="executable@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
<%--
          </uix:header>
--%>
          <uix:switcher childNameBinding="showArguments@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:header textBinding="ARGUMENTS@ResourceBundle@servletRequest">
                <uix:switcher childNameBinding="programType@defaultBean@servletRequest">
                  <uix:case name="EXECUTABLE">
                    <uix:tableLayout cellSpacing="5" width="100%">
                      <uix:rowLayout>
                        <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
                                               formSubmitted="true"
                                              dataSourceProp="twoDUIDataSource" width="100%"
			                       blockSize="25" partialRenderMode="self"
                             summaryBinding="ARGUMENTS@ResourceBundle@servletRequest" >
                          <uix:tableSelection>
                            <oem:singleSelection selectedIndexBinding="selectedIndex@dataSourceBean@servletRequest" shortDescBinding="ARGUMENTS@ResourceBundle@servletRequest">
                              <uix:submitButton textBinding="DELETE@DBObjectMsgBundle@servletRequest"
                                 name="event" value="deleteArgument"/>
                            </oem:singleSelection>
                          </uix:tableSelection>
                        </oem:table>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:submitButton textBinding="ADD_ARGUMENT@ResourceBundle@servletRequest"
	                     name="event" value="addArgument"/>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:case>
                  <uix:case name="STORED_PROCEDURE">
                    <uix:tableLayout cellSpacing="5" width="100%">
                      <uix:rowLayout>
                        <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
                                               formSubmitted="true"
                                              dataSourceProp="twoDUIDataSource" width="100%"
			                       blockSize="25" partialRenderMode="self"
						alternateTextBinding="NO_PROC_ARG@ResourceBundle@servletRequest">
                        </oem:table>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:case>
                </uix:switcher>
              </uix:header>
            </uix:case>
          </uix:switcher>

          <%-- Create/Edit Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>  
