<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
 <uix:styleSheet/>
  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/> 
  <script>
    function lovSelect(lovField)
    {
      var proxy = new TableProxy("rscGrpTable");
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement1 = proxy.getFormElement('name', selectedIndex);
        lovField.value =  selectedElement1.value;        
      }
      window.close();
    }
  </script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                

<%-- HTML Form --%>
<db:form name="generalForm"  destination="class" copyParams="target,type">
  <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
  <uix:formValue name="state" valueBinding="state@servletRequest"/> 
  <uix:formValue name="oname" valueBinding="oname@servletRequest" />
<uix:pageLayout titleBinding="SEARCH_SEL_RSCGRP@bundle@servletRequest">

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


  <%-- START: TAB CONTENTS starts here --%>
   <uix:tableLayout cellSpacing="4" width="100%">
            <uix:rowLayout hAlign="right">

              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <uix:cellFormat>
              
              <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest"/>
                <uix:tableLayout cellSpacing="4">
                    <uix:contents>
                    
                    <uix:rowLayout hAlign='left'>
                       <uix:contents>
                       <uix:cellFormat width = "13">
                       </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="OBJECT_NAME_COLON@uixDBObjectBundle@servletRequest" labeledNodeId="rscGrpName"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                         <uix:textInput id="rscGrpName" name="rscGrpName" textBinding="rscGrpName@objectBean@servletRequest"/>
                        </uix:cellFormat> 
                        <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest"
                            name="event" value="changeRscGrp"/>
                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>

              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:header textBinding="RESULTS@uixDBObjectBundle@servletRequest">
                    <uix:table  width="100%"
                           name="rscGrpTable"
                           tableDataBinding="rscGrpList@objectBean@servletRequest"
                           columnFormatsBinding="rscGrpColFormats@objectBean@pageContext"
                           columnHeaderDataBinding="rscGrpColHeader@objectBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@bundle@servletRequest"                           
                           valueBinding="rscGrpVal@objectBean@servletRequest" 
                           blockSizeBinding="rscGrpBlockSize@objectBean@servletRequest"                         
                           minValueBinding="rscGrpMinValue@objectBean@servletRequest" 
                           maxValueBinding="rscGrpMaxValue@objectBean@servletRequest"
                           formSubmitted="true"
                           summaryBinding="RESULTS@uixDBObjectBundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/>                      
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                              
                     <uix:styledText textBinding="name"/>      
                     <uix:formValue name="name" valueBinding="name"/>                                     
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="SEARCH_SEL_RSCGRP@bundle@servletRequest"/>
                   </uix:tableSelection>
                 </uix:table>  
                    
                  </uix:header>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   


  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                destination="javascript:self.close()"/>
    <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" 
                 destinationBinding="rscGrpDest@servletRequest"/> 
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>

</uix:body> 
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




