<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

          
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="scheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>          
  <uix:bundle name="dbschedulebundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>   
<oem:setURLEncoder id="renderingContext"/>

 <uix:switcher childNameBinding="refreshChoice@objectBean@servletRequest">
     <uix:case name="RT_60">
       <uix:switcher childNameBinding="isChain@objectBean@servletRequest">
          <uix:case name="true">
            <uix:rawText>
	              <meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>">
            </uix:rawText> 
          </uix:case>
        </uix:switcher>  
      </uix:case>  
  </uix:switcher>

<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>


          
<uix:body>                

<%-- HTML Form --%>
<db:form name="viewForm"  destination="job" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 
<uix:pageLayout titleBinding="viewRunHeader@objectBean@servletRequest">


  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
                  
<uix:tableLayout  width="100%"   renderedBinding="isChain@objectBean@servletRequest">
  <uix:rowLayout hAlign="right">   
  <uix:tableLayout >
      <uix:rowLayout  hAlign="right">   
              <uix:cellFormat hAlign="right"> 
                    <uix:messagePrompt promptBinding="VIEW_DATA@bundle@servletRequest" labeledNodeId="refreshChoice"/> 
                    </uix:cellFormat> 
                    <uix:cellFormat hAlign="right"> 
                      <uix:spacer width="5" />
                      <uix:choice id="refreshChoice" name="refreshChoice"
                                 onChange="submitForm('viewForm', true, {'event':'viewRun'})"
                                 selectedValueBinding="refreshChoice@objectBean@servletRequest"                                
                                 shortDescBinding="VIEW_DATA@bundle@servletRequest">
                                 <uix:contents childDataBinding="refreshChoiceList@objectBean@servletRequest">
                                    <uix:option textBinding="jtext"
                                                valueBinding="jval"/>
                     </uix:contents>
                    </uix:choice>      
                    </uix:cellFormat>                        
      </uix:rowLayout>     
   </uix:tableLayout>  
  </uix:rowLayout>     
</uix:tableLayout>  

    <%-- START: TAB CONTENTS starts here --%>
    <uix:header textBinding="GENERAL@bundle@servletRequest">
    <uix:tableLayout cellSpacing="5" width="100%"> 
      <uix:rowLayout>  
       <uix:cellFormat>
        <uix:tableLayout cellSpacing="5">    
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
         </uix:cellFormat>         
         <uix:styledText styleClass="OraDataText" 
                         textBinding="jobName@objectBean@servletRequest" />
        </uix:rowLayout>
        </uix:tableLayout> 
       </uix:cellFormat>

       <uix:cellFormat >
       <uix:tableLayout cellSpacing="5"> 
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/>
         </uix:cellFormat>         
         <uix:link  textBinding="schemaName@objectBean@servletRequest" destinationBinding="ownerUrl@servletRequest"/>
       </uix:rowLayout>
       </uix:tableLayout> 
       </uix:cellFormat>

       <uix:cellFormat >
        <uix:tableLayout cellSpacing="5"> 
         <uix:rowLayout>
          <uix:cellFormat hAlign="right" >
            <uix:messagePrompt promptBinding="STATUS@bundle@servletRequest"/>
          </uix:cellFormat>         
          <uix:styledText styleClass="OraDataText" 
                         textBinding="runStatus@objectBean@servletRequest" />
        </uix:rowLayout>
        </uix:tableLayout> 
       </uix:cellFormat>
       
       </uix:rowLayout>  
    </uix:tableLayout>
     
    <jsp:include page="cmd.jsp" />
          <uix:ref refID="cmd" />

  </uix:header>
 
  <uix:header textBinding="STEP_STATUS@bundle@servletRequest" renderedBinding="isChain@objectBean@servletRequest">    
    
    <uix:tableLayout cellSpacing="2" width="100%" >
      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="right" vAlign="top" width="100%">
          <uix:submitButton textBinding="EVALUATE_CHAIN@bundle@servletRequest" name="event" value="evalChain"/>
        </uix:cellFormat>            
      </uix:rowLayout>        
      <uix:rowLayout>      
           <uix:tableLayout width="100%" >         
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="runChain"
                           tableDataBinding="runChainList@defaultBean@servletRequest"
                           columnHeaderDataBinding="runChainColHeader@defaultBean@servletRequest"
                           columnFormatsBinding="runChainColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_STEP_FOUND@bundle@servletRequest"
                           blockSizeBinding="runChainBlockSize@defaultBean@servletRequest"
                           valueBinding="runChainValue@defaultBean@servletRequest" 
                           minValueBinding="runChainMinValue@defaultBean@servletRequest" 
                           maxValueBinding="runChainMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="STEP_STATUS@bundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:styledText textBinding="state"/>  
                     <uix:styledText textBinding="step_name"/>                      
                     <uix:styledText textBinding="chain_owner"/> 
                     <uix:styledText textBinding="chain_name"/>                                             
                     <uix:styledText textBinding="error_code"/>
                     <uix:styledText textBinding="start_date"/>
                     <uix:styledText textBinding="duration"/>                     
                     <uix:styledText textBinding="skip"/>
                     <uix:styledText textBinding="pause"/>
                     <uix:styledText textBinding="log_id" destinationBinding="histDest"/>
                   </uix:contents>
                   <uix:tableSelection> 
                   <uix:singleSelection selectedIndex="0" shortDescBinding="STEP_STATUS@bundle@servletRequest">
                      <uix:submitButton textBinding="STOP@bundle@servletRequest" name="event" value="stopStep" />
                      <uix:submitButton textBinding="SKIP@bundle@servletRequest" name="event" value="skip" />
                      <uix:submitButton textBinding="PAUSE@bundle@servletRequest" name="event" value="pause" />
                      <uix:submitButton textBinding="RESTART@bundle@servletRequest" name="event" value="restart" />
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
      </uix:rowLayout>
    </uix:tableLayout> 
  </uix:header>
  
    <uix:hideShowHeader textBinding="TOPOLOGY@bundle@servletRequest"
                    renderedBinding="isShowChain@objectBean@servletRequest"
                    disclosedBinding="showTopo@objectBean@servletRequest"                     
                    formSubmitted="true" id="viewRun" >                    
      <jsp:include page="/database/instance/scheduler/chainTopo.jsp" />
      <uix:ref refID="chainTopo" />
    </uix:hideShowHeader>

 
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




