<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="runningForm" destination="jobs" copyParams="target,type"> 
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
<%--      
      <uix:pageLayout titleBinding="JOBS@bundle@servletRequest"> 
  --%>      
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>

        <uix:header textBinding="JOBS@bundle@servletRequest">

        <%@ include file="../refreshTime.jspf" %>
        <uix:spacer height="1"/>
        <uix:rowLayout width="100%" >
           <uix:cellFormat hAlign="right" vAlign="top" width="100%">
              <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
           </uix:cellFormat>
        </uix:rowLayout>          
        <%--
        ---- Subtabs
        --%>        
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="1">
              <uix:link textBinding="ALL@bundle@servletRequest"    
                          destinationBinding="tab1@servletRequest"/>                      
              <uix:link textBinding="RUNNING@bundle@servletRequest"
                           destinationBinding="tab2@servletRequest"/>
              <uix:link textBinding="HISTORY@bundle@servletRequest"
                           destinationBinding="tab4@servletRequest"/>
                           
            </uix:subTabBar>
          </uix:subTabs>
          
       
        <uix:tableLayout cellSpacing="5" width="100%" >
       
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="running"
                           tableDataBinding="runningList@defaultBean@servletRequest"
                           columnHeaderDataBinding="runningColHeader@defaultBean@servletRequest"
                           columnFormatsBinding="runningColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_RUNNING_JOBS_FOUND@bundle@servletRequest"
                           blockSizeBinding="runningBlockSize@defaultBean@servletRequest"
                           valueBinding="runningValue@defaultBean@servletRequest" 
                           minValueBinding="runningMinValue@defaultBean@servletRequest" 
                           maxValueBinding="runningMaxValue@defaultBean@servletRequest"
                           formSubmitted="true"
                           summaryBinding="RUNNING@bundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:image source="/em/images/database/schr/running.gif" destinationBinding="runDest" shortDescBinding="state" />
                     <uix:link textBinding="name" destinationBinding="jobDest" />
                     <uix:link textBinding="owner" destinationBinding="ownerDest" />                     
                     <uix:styledText textBinding="start_date"/>  
                     <uix:styledText textBinding="elapsed_time"/>  
                     <uix:styledText textBinding="cpu_time"/>    
                     <uix:link textBinding="session_id" destinationBinding="sessionDest" />
                     <uix:styledText textBinding="rsc_grp"/>                      
                     <uix:styledText textBinding="run_count"/>                                           
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="state">
                      <uix:submitButton textBinding="VIEW_JOB_STATUS@bundle@servletRequest" name="event" value="viewRun" /> 
                      <uix:submitButton textBinding="STOP_RUN@bundle@servletRequest" name="event" value="stop" />   
                      <uix:submitButton textBinding="VIEW_DEFINITION@bundle@servletRequest" name="event" value="view" />                      
                      <uix:submitButton textBinding="EDIT_DEFINITION@bundle@servletRequest" name="event" value="edit" /> 
                      <uix:submitButton textBinding="DELETE@bundle@servletRequest" name="event" value="delete" />
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
        <uix:spacer height="10"/>
 
        </uix:subTabLayout>    
        
          <oem:relatedLinks />
        </uix:header>    
<%-- 
        <uix:pageButtons> 
         <uix:pageButtonBar>         
            <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
         </uix:pageButtonBar>  
       </uix:pageButtons>
 --%>       
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

