<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

 <uix:styleSheet/>
  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/> 
  <script>
    function lovSelectReload(pwin, lovSchema, lovField)
    {
      var proxy = new TableProxy("schedTable");
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement1 = proxy.getFormElement('downer', selectedIndex);
        var selectedElement2 = proxy.getFormElement('dname', selectedIndex);
        lovSchema.value =  selectedElement1.value ;
        lovField.value =  selectedElement2.value;
        pwin.submitForm('scheduleForm',1,{'event':'show_sched'});
      }
      window.close();
    }
  </script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

    <uix:bundle name="uixDBObjectBundle"
                class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="bundle"
                class="oracle.sysman.db.rsc.inst.JobsMsg"/>  
                
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                

<%-- HTML Form --%>
<db:form name="schedForm"  method="post" destination="job" copyParams="target,type">
  <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
  <uix:formValue name="state" valueBinding="state@servletRequest"/> 
  <uix:formValue name="oname" valueBinding="oname@servletRequest" />
  <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
<uix:pageLayout titleBinding="SEARCH_SEL_SCHED@bundle">

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


  <%-- START: TAB CONTENTS starts here --%>
   <uix:tableLayout cellSpacing="4">
            <uix:rowLayout hAlign="right">
              <%--
              <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              --%>
              
              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <%--
              <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <--%>
              <uix:cellFormat>
              
              <uix:header textBinding="SEARCH@uixDBObjectBundle"/>
           
                <uix:tableLayout cellSpacing="4">
                    <uix:contents>


                    <uix:rowLayout hAlign='left'>
                       <uix:contents>
                        <uix:cellFormat width = "13">
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle" labeledNodeId="schedOwner"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                         <uix:textInput id="schedOwner" name="schedOwner" textBinding="schedOwner@scheduleTypeBean@servletRequest"/>
                        </uix:cellFormat>
                       </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign='left'>
                       <uix:contents>
                       <uix:cellFormat width = "13">
                       </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="OBJECT_NAME_COLON@uixDBObjectBundle"  labeledNodeId="schedName"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                         <uix:textInput  id="schedName" name="schedName" textBinding="schedName@scheduleTypeBean@servletRequest"/>
                        </uix:cellFormat> 
                        <uix:submitButton textBinding="GO@uixDBObjectBundle"
                            name="event" value="changeSched"/>
                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>

              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:header textBinding="RESULTS@uixDBObjectBundle">
                    <uix:table  width="100%"
                           name="schedTable"
                           tableDataBinding="schedList@scheduleTypeBean@servletRequest"
                           columnFormatsBinding="schedColFormats@scheduleTypeBean@pageContext"
                           columnHeaderDataBinding="schedColHeader@scheduleTypeBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@bundle"                           
                           valueBinding="schedVal@scheduleTypeBean@servletRequest" 
                           blockSizeBinding="schedBlockSize@scheduleTypeBean@servletRequest"                         
                           minValueBinding="schedMinValue@scheduleTypeBean@servletRequest" 
                           maxValueBinding="schedMaxValue@scheduleTypeBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="RESULTS@uixDBObjectBundle"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/>                      
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                              
                     <uix:styledText textBinding="owner"/> 
                     <uix:styledText textBinding="name"/>      
                     <uix:formValue name="downer" valueBinding="downer"/>
                     <uix:formValue name="dname" valueBinding="dname"/>                                     
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="SEARCH_SEL_SCHED@bundle"/>
                   </uix:tableSelection>
                 </uix:table>  
                    
                  </uix:header>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   


  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:button textBinding="CANCEL@uixDBObjectBundle"
                destination="javascript:self.close()"/>
    <uix:button textBinding="SELECT@uixDBObjectBundle" 
                 destinationBinding="schedDest@servletRequest"/> 
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>

</uix:body> 
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




