<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      { 
          
      }
     </script>
    </uix:metaContainer>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>         
       
<%-- HTML Form --%>
<db:form name="generalForm" destination="schedule" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="state" valueBinding="state@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

<%--
  <uix:subTabLayout>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
        <uix:link textBinding="GENERAL@bundle@servletRequest"
                   onClick="submitForm('generalForm', true, {event:'goto1'})"/>
        <uix:link textBinding="SCHEDULE@bundle@servletRequest"
                   onClick="submitForm('generalForm', true, {event:'goto2'})"/>
     </uix:subTabBar>
    </uix:subTabs>
 --%>
 
    <%-- START: TAB CONTENTS starts here --%>
    
        <uix:rowLayout>
          <uix:contents>     
            <uix:stackLayout>                      
            
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="NAME@bundle@servletRequest" required="yes"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                       
                    <uix:stackLayout>
                    <uix:contents>
                     
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:textInput name="scheduleName" textBinding="scheduleName@objectBean@servletRequest" />
                        </uix:case>   
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="scheduleName@objectBean@servletRequest"/>
                        </uix:case>         
                      </uix:switcher>                  
                      <uix:messageText messageBinding="scheduleName@errors@servletRequest" messageType="error"/>
                    </uix:contents>
                  </uix:stackLayout>               				 
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest" required="yes"/>          
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/> 
                        </uix:case>
                      </uix:switcher>
                     </uix:cellFormat> 
                     
                     <%-- SWITCHER: schema --%>
                       <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                         <uix:case name="true"> 
                          <uix:stackLayout>               
                           <uix:messageLovField 
                              name="schemaName" textBinding="schemaName@objectBean@servletRequest"
                              shortDescBinding="SEL_OWNER_DESC@bundle@servletRequest" 
                              onClickBinding="schemaURL@servletRequest" />                              
                            <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/> 
                        </uix:stackLayout>
                         </uix:case>   
                         <uix:case name="false">
                           <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>   
                         </uix:case>         
                       </uix:switcher>
                    <%-- SWITCHER: schema --%>  
                                         
                  </uix:contents>
                </uix:rowLayout>   
                
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="COMMENT@bundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				 <uix:textInput name="comments" textBinding="comments@objectBean@servletRequest" columns="65"/>
                   </uix:contents>
                </uix:rowLayout>
                
                </uix:contents>
              </uix:tableLayout>
              
                                                         
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 

       <uix:header textBinding="SCHEDULE@bundle@servletRequest" 
                    renderedBinding="isCalendar@scheduleBean@servletRequest">  
            <uix:tableLayout cellSpacing="5">
                    <uix:styledText styleClass="OraDataText" textBinding="CALENDAR_NOT_SUPPORTED@bundle@servletRequest" />
            </uix:tableLayout>
       </uix:header>

       <uix:header textBinding="SCHEDULE@bundle@servletRequest"
                    renderedBinding="isNotCalendar@scheduleBean@servletRequest">  
            <%@ include file="schedule/timezone.jspf" %>

            <uix:tableLayout cellSpacing="5" renderedBinding="isVersionEqualOrHigher10gR2@scheduleBean@servletRequest" >
              <uix:rowLayout>
	
              <uix:styledText textBinding="SCHEDULE_TYPE@bundle@servletRequest" 
                              labeledNodeId="SCHEDULE_TYPE" styleClass="OraPromptText"/>

              <uix:choice id="eventScheduleTypeSB" name="eventScheduleTypeSB" 
                              onChange="submitForm('generalForm', true,{event:'go'})" 
                              selectedValueBinding="eventScheduleTypeSB@scheduleBean@servletRequest"> 
                  <uix:contents childDataBinding="scheduleTypeChoicesSB@scheduleBean@servletRequest">
                    <uix:option textBinding="stext"
                                 valueBinding="sval"/>
                  </uix:contents>
              </uix:choice>                          
      
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:switcher childNameBinding="eventScheduleTypeSB@scheduleBean@servletRequest">
                <uix:case name="useEvent"> 
                    <jsp:include page="/database/instance/scheduler/schedule/scheduleEvent.jsp" /> 
                    <uix:ref refID="scheduleEvent" />
                </uix:case>
                <uix:case name="ical"> 
                    <jsp:include page="/database/instance/scheduler/schedule/scheduleCal.jsp" /> 
                    <uix:ref refID="scheduleCal" />
                </uix:case>
                <uix:default>
                    <%@ include file="/database/instance/scheduler/schedule/schedule.jspf" %>  
                </uix:default>
            </uix:switcher>
       </uix:header>
    <%-- END: TAB CONTENTS ends here --%>   
        
 <%-- </uix:subTabLayout>  --%>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 