<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<uix:bundle name="ScheduleBundle"                   
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="DBScheduleBundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>
          
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      {          
      }
     </script>
    </uix:metaContainer>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>        
<db:form name="scheduleForm" method="post" destination="job" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
 <uix:formValue name="state" valueBinding="state@servletRequest"/> 
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 <uix:formValue name="jnum" valueBinding="jobNum@objectBean@servletRequest" />  
<uix:pageLayout titleBinding="header@objectBean@servletRequest">
  <%@ include file="/database/global.jspf" %>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <uix:subTabLayout>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="1">
        <uix:link textBinding="GENERAL@bundle@servletRequest"
                   onClick="submitForm('scheduleForm', true, {event:'goto1'})"/>
        <uix:link textBinding="SCHEDULE@bundle@servletRequest"
                   onClick="submitForm('scheduleForm', true, {event:'goto2'})"/>
        <uix:link textBinding="OPTIONS@bundle@servletRequest"
                   onClick="submitForm('scheduleForm', true, {event:'goto3'})"/>
     </uix:subTabBar>
    </uix:subTabs>
    <jsp:include page="scheduleType.jsp" />   
    <uix:ref refID="scheduleType" />  
  </uix:subTabLayout>  

  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>




