<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
 <uix:styleSheet/>
  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/> 
  <script>
    function lovSelect(lovField)
    {
      var proxy = new TableProxy("agentTable");
      var selectedIndex = proxy.getSelectedRow();    
      
      if (selectedIndex >= 0)
      {
        var selectedElement1 = proxy.getFormElement('displayName', selectedIndex);
        lovField.value =  selectedElement1.value;  
      }
      window.close();
    }
  </script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="DBScheduleBundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>            
<uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.DBObjectMsg"/> 

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                

<%-- HTML Form --%>
<db:form name="agentForm"  destinationBinding="agentDest@servletRequest" copyParams="target,type,sname,oname,state">
 
<uix:pageLayout titleBinding="SEARCH_SEL_AGENT@DBScheduleBundle">

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


  <%-- START: TAB CONTENTS starts here --%>
   <uix:tableLayout cellSpacing="4" width="100%">
            <uix:rowLayout hAlign="right">

              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <uix:cellFormat>
              
              <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest"/>
                <uix:tableLayout cellSpacing="4">   
                    <uix:rowLayout hAlign='left'>
                    <uix:cellFormat> 
                     <uix:spacer width="20"/>
                    </uix:cellFormat> 
                          <uix:messageTextInput id="consumerSearchVal"
                                         name="consumerSearchVal" 
                                     promptBinding="SEARCH_AGENT@DBScheduleBundle"
                                     shortDescBinding="SEARCH_AGENT@DBScheduleBundle"
                                     textBinding="consumerSearchVal@scheduleBean@servletRequest"/>
                       <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest"
                            name="event" value="changeAgentSearch"/>
                    </uix:rowLayout>
                </uix:tableLayout>

              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:header textBinding="RESULTS@uixDBObjectBundle@servletRequest">
                    <uix:table  width="100%"
                           name="agentTable"
                           tableDataBinding="agentList@scheduleBean@servletRequest"
                           columnFormatsBinding="agentColFormats@scheduleBean@pageContext"
                           columnHeaderDataBinding="agentColHeader@scheduleBean@servletRequest" 
                           alternateTextBinding = "NO_AGENT_FOUND@DBScheduleBundle"                           
                           valueBinding="agentVal@scheduleBean@servletRequest" 
                           blockSizeBinding="agentBlockSize@scheduleBean@servletRequest"                         
                           minValueBinding="agentMinValue@scheduleBean@servletRequest" 
                           maxValueBinding="agentMaxValue@scheduleBean@servletRequest"
                           formSubmitted="true"
                           summaryBinding="RESULTS@uixDBObjectBundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/>                      
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                              
                     <uix:styledText textBinding="name"/> 
                      <uix:formValue name="displayName" valueBinding="displayName"/> 
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="SEARCH_SEL_AGENT@DBScheduleBundle"/>
                   </uix:tableSelection>
                 </uix:table>  
                    
                  </uix:header>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   


  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                destination="javascript:self.close()"/>
    <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" 
                 destinationBinding="selectAgentDest@servletRequest"/> 
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>

</uix:body> 
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




