<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="DBScheduleBundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>            
<uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_TIME_ZONE@DBScheduleBundle"/>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
       function lovSelectReload(pwin, lovField, fname)
       {
        var proxy = null;
        if (this.document.tzForm.timeZoneType[0].checked)
          proxy = new TableProxy("tzTab");
        else 
          proxy = new TableProxy("tzoTab");
        var selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {                   
          var selectedElement1 = proxy.getFormElement('name', selectedIndex);
          lovField.value =  selectedElement1.value;        
          pwin.submitForm(fname,1,{'event':'doSubmit'});
        }        
        window.close();
      }
      </script>
    </uix:metaContainer>
    <uix:body>

   <db:form name="tzForm" 
            destinationBinding="tzFormDest@servletRequest"
            copyParams="target,type,sname,oname,state">
      <uix:formValue name="event" value="changeTZSearch" /> 
      <uix:pageLayout titleBinding="SELECT_TIME_ZONE@DBScheduleBundle">

         <uix:radioButton 
            name="timeZoneType" 
            value="region"
            selectedValueBinding="timeZoneType@scheduleBean@servletRequest"
            textBinding="SEL_TIME_ZONE_REG@DBScheduleBundle"
            styleClass="OraInstructionText" />

          <uix:tableLayout cellSpacing="2"   width="100%">      
          <uix:rowLayout>
              <uix:cellFormat> 
                <uix:spacer width="20"/>
              </uix:cellFormat> 
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH@DBMsgBundle">
	                <uix:rowLayout>
	                  <uix:messageTextInput id="tzSearchVal"
                                         name="tzSearchVal" 
                                     promptBinding="SEARCH_TIME_ZONE@DBScheduleBundle"
                                     shortDescBinding="SEARCH_TIME_ZONE@DBScheduleBundle"
                                     textBinding="tzSearchVal@scheduleBean@servletRequest"/>
	                  <uix:submitButton textBinding="GO@DBMsgBundle" name="event" 
                                            value="changeTZSearch"/>
	                </uix:rowLayout>
	                
                    <uix:spacer height="5"/>
	                <uix:rowLayout>
			            <uix:cellFormat> 
			               <uix:styledText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@DBScheduleBundle"/>
			            </uix:cellFormat> 
			        </uix:rowLayout>
	        
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        <uix:rowLayout>
            <uix:cellFormat> 
               <uix:spacer width="20"/>
            </uix:cellFormat> 
            <uix:stackLayout>
              <uix:header textBinding="RESULT@DBMsgBundle">
                <uix:table  width="100%"
                           name="tzTab"
                           tableDataBinding="timeZonesList@scheduleBean@servletRequest"
                           columnFormatsBinding="timeZoneColFormats@scheduleBean@servletRequest"
                           columnHeaderDataBinding="timeZoneColHeader@scheduleBean@servletRequest" 
                           alternateTextBinding = "NO_ITEMS_FOUND@DBMsgBundle"                           
                           valueBinding="timeZoneVal@scheduleBean@servletRequest" 
                           blockSizeBinding="timeZoneBlockSize@scheduleBean@servletRequest"                         
                           minValueBinding="timeZoneMinValue@scheduleBean@servletRequest" 
                           maxValueBinding="timeZoneMaxValue@scheduleBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="RESULTS@DBMsgBundle" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/>                      
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                              
                     <uix:styledText textBinding="name"/>      
                     <uix:formValue name="name" valueBinding="name"/>                                     
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" 
                        shortDescBinding="SELECT_A_VALUE@DBMsgBundle"/>
                   </uix:tableSelection>
                 </uix:table>                      
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

       <uix:spacer height="20"/>
       <uix:radioButton 
            name="timeZoneType" 
            value="offset"
            selectedValueBinding="timeZoneType@scheduleBean@servletRequest"
            textBinding="SEL_TIME_ZONE_OFF@DBScheduleBundle"
            styleClass="OraInstructionText" />

          <uix:tableLayout cellSpacing="2"   width="100%">             
	        <uix:rowLayout>
              <uix:cellFormat> 
                     <uix:spacer width="20"/>
              </uix:cellFormat> 
                <uix:table  width="100%"
                           name="tzoTab"
                           tableDataBinding="timeZoneOffsetList@scheduleBean@servletRequest"
                           columnFormatsBinding="timeZoneOffsetColFormats@scheduleBean@servletRequest"
                           columnHeaderDataBinding="timeZoneOffsetColHeader@scheduleBean@servletRequest" 
                           alternateTextBinding = "NO_ITEMS_FOUND@DBMsgBundle"                           
                           valueBinding="timeZoneOffsetVal@scheduleBean@servletRequest" 
                           blockSizeBinding="timeZoneOffsetBlockSize@scheduleBean@servletRequest"                         
                           minValueBinding="timeZoneOffsetMinValue@scheduleBean@servletRequest" 
                           maxValueBinding="timeZoneOffsetMaxValue@scheduleBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="RESULTS@DBMsgBundle" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/>                      
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                              
                     <uix:styledText textBinding="name"/>      
                     <uix:formValue name="name" valueBinding="name"/>                                     
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" 
                        shortDescBinding="SELECT_A_VALUE@DBMsgBundle"/>
                   </uix:tableSelection>
                 </uix:table>                      
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@DBMsgBundle" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@DBMsgBundle" destinationBinding="selectTimeZoneDest@servletRequest"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

