<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="scheduleType">
  <uix:dataScope>     
    <uix:bundle name="ScheduleBundle"                   
                class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="DBScheduleBundle"
                class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>
    <uix:bundle name="bundle"
                class="oracle.sysman.db.rsc.inst.JobsMsg"/>        
    <uix:stackLayout>
      <uix:spacer height ="10"/> 
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="SCHE_TYPE@bundle" labeledNodeId="uiScheduleType"/> 
          </uix:cellFormat>     
          <uix:spacer width="10"/> 
       	  <uix:choice id="uiScheduleType" name="uiScheduleType"
                       selectedValueBinding="uiScheduleType@scheduleTypeBean@servletRequest" 
                       onChange="submitForm('scheduleForm', true, {event:'go'})" >                               
              <uix:contents childDataBinding="scheduleTypeList@scheduleTypeBean@servletRequest">
               <uix:option textBinding="jtext" valueBinding="jval"/>
              </uix:contents>
          </uix:choice>  
        </uix:rowLayout>     
        <uix:spacer height ="5"/> 
                   
                <uix:switcher childNameBinding="uiScheduleType@scheduleTypeBean@servletRequest">
        
                  <uix:case name="1">
                  <uix:header text="" >
                    <%@ include file="schedule/timezone.jspf" %>
                    <%@ include file="schedule/schedule.jspf" %> 
                  </uix:header>  
                  </uix:case>                 
                  <uix:case name="6">
                  <uix:header text="" >
                    <%@ include file="schedule/timezone.jspf" %>
                    <jsp:include page="/database/instance/scheduler/schedule/scheduleEvent.jsp" /> 
   		    <uix:ref refID="scheduleEvent" />                    
                  </uix:header>  
                  </uix:case>
                  <uix:case name="7">
                  <uix:header text="" >
                    <%@ include file="schedule/timezone.jspf" %>
                    <jsp:include page="/database/instance/scheduler/schedule/scheduleCal.jsp" /> 
   		    <uix:ref refID="scheduleCal" />                    
                  </uix:header>  
                  </uix:case>                  
                  <uix:case name="2">
                  <uix:stackLayout>
                  <uix:header text="" >
<%@ include file="schedule/timezone.jspf" %>
                  <uix:rowLayout>          

<uix:header textBinding="AVAIL_START@DBScheduleBundle"> 
<uix:tableLayout cellSpacing="5">
<uix:rowLayout>
<%-- IMMEDIATELY RADIO BUTTON --%>
<uix:radioButton 
     name="scheduleTypeSB" 
     value="now"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="IMMEDIATELY@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:rowLayout>

<uix:rowLayout>
<%-- LATER RADIO BUTTON --%>
<uix:radioButton 
     name="scheduleTypeSB" 
     value="later"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="LATER@ScheduleBundle"
     styleClass="OraInstructionText"
/>	
</uix:rowLayout>

<uix:rowLayout>
<%-- START DATE --%>
<uix:cellFormat  hAlign="right">
<uix:messagePrompt 
     promptBinding="DATE@ScheduleBundle" labeledNodeId="startDateSB"
/>
</uix:cellFormat>  
<uix:messageDateField id="startDateSB" 
     name="startDateSB"
     valueBinding="startDateSB@scheduleBean@pageContext"
     tipBinding="dateTip@scheduleBean@servletRequest"
     columns="24">
<uix:onSubmitValidater>
<uix:date dateStyle="medium" />
</uix:onSubmitValidater>
</uix:messageDateField>
</uix:rowLayout>

<uix:rowLayout hAlign="right" renderedBinding="showStartTime@scheduleBean@servletRequest">
<%-- START HOUR --%>
<uix:messagePrompt 
     promptBinding="TIME@ScheduleBundle" labeledNodeId="startTime"
/>
<uix:flowLayout>
<oem:choice
     id="startTime"
     name="startHourSB"
     optionsBinding="hoursSB@scheduleBean@servletRequest" 
     selectedValueBinding="startHourSB@scheduleBean@servletRequest"    
/>

<%-- START MINUTE --%>
<oem:choice 
     name="startMinuteSB" 
     optionsBinding="minutesSB@scheduleBean@servletRequest" 
     selectedValueBinding="startMinuteSB@scheduleBean@servletRequest"
     shortDescBinding="TIME@ScheduleBundle"
/>

<%-- START SECOND --%>
<oem:choice 
     name="startSecondSB" 
     renderedBinding="showSeconds@scheduleBean@servletRequest" 
     optionsBinding="secondsSB@scheduleBean@servletRequest" 
     selectedValueBinding="startSecondSB@scheduleBean@servletRequest"
     shortDescBinding="TIME@ScheduleBundle"     
/>

<%-- START AM/PM --%>
<oem:radioButton
     name="startAmPmSB" 
     value="AM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="AM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText" 
/>
<oem:radioButton 
     name="startAmPmSB" 
     value="PM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="PM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText" 
/>
</uix:flowLayout>
</uix:rowLayout>

</uix:tableLayout>
</uix:header>

                  </uix:rowLayout>  
                  <uix:spacer height ="5"/>  
                  
                  <uix:header textBinding="REPEAT_INTERVAL@bundle" >
                    <uix:rowLayout>
                      <uix:messagePrompt promptBinding="PLSQL_DESC@bundle"  labeledNodeId="repeatInterval"/>
                    </uix:rowLayout> 
                     <uix:rowLayout>
                      <uix:textInput  id="repeatInterval" name="repeatInterval" textBinding="repeatInterval@scheduleTypeBean@servletRequest" columns="80" rows="5" />
                  </uix:rowLayout> 
                  </uix:header>  
                               
                  <uix:spacer height ="5"/>      
                  <uix:rowLayout>
                  
<uix:header rendered="true" textBinding="NOT_AVAIL_AFTER@DBScheduleBundle">     

<uix:tableLayout cellSpacing="5">
<uix:rowLayout>
<oem:radioButton 
     name="repeatUntilTypeSB" 
     value="indefinite"
     selectedValueBinding="repeatUntilTypeSB@scheduleBean@servletRequest"
     textBinding="NO_END_DATE@ScheduleBundle"
     styleClass="OraInstructionText"
/>	
</uix:rowLayout>
<uix:rowLayout>
<oem:radioButton 
     name="repeatUntilTypeSB" 
     value="custom"
     selectedValueBinding="repeatUntilTypeSB@scheduleBean@servletRequest"
     textBinding="SPECIFIED_END_DATE@ScheduleBundle"
     styleClass="OraInstructionText"
/>	
</uix:rowLayout>
<uix:rowLayout>
<%-- END DATE --%>
<uix:cellFormat hAlign="right"> 
<uix:messagePrompt 
     promptBinding="DATE@ScheduleBundle" labeledNodeId="endDateSB"
/>
</uix:cellFormat>
<uix:messageDateField id="endDateSB" 
     name="endDateSB"
     valueBinding="endDateSB@scheduleBean@servletRequest"
     tipBinding="dateTip@scheduleBean@servletRequest"
     columns="24">
<uix:onSubmitValidater>
<uix:date dateStyle="medium" />
</uix:onSubmitValidater>
</uix:messageDateField>
</uix:rowLayout>

<uix:rowLayout>
<%-- END HOUR --%>
<uix:cellFormat hAlign="right">
<uix:messagePrompt 
     promptBinding="TIME@ScheduleBundle" labeledNodeId="endTime"
/>
</uix:cellFormat>
<uix:stackLayout>
<uix:rowLayout>
<uix:flowLayout>
<oem:choice
     id="endTime"
     name="endHourSB"
     optionsBinding="hoursSB@scheduleBean@servletRequest" 
     selectedValueBinding="endHourSB@scheduleBean@servletRequest"
/>

<%-- END MINUTE --%>
<oem:choice 
     name="endMinuteSB" 
     optionsBinding="minutesSB@scheduleBean@servletRequest" 
     selectedValueBinding="endMinuteSB@scheduleBean@servletRequest"
     shortDescBinding="TIME@ScheduleBundle"
/>

<%-- END SECOND --%>
<oem:choice 
     name="endSecondSB" 
     renderedBinding="showSeconds@scheduleBean@servletRequest" 
     optionsBinding="secondsSB@scheduleBean@servletRequest" 
     selectedValueBinding="endSecondSB@scheduleBean@servletRequest"
     shortDescBinding="TIME@ScheduleBundle"     
/>

<%-- END AM/PM --%>
<oem:radioButton
     name="endAmPmSB" 
     value="AM_VALUE"
     selectedValueBinding="endAmPmSB@scheduleBean@servletRequest"
     textBinding="AM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText" 
/>
<oem:radioButton 
     name="endAmPmSB" 
     value="PM_VALUE"
     selectedValueBinding="endAmPmSB@scheduleBean@servletRequest"
     textBinding="PM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText" 
/>
</uix:flowLayout>
</uix:rowLayout>
</uix:stackLayout>
</uix:rowLayout>

</uix:tableLayout>
</uix:header>        
                  </uix:rowLayout> 
                  </uix:header>
                  </uix:stackLayout>    
                  </uix:case>
                <uix:case name="3">
                 <uix:header text="" >                 
                    <uix:rowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="SCHEDULE_DESC@bundle" />
                      </uix:rowLayout>                                   
                  <uix:spacer height="10"/> 
                   <uix:tableLayout> 
                   <uix:rowLayout>
                      <uix:messagePrompt promptBinding="SCHEDULE@bundle" labeledNodeId="scheduleName"/>    
                     <uix:spacer width="10"/> 
                      <uix:textInput name="scheduleSchema"  textBinding="scheduleSchema@scheduleTypeBean@servletRequest" columns="15" />
                     <uix:styledText text="."/> 
                       <uix:messageLovField id="scheduleName" 
                              name="scheduleName" textBinding="scheduleName@scheduleTypeBean@servletRequest"
                              searchDescBinding="SEL_SCHEDULE_DESC@bundle"
                              onClickBinding="scheduleURL@servletRequest" />
                       <uix:spacer width="10"/>       
                      <uix:submitButton textBinding="SHOW_DETAILS@bundle" name="event" value="show_sched" />                                                                  
                      <uix:spacer width="20"/> 
                      <uix:submitButton textBinding="CREATE_SCHEDULE@bundle" renderedBinding="showCreateSched@scheduleTypeBean@servletRequest" name="event" value="create_sched" />  
                  </uix:rowLayout>                                                              
                </uix:tableLayout>                  
                  <uix:header renderedBinding="showSchedule@scheduleTypeBean@servletRequest">                               
                  <jsp:include page="schedViewInclude.jsp" />   
                     <uix:ref refID="schedViewInclude" />   
                  </uix:header>   
                     </uix:header>    
                  </uix:case>                   
                  <%-- WINDOW --%>
                  <uix:case name="4">
                  <uix:header text="" >                  
                   <uix:tableLayout width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left" width="70%">
                        <uix:styledText styleClass="OraInstructionText" textBinding="WINDOW_DESC@bundle" />
                      </uix:cellFormat>
                    </uix:rowLayout>                                   
                  </uix:tableLayout>
                  <uix:spacer height="10"/> 
                   <uix:tableLayout> 
                   <uix:rowLayout>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="WINDOW@bundle" labeledNodeId="windowName"/> 
                     </uix:cellFormat>     
                     <uix:spacer width="10"/> 
                     
                      <uix:textInput name="windowSchema"  text="SYS" columns="15" readOnly="true" />
                     <uix:styledText text="."/>  
                      <uix:messageLovField id="windowName" 
                              name="windowName" textBinding="windowName@scheduleTypeBean@servletRequest"
                              searchDescBinding="SEL_WIN_DESC@bundle"
                              onClickBinding="windowURL@servletRequest" />                                           
                      <uix:spacer width="10"/>                          
                      <uix:submitButton textBinding="SHOW_DETAILS@bundle" name="event" value="show_win" />             
                      <uix:spacer width="20"/> 
                      <uix:submitButton textBinding="CREATE_WINDOW@bundle" renderedBinding="showCreateWin@scheduleTypeBean@servletRequest" name="event" value="create_win" />  
                   </uix:rowLayout>                                                             
                </uix:tableLayout> 
                <uix:spacer height="10"/>    
                  <uix:stackLayout>
                     <uix:checkBox name="stopWinExit" textBinding="STOP_WIN_EXIT@bundle" checkedBinding="stopWinExit@scheduleTypeBean@servletRequest"  />
                     <uix:formValue name="stopWinExit1" value="dummy" />
                     <uix:styledText styleClass="OraInlineInfoText" textBinding="STOP_WIN_EXIT_DESC@bundle" />
                  </uix:stackLayout>   
                  <uix:header renderedBinding="showWin@scheduleTypeBean@servletRequest">  
                    <uix:switcher childNameBinding="windowGroup@scheduleTypeBean@servletRequest">                 
                      <uix:case name="true">
                        <jsp:include page="windowGroupViewData.jsp" />   
                        <uix:ref refID="windowGroupViewData" />          
                      </uix:case>        
                      <uix:default>
                        <jsp:include page="windowViewData.jsp" />   
                        <uix:ref refID="windowViewData" />                              
                      </uix:default>                  
                    </uix:switcher>
                  </uix:header> 
                  
                  </uix:header> 
                  
                  </uix:case>                  
                 </uix:switcher>
                 </uix:stackLayout>
  </uix:dataScope>     
</uix:buildTree>
