<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="scheduledForm" destination="jobs" copyParams="target,type"> 
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 

<%--      
      <uix:pageLayout titleBinding="JOBS@bundle@servletRequest"> 
 --%>      
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %> 
       <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
        <uix:header textBinding="JOBS@bundle@servletRequest">

        <%@ include file="../refreshTime.jspf" %>
        <%--
        ---- Subtabs
        --%>
        <uix:spacer height="1"/>
           <uix:rowLayout width="100%" >
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                    <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
              </uix:cellFormat>
          </uix:rowLayout>  
          
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="ALL@bundle@servletRequest"
                           destinationBinding="tab1@servletRequest" />                         
              <uix:link textBinding="RUNNING@bundle@servletRequest"
                           destinationBinding="tab2@servletRequest"/>
              <uix:link textBinding="HISTORY@bundle@servletRequest"
                           destinationBinding="tab4@servletRequest"/>
                           
            </uix:subTabBar>
          </uix:subTabs>
          
        
        <uix:tableLayout cellSpacing="5" width="100%" >
        
           
          
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="scheduled"
                           tableDataBinding="scheduleList@defaultBean@servletRequest"
                           columnFormatsBinding="scheduleColFormats@defaultBean@pageContext"
                           columnHeaderDataBinding="scheduleColHeader@defaultBean@servletRequest" 
                           alternateTextBinding = "NO_SCHED_JOBS_FOUND@bundle@servletRequest"
                           blockSizeBinding="scheduleBlockSize@defaultBean@servletRequest"
                           valueBinding="scheduleValue@defaultBean@servletRequest" 
                           minValueBinding="scheduleMinValue@defaultBean@servletRequest" 
                           maxValueBinding="scheduleMaxValue@defaultBean@servletRequest"
                           formSubmitted="true"
                           summaryBinding="SCHEDULED@bundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                               
                     <uix:link textBinding="name" destinationBinding="jobDest" />                        
                     <uix:link textBinding="owner" destinationBinding="ownerDest" />
                     <uix:switcher childNameBinding="window_link">                 
                      <uix:case name="">             
                         <uix:styledText textBinding="next_run_date" />                      
                      </uix:case>
                      <uix:default>
                         <uix:styledText textBinding="next_run_date" destinationBinding="window_link"/>                      
                      </uix:default>
                     </uix:switcher>                      
                     <uix:styledText textBinding="last_run_date"/>                        
                     <uix:styledText textBinding="completion_status"/> 
                     <uix:image sourceBinding="enabledDest" shortDescBinding="enabled" />
                     <uix:styledText textBinding="class_name" destinationBinding="classDest" />     
                     <uix:styledText textBinding="run_count"/>                                           
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="SCHEDULED@bundle@servletRequest">
                      <uix:submitButton textBinding="VIEW_DEFINITION@bundle@servletRequest" name="event" value="view" />
                      <uix:submitButton textBinding="EDIT_DEFINITION@bundle@servletRequest" name="event" value="edit" />                       
                      <uix:submitButton textBinding="DELETE@bundle@servletRequest" name="event" value="delete" /> 
                      <uix:submitButton textBinding="RUN_NOW@bundle@servletRequest" name="event" value="run_now" /> 
                      <uix:submitButton textBinding="CREATE_LIKE@bundle@servletRequest" name="event" value="create_like" /> 
<%--                      
                       <uix:rowLayout>
                         <uix:contents>
                           <uix:spacer width="2"/>
                             <uix:styledText styleClass="OraPromptText" textBinding="ACTIONS@bundle@servletRequest"/>
                             <uix:spacer width="2"/>
                             <uix:choice name="scheduledChoice"
                                    selectedValueBinding="scheduleAction@defaultBean@servletRequest" >
                               <uix:contents childDataBinding="scheduleChoiceList@defaultBean@servletRequest">
                                 <uix:option textBinding="jtext"  valueBinding="jval"/>
                               </uix:contents>
                            </uix:choice>  
                         </uix:contents>
                        </uix:rowLayout>                                                                
                      <uix:submitButton textBinding="GO@bundle@servletRequest" name="event" value="go" />                     
--%>                      
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
        <uix:spacer height="10"/>

        </uix:subTabLayout>    
        
          <oem:relatedLinks />
          
        </uix:header>  

<%--
        <uix:pageButtons> 
         <uix:pageButtonBar>         
            <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
         </uix:pageButtonBar>  
       </uix:pageButtons>
--%>

      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

