 <!-- ================  Select Window Page =================== -->

<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%><%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="searchForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">
        <uix:formValue name="pageName" value="/database/instance/scheduler/selectWindow"/>
        <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <uix:header textBinding="SELECT_WINDOW@ResourceBundle@servletRequest">
            <uix:tableLayout cellSpacing="2">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:button textBinding="CANCEL@DBObjectMsgBundle@servletRequest"
                                destinationBinding="selectWindowCancelURL@servletRequest"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="SELECT@DBObjectMsgBundle@servletRequest"
                             name="event" value="setMembers"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <%-- Search Criteria and Instruction --%>
              <uix:rowLayout>
                <uix:header textBinding="SEARCH@DBObjectMsgBundle@servletRequest">
                  <uix:rowLayout>
                    <uix:styledText textBinding="SEARCH_WINDOW_INTS@ResourceBundle@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:tableLayout cellSpacing="4">
                      <uix:rowLayout hAlign="left">
                        <uix:styledText textBinding="SEARCH_FOR_WINDOW@ResourceBundle@servletRequest" labeledNodeId="searchObjectName"/>
                        <uix:textInput id="searchObjectName" name="searchObjectName" textBinding="searchObjectName@defaultBean@servletRequest"/>
                        <uix:submitButton textBinding="GO@DBObjectMsgBundle@servletRequest"
                                              name="event" value="searchSchemaObject"/>
                       <%--
                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:styledText textBinding="SCHEMA_NAME_COLON@DBObjectMsgBundle@servletRequest"/>
                          <uix:textInput name="searchSchemaName" textBinding="searchSchemaName@defaultBean@servletRequest"/>
                         </uix:stackLayout>
                       </uix:cellFormat>
                      --%>
                      <%--
                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:styledText textBinding="WINDOW@ResourceBundle@servletRequest"/>
                          <uix:rowLayout>
                            <uix:textInput name="searchObjectName" textBinding="searchObjectName@defaultBean@servletRequest"/>
                             <uix:submitButton textBinding="GO@DBObjectMsgBundle@servletRequest"
                                              name="event" value="searchSchemaObject"/>
                           </uix:rowLayout>
                        </uix:stackLayout>
                       </uix:cellFormat>
                      --%>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:rowLayout>
                </uix:header>
              </uix:rowLayout>
            <%-- End Search Criteria and Instruction --%>
              <uix:rowLayout>
                <uix:switcher childNameBinding="showSearchResults@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:header textBinding="RESULTS@DBObjectMsgBundle@servletRequest">
                      <uix:rowLayout width="80%">
                        <oem:table name="schemaObjectUIDataSource"
                                 formSubmitted="true"
                                 dataSourceProp="schemaObjectUIDataSource" width="100%"
      		                 alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                           summaryBinding="RESULTS@DBObjectMsgBundle@servletRequest">
       	                  <uix:tableSelection>
        		        <%--
                        <oem:singleSelection selectedIndex="0"/>
                        --%>
                            <uix:multipleSelection selectionBinding="selection@defaultBean@servletRequest" selectedBinding="selected" shortDescBinding="SELECT_WINDOW@ResourceBundle@servletRequest"/>
                          </uix:tableSelection>
                        </oem:table>
                      </uix:rowLayout>
                    </uix:header>
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBObjectMsgBundle@servletRequest"
                        destinationBinding="selectWindowCancelURL@servletRequest"/>
              <uix:submitButton textBinding="SELECT@DBObjectMsgBundle@servletRequest"
                         name="event" value="setMembers"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>  
