<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

          
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="scheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>          
  <uix:bundle name="dbschedulebundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>   
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

          
<uix:body>                

<%-- HTML Form --%>
<db:form name="viewForm"  destination="job" copyParams="target,type">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 <uix:formValue name="log_id" valueBinding="log_id@servletRequest" /> 

<uix:pageLayout titleBinding="viewRunHeader@objectBean@servletRequest">


  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
                  
    <%-- START: TAB CONTENTS starts here --%>
    <uix:header textBinding="GENERAL@bundle@servletRequest">
    <uix:tableLayout cellSpacing="5" width="100%"> 
      <uix:rowLayout>  
       <uix:cellFormat>
        <uix:tableLayout cellSpacing="5">    
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
         </uix:cellFormat>         
         <uix:styledText styleClass="OraDataText" 
                         textBinding="jobName@objectBean@servletRequest" />
        </uix:rowLayout>
        </uix:tableLayout> 
       </uix:cellFormat>

       <uix:cellFormat >
       <uix:tableLayout cellSpacing="5"> 
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/>
         </uix:cellFormat>         
         <uix:link  textBinding="schemaName@objectBean@servletRequest" destinationBinding="ownerUrl@servletRequest"/>
       </uix:rowLayout>
       </uix:tableLayout> 
       </uix:cellFormat>

       <uix:cellFormat >
        <uix:tableLayout cellSpacing="5"> 
         <uix:rowLayout>
          <uix:cellFormat hAlign="right" >
            <uix:messagePrompt promptBinding="STATUS@bundle@servletRequest"/>
          </uix:cellFormat>         
          <uix:styledText styleClass="OraDataText" 
                         textBinding="completedStatus@objectBean@servletRequest" />
        </uix:rowLayout>
        </uix:tableLayout> 
       </uix:cellFormat>

      <uix:cellFormat >
       <uix:tableLayout cellSpacing="5"> 
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="COMPLETE_DATE@bundle@servletRequest"/>
         </uix:cellFormat>         
         <uix:styledText styleClass="OraDataText" 
                         textBinding="completedDate@objectBean@servletRequest" />
       </uix:rowLayout>
       </uix:tableLayout> 
       </uix:cellFormat>
       
       <uix:cellFormat >
       <uix:tableLayout cellSpacing="5"> 
        <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="RUN_DURATION@bundle@servletRequest"/>
         </uix:cellFormat>         
         <uix:styledText styleClass="OraDataText" 
                         textBinding="completedDuration@objectBean@servletRequest" />
       </uix:rowLayout>
       </uix:tableLayout> 
       </uix:cellFormat>
       
       </uix:rowLayout>  
    </uix:tableLayout>
     
    <jsp:include page="cmd.jsp" />
          <uix:ref refID="cmd" />

  </uix:header>
 
  <uix:header textBinding="STEP_STATUS@bundle@servletRequest" renderedBinding="isChain@objectBean@servletRequest">    
    
    <uix:tableLayout cellSpacing="2" width="100%" >
     
      <uix:rowLayout>      
           <uix:tableLayout width="100%" >         
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="statusChain"
                           tableDataBinding="statusList@defaultBean@servletRequest"
                           columnHeaderDataBinding="statusColHeader@defaultBean@servletRequest"
                           columnFormatsBinding="statusColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_STEP_FOUND@bundle@servletRequest"
                           blockSizeBinding="statusBlockSize@defaultBean@servletRequest"
                           valueBinding="statusValue@defaultBean@servletRequest" 
                           minValueBinding="statusMinValue@defaultBean@servletRequest" 
                           maxValueBinding="statusMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="STEP_STATUS@bundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:styledText textBinding="completion_status"/>  
                     <uix:styledText textBinding="step_name"/>       
                     <uix:styledText textBinding="operation"/>                            
                     <uix:styledText textBinding="log_date"/>
                     <uix:styledText textBinding="run_duration"/>                     
                     <uix:styledText textBinding="log_id" destinationBinding="histDest"/>
                   </uix:contents>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
      </uix:rowLayout>
    </uix:tableLayout> 
  </uix:header>
  
    <uix:hideShowHeader textBinding="TOPOLOGY@bundle@servletRequest"
                    renderedBinding="isShowChain@objectBean@servletRequest"
                    disclosedBinding="statusShowTopo@objectBean@servletRequest"                     
                    formSubmitted="true" id="viewStatus" >                    
      <jsp:include page="/database/instance/scheduler/chainTopo.jsp" />
      <uix:ref refID="chainTopo" />
    </uix:hideShowHeader>

 
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




