<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="unscheduledForm" destination="jobs" copyParams="target,type"> 
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %> 
        <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>        
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/> 
        <%-- 
        ---- Main Header
        --%>
               
        <uix:header textBinding="JOBS@bundle@servletRequest">
         
        <%@ include file="../refreshTime.jspf" %>

        <uix:spacer height="1"/>
        <uix:rowLayout width="100%" >
           <uix:cellFormat hAlign="right" vAlign="top" width="100%">
             <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
           </uix:cellFormat>
        </uix:rowLayout> 
          
        <%--
        ---- Subtabs
        --%>
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="2">
              <uix:link textBinding="SCHEDULED@bundle@servletRequest"    
                          destinationBinding="tab1@servletRequest"/>                      
              <uix:link textBinding="RUNNING@bundle@servletRequest"
                           destinationBinding="tab2@servletRequest"/>
              <uix:link textBinding="UNSCHEDULED@bundle@servletRequest"
                           destinationBinding="tab3@servletRequest"/>
              <uix:link textBinding="HISTORY@bundle@servletRequest"
                           destinationBinding="tab4@servletRequest"/>
                           
            </uix:subTabBar>
          </uix:subTabs>
        <uix:tableLayout cellSpacing="5" width="100%" >
<%--         
          <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                    <uix:submitButton textBinding="CREATE_JOB@bundle@servletRequest" name="event" value="create"/>
              </uix:cellFormat>
          </uix:rowLayout>    
 --%>          
           <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                    <uix:styledText styleClass="OraInstructionText" textBinding="DISABLED_DESC@bundle@servletRequest" />
              </uix:cellFormat>
          </uix:rowLayout>   
          
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="unscheduled"
                           tableDataBinding="disableList@defaultBean@servletRequest"
                           columnHeaderDataBinding="disableColHeader@defaultBean@servletRequest"
                           columnFormatsBinding="disableColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_UNSCHED_JOBS_FOUND@bundle@servletRequest"
                           blockSizeBinding="disableBlockSize@defaultBean@servletRequest"
                           valueBinding="disableValue@defaultBean@servletRequest" 
                           minValueBinding="disableMinValue@defaultBean@servletRequest" 
                           maxValueBinding="disableMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="UNSCHEDULED@bundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:link textBinding="name" destinationBinding="jobDest" />  
                     <uix:link textBinding="owner" destinationBinding="ownerDest" />
                     <uix:styledText textBinding="completion_status"/>    
                     <uix:styledText textBinding="last_run_date"/>                     
                     <uix:styledText textBinding="class_name" destinationBinding="classDest"/>     
                     <uix:styledText textBinding="run_count"/>                                           
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="UNSCHEDULED@bundle@servletRequest">
                      <uix:submitButton textBinding="EDIT@bundle@servletRequest" name="event" value="edit" /> 
                      <uix:submitButton textBinding="VIEW@bundle@servletRequest" name="event" value="view" />
                      <uix:submitButton textBinding="DELETE@bundle@servletRequest" name="event" value="delete" />                       
                      <uix:submitButton textBinding="CREATE_LIKE@bundle@servletRequest" name="event" value="create_like" />                       
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
        <uix:spacer height="10"/>
 
        </uix:subTabLayout>    
        </uix:header>    

<%--
        <uix:pageButtons> 
         <uix:pageButtonBar>         
            <uix:submitButton textBinding="CREATE@bundle@servletRequest" name="event" value="create"/>
         </uix:pageButtonBar>  
       </uix:pageButtons>
 --%>       
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>

</uix:renderingContext>

