<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

          
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="scheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>          
  <uix:bundle name="dbschedulebundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>   
  <uix:bundle name="bundle"
          class="oracle.sysman.db.rsc.inst.SchedulesMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>


          
<uix:body>                

<%-- HTML Form --%>
<db:form name="viewForm"  destination="job" copyParams="target,type,cancelURL">
 <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
 <uix:formValue name="oname" valueBinding="oname@servletRequest" />
 <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
 
<uix:pageLayout titleBinding="viewHeader@objectBean@servletRequest">


  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

    <%-- START: TAB CONTENTS starts here --%>
  <uix:tableLayout cellSpacing="10" width="100%">
    <uix:rowLayout>
    <uix:cellFormat vAlign="top" hAlign="left">
    <uix:header textBinding="GENERAL@bundle@servletRequest">

       <uix:tableLayout cellSpacing="5">
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="NAME@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="jobName@objectBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="OWNER@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:link textBinding="schemaName@objectBean@servletRequest" destinationBinding="ownerUrl@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="ENABLED@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="enabled@objectBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="DESCRIPTION@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewComment@objectBean@servletRequest" />
       </uix:rowLayout>

        <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="LOGGING_LEVEL@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="displayLoggingLevel@objectBean@servletRequest" />
       </uix:rowLayout>

        <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="JOB_CLASS@bundle@servletRequest"/>
         </uix:cellFormat>
	<uix:switcher childNameBinding="viewJobClass@objectBean@servletRequest" >
	<uix:case name="None" >
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewJobClass@objectBean@servletRequest" />
	</uix:case>
	<uix:default>
         <uix:link textBinding="viewJobClass@objectBean@servletRequest" destinationBinding="viewjobclassUrl@servletRequest" />
	</uix:default>
	</uix:switcher>

       </uix:rowLayout>

       <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="PERSISTENT@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="persistent@objectBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="RESTARTABLE@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="restartable@objectBean@servletRequest" />
       </uix:rowLayout>

       <uix:switcher childNameBinding="isVer11Higher@objectBean@servletRequest">
       		 <uix:case name="true">
			 <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
		         <uix:cellFormat hAlign="right" >
		           <uix:messagePrompt promptBinding="DESTINATION@bundle@servletRequest"/>
		         </uix:cellFormat>
		         <uix:styledText styleClass="OraDataText" 
		                         textBinding="jobDestination@objectBean@servletRequest" />
		       </uix:rowLayout>
		</uix:case>
	</uix:switcher> 
	<uix:switcher childNameBinding="isVer11Higher@objectBean@servletRequest">
	          <uix:case name="true">
			 <uix:rowLayout  renderedBinding="jobExist@objectBean@servletRequest">
		         <uix:cellFormat hAlign="right" >
		           <uix:messagePrompt promptBinding="CREDENTIAL_NAME@bundle@servletRequest"/>
		         </uix:cellFormat>
		         <uix:styledText styleClass="OraDataText" 
		                         textBinding="credentialName@objectBean@servletRequest" />
		       </uix:rowLayout>
		</uix:case>
	</uix:switcher>	

                                                                                
      </uix:tableLayout>
      </uix:header>
    </uix:cellFormat>


    <uix:cellFormat vAlign="top" hAlign="left"  renderedBinding="jobExist@objectBean@servletRequest">


    <uix:header textBinding="SCHEDULE@bundle@servletRequest">
    
        <uix:switcher childNameBinding="uiScheduleType@scheduleTypeBean@pageContext">        
                  <uix:case name="3">
      <uix:tableLayout cellSpacing="5">                  
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="SCHEDULE@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="scheduleName@scheduleTypeBean@servletRequest" />
       </uix:rowLayout>
       </uix:tableLayout>
                  </uix:case>                 
                  
                  <uix:case name="4">
      <uix:tableLayout cellSpacing="5">                  
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="WINDOW@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="windowName@scheduleTypeBean@servletRequest" />
       </uix:rowLayout>
     </uix:tableLayout>       
                  </uix:case>    
                                    
                  
        <uix:case name="2">                  
      <uix:tableLayout cellSpacing="5">                  
                    <uix:rowLayout>       
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="START_DATE@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="startDate@scheduleTypeBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="END_DATE@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="endDate@scheduleTypeBean@servletRequest" />
       </uix:rowLayout>

                 <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="REPEAT_INTERVAL@bundle@servletRequest"/>
         </uix:cellFormat>
                   <uix:styledText styleClass="OraDataText" 
                         textBinding="repeatInterval@scheduleTypeBean@servletRequest" />
                   </uix:rowLayout>
       </uix:tableLayout>
                   
        </uix:case>                  

      <uix:default> 
          <uix:switcher childNameBinding="eventScheduleTypeSB@scheduleBean@servletRequest">
                <uix:case name="useEvent">

<uix:tableLayout cellSpacing="5">         
     <uix:rowLayout>
          <uix:cellFormat hAlign="right">
          <uix:styledText textBinding="QUEUE_NAME@bundle" labeledNodeId="REPEAT_HEADER"
	                        styleClass="OraPromptText"/>
          </uix:cellFormat>
	
          <uix:styledText styleClass="OraDataText" 
                           textBinding="displayScheduleQueueSpecExpr@scheduleBean@servletRequest" />
     </uix:rowLayout>


     <uix:rowLayout renderedBinding="isSecure@scheduleBean@viewSchedBean@servletRequest">
          <uix:cellFormat hAlign="right">
	          <uix:styledText textBinding="AGENT_NAME@bundle" labeledNodeId="REPEAT_HEADER"
     	                   styleClass="OraPromptText"/>
          </uix:cellFormat>
	
          <uix:styledText styleClass="OraDataText" 
                           textBinding="scheduleEventAgent@scheduleBean@servletRequest" />
     </uix:rowLayout>
     <uix:rowLayout>
          <uix:cellFormat hAlign="right">
               <uix:styledText textBinding="CONDITION@bundle" labeledNodeId="REPEAT_HEADER"
                        styleClass="OraPromptText"/>
          </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
                           textBinding="scheduleEventConditionExpr@scheduleBean@servletRequest" />
     </uix:rowLayout>

     <uix:rowLayout>       
          <uix:cellFormat hAlign="right" >
              <uix:messagePrompt promptBinding="AVAIL_START@dbschedulebundle"/>
          </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
                         textBinding="startDate@scheduleTypeBean@servletRequest" />
     </uix:rowLayout> 
          
</uix:tableLayout>                       
	     </uix:case>


                
                <uix:case name="ical">
					<%@ include file="schedule/schedCalView.jsp" %>
                </uix:case>
		<uix:default>
       <%@ include file="scheduleView.jsp" %>
		</uix:default>
	  </uix:switcher>
      </uix:default>      
       </uix:switcher>                   
    </uix:header>
    </uix:cellFormat>
    
    <uix:cellFormat vAlign="top" hAlign="left"  renderedBinding="jobExist@objectBean@servletRequest">
   <uix:header textBinding="OPTIONS@bundle@servletRequest">
   
       <uix:tableLayout cellSpacing="5">
        <uix:rowLayout renderedBinding="isVer102Higher@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="RAISE_EVENTS@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewRaiseEvents@objectBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout renderedBinding="isVer102Higher@objectBean@servletRequest">
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="MAX_RUN_DURATION@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewMaxRunDuration@objectBean@servletRequest" />
       </uix:rowLayout>

      <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="START_PRIORITY@bundle@servletRequest"/>
         </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
                         textBinding="displayPriority@objectBean@servletRequest" />          
       </uix:rowLayout>
       
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="SCHEDULE_LIMIT@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewScheduleLimit@objectBean@servletRequest" />
       </uix:rowLayout>
                
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="MAX_RUNS@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewMaxRuns@objectBean@servletRequest" />
       </uix:rowLayout>
     
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="MAX_FAILURES@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewMaxFailues@objectBean@servletRequest" />
       </uix:rowLayout>

       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="JOB_WEIGHT@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="viewJobWeight@objectBean@servletRequest" />
       </uix:rowLayout>
       
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" vAlign="top">
           <uix:messagePrompt promptBinding="INSTANCE_STICK@bundle@servletRequest"/>
         </uix:cellFormat>        
          <uix:stackLayout>
            <uix:styledText styleClass="OraDataText" 
                         textBinding="instStick@objectBean@servletRequest" />
                         
            <uix:styledText styleClass="OraInlineInfoText" textBinding="INSTANCE_STICK_DESC@bundle@servletRequest" />
           </uix:stackLayout>                   
       </uix:rowLayout>
      
<%--
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" >
           <uix:messagePrompt promptBinding="STOP_WIN_EXIT@bundle@servletRequest"/>
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="stopWinExit@objectBean@servletRequest" />
       </uix:rowLayout>                            
 --%>       
      </uix:tableLayout>
    </uix:header>
    </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>  

    <uix:header textBinding="COMMAND@bundle@servletRequest">             
        <jsp:include page="cmd.jsp" />
        <uix:ref refID="cmd" />
    </uix:header>

    <uix:header textBinding="OP_DETAIL@bundle@servletRequest">    
           <uix:tableLayout cellSpacing="5" width="100%" >
         
          <uix:rowLayout width="100%">
                 <uix:table  width="100%"
                           name="history"
                           tableDataBinding="histList@defaultBean@servletRequest"
                           columnHeaderDataBinding="histColHeader@defaultBean@servletRequest"
                           columnFormatsBinding="histColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_JOB_HIST_FOUND@bundle@servletRequest"
                           blockSizeBinding="histBlockSize@defaultBean@servletRequest"
                           valueBinding="histValue@defaultBean@servletRequest" 
                           minValueBinding="histMinValue@defaultBean@servletRequest" 
                           maxValueBinding="histMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="OP_DETAIL@bundle@servletRequest"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:styledText textBinding="log_id" destinationBinding="histDest"/>  
                     <uix:styledText textBinding="log_date"/>  
                     <uix:styledText textBinding="operation"/> 
                     <uix:styledText textBinding="completion_status"/>                        
                     
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="OP_DETAIL@bundle@servletRequest">
                      <uix:submitButton textBinding="VIEW@bundle@servletRequest" name="event" value="viewHist" />
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>    

          </uix:rowLayout>                        
        </uix:tableLayout>
    </uix:header>
        
    <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- View Buttons --%>
  <uix:pageButtons>
   <uix:pageButtonBar>
    <uix:switcher childNameBinding="jobExist@objectBean@servletRequest">        
      <uix:case name="false">   
          <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"     
                  shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                  name="event"                                          
                  value="cancel" />     
      </uix:case>
      <uix:default>
          <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
          <uix:ref refID="pageButtonViewInclude" />
      </uix:default>
    </uix:switcher>  
   </uix:pageButtonBar>
  </uix:pageButtons>        

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




