<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

 <uix:styleSheet/>
  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/> 
  <script>
    function lovSelectReload(pwin,lovField)
    {
      var proxy = new TableProxy("winTable");
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement1 = proxy.getFormElement('dname', selectedIndex);       
        lovField.value =  selectedElement1.value;        
        pwin.submitForm('scheduleForm',1,{'event':'show_win'});
      }
      window.close();
    }
  </script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

   <uix:bundle name="uixDBObjectBundle"
                class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="bundle"
                class="oracle.sysman.db.rsc.inst.JobsMsg"/>  
                
<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

<uix:body>                

<%-- HTML Form --%>
<db:form name="winForm"  method="post" destination="job" copyParams="target,type">
  <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
  <uix:formValue name="state" valueBinding="state@servletRequest"/> 
  <uix:formValue name="oname" valueBinding="oname@servletRequest" />
  <uix:formValue name="sname" valueBinding="sname@servletRequest" /> 
<uix:pageLayout titleBinding="SEARCH_SEL_WIN@bundle">

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


  <%-- START: TAB CONTENTS starts here --%>
   <uix:tableLayout cellSpacing="4">
            <uix:rowLayout hAlign="right">

              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <uix:cellFormat>
              
              <uix:header textBinding="SEARCH@uixDBObjectBundle"/>
                <uix:tableLayout cellSpacing="4">
                    <uix:contents>
                    
                    <uix:rowLayout hAlign='left'>
                       <uix:contents>
                       <uix:cellFormat width = "13">
                       </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:messagePrompt promptBinding="OBJECT_NAME_COLON@uixDBObjectBundle" labeledNodeId="winName"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                         <uix:textInput id="winName" name="winName" textBinding="winName@scheduleTypeBean@servletRequest"/>
                        </uix:cellFormat> 
                        <uix:submitButton textBinding="GO@uixDBObjectBundle"
                            name="event" value="changeWin"/>
                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>

              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:header textBinding="RESULTS@uixDBObjectBundle">
                    <uix:table  width="100%"
                           name="winTable"
                           tableDataBinding="winList@scheduleTypeBean@servletRequest"
                           columnFormatsBinding="winColFormats@scheduleTypeBean@servletRequest"
                           columnHeaderDataBinding="winColHeader@scheduleTypeBean@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@bundle"                           
                           valueBinding="winVal@scheduleTypeBean@servletRequest" 
                           blockSizeBinding="winBlockSize@scheduleTypeBean@servletRequest"                         
                           minValueBinding="winMinValue@scheduleTypeBean@servletRequest" 
                           maxValueBinding="winMaxValue@scheduleTypeBean@servletRequest"
                           formSubmitted="true" 
                           summaryBinding="RESULTS@uixDBObjectBundle"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/>                      
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>                              
                     <uix:styledText textBinding="name"/>   
                     <uix:styledText textBinding="type"/>    
                     <uix:formValue name="dname" valueBinding="dname"/>                                                          
                   </uix:contents>
                   <uix:tableSelection>
                   <uix:singleSelection selectedIndex="0" shortDescBinding="SEARCH_SEL_WIN@bundle"/>
                   </uix:tableSelection>
                 </uix:table>  
                    
                  </uix:header>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   


  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:button textBinding="CANCEL@uixDBObjectBundle"
                destination="javascript:self.close()"/>
    <uix:button textBinding="SELECT@uixDBObjectBundle" 
                 destinationBinding="winDest@servletRequest"/> 
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>

</uix:body> 
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




