 <!-- ================  Window Group Page =================== -->

<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%><%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="progForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">
        <uix:formValue name="pageName" value="/database/instance/scheduler/windowGroup"/>
        <uix:formValue name="event"/>

        <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <%-- Warning/Error display --%>
            <oem:messageBox messageType="info"
                   errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                   errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
	<%--
            <uix:header textBinding="GENERAL@DBObjectMsgBundle@servletRequest">
	--%>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                      <uix:case name="true">
                        <uix:messagePrompt promptBinding="NAME@DBObjectMsgBundle@servletRequest" required="yes" labeledNodeId="objectName"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:messagePrompt promptBinding="NAME@DBObjectMsgBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                      <uix:case name="true">
                        <uix:textInput id="objectName" name="objectName" textBinding="objectName@defaultBean@servletRequest" />
                      </uix:case>
                      <uix:case name="false">
                        <uix:styledText styleClass="OraDataText" textBinding="objectName@defaultBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                  <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="ENABLED@DBObjectMsgBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:radioButton name="enabled"
                         value="TRUE"
                         selectedValueBinding="enabled@defaultBean@servletRequest"
                         textBinding="YES@DBObjectMsgBundle@servletRequest" />
                    <uix:radioButton name="enabled"
                         value="FALSE"
                         selectedValueBinding="enabled@defaultBean@servletRequest"
                         textBinding="NO@DBObjectMsgBundle@servletRequest" />
                  </uix:cellFormat>
                </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
              </uix:tableLayout>
	<%--
            </uix:header>
	--%>
            <uix:header textBinding="MEMBERS@ResourceBundle@servletRequest">
              <uix:tableLayout cellSpacing="5" width="100%">
                <uix:rowLayout hAlign="right">
                  <uix:submitButton textBinding="ADD_OR_REMOVE_WINDOWS@ResourceBundle@servletRequest"
                     name="event" value="selectMember"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
                                               formSubmitted="true"
                                              dataSourceProp="twoDUIDataSource" width="100%"
                       blockSize="25" partialRenderMode="self" copyParams="target,type">
                     <%--
                    <uix:tableSelection>
                      <oem:singleSelection selectedIndexBinding="selectedIndex@dataSourceBean@servletRequest">
                        <uix:submitButton textBinding="DELETE@DBObjectMsgBundle@servletRequest"
                                 name="event" value="deleteArgument"/>
                      </oem:singleSelection>
                    </uix:tableSelection>
                    --%>
                  </oem:table>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
            <%-- Create/Edit Buttons --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                  <uix:ref refID="pageButtonInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>
          </uix:pageLayout>
        </db:form>
        <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
