<%@ include file="/sdk/oemTop.jspf" %>

<!-- ================  Window Group View Page =================== -->

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="progForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">
        <uix:formValue name="pageName" value="/database/instance/scheduler/windowGroupView"/>
        <uix:formValue name="windowGroupName" valueBinding="objectName@defaultBean@servletRequest" />
        <uix:formValue name="event"/>

        <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
	<%--
            <uix:header textBinding="GENERAL@DBObjectMsgBundle@servletRequest">
	--%>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="NAME@DBObjectMsgBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="objectName@defaultBean@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="ENABLED@DBObjectMsgBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="enabled@defaultBean@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
	<%--
            </uix:header>
	--%>
            <uix:header textBinding="MEMBERS@ResourceBundle@servletRequest">
              <uix:tableLayout cellSpacing="5" width="100%">
                <uix:rowLayout>
                  <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
                                               formSubmitted="true"
                                              dataSourceProp="twoDUIDataSource" width="100%"
			                       blockSize="25" partialRenderMode="self"
			                      alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
			                       copyParams="target,type">
                   </oem:table>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>

            <%-- Create/Edit Buttons --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
                  <uix:ref refID="pageButtonViewInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>
          </uix:pageLayout>
        </db:form>
        <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
