 <!-- ================  Window Page =================== -->
 
<%@ include file="/sdk/oemTop.jspf" %>
 <%-- Tag Libraries --%>
 <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
 <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
 
<db:script src="/database/utils.js"/>
 
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  
  <uix:document>      
   <uix:metaContainer>
     <script>
      function myCallBack(lovwin, event)
      { 
          
      }
     </script>
    </uix:metaContainer>
    <%@ include file="/oemTitle.jspf" %>      
	 
	<uix:body>          
	  <%-- HTML Form --%>      
	  <db:form name="winForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">        
	    <uix:formValue name="pageName" value="/database/instance/scheduler/windowPage"/>        
		<uix:formValue name="event"/>                
		 
		<uix:pageLayout titleBinding="header@defaultBean@servletRequest">           
		  <%@ include file="/database/global.jspf" %>            
		   
		  <%-- Warning/Error display --%>            
		  <oem:messageBox messageType="info"                   
				errorTableBinding="info@servletRequest"                  
				titleTextKey="titleText" mainTextKey="mainText"/>            
		  <oem:messageBox messageType="error"                   
				errorTableBinding="errors@servletRequest"                  
				titleTextKey="titleText" mainTextKey="mainText"/>            
				
		<%--
		  <uix:header textBinding="GENERAL@DBObjectMsgBundle@servletRequest">              
		--%>
		    <uix:tableLayout cellSpacing="5">                
			  <uix:rowLayout>                  
			    <uix:cellFormat hAlign="right">                    
				  <uix:switcher childNameBinding="creating@defaultBean@servletRequest">                      
				    <uix:case name="true">                        
					  <uix:messagePrompt promptBinding="NAME@DBObjectMsgBundle@servletRequest" required="yes"  labeledNodeId="objectName"/>                      
					</uix:case>                      
					<uix:case name="false">                        
					  <uix:messagePrompt promptBinding="NAME@DBObjectMsgBundle@servletRequest"/>                      
					</uix:case>                    
				  </uix:switcher>                  
				</uix:cellFormat>                   
				<uix:stackLayout>                    
				  <uix:switcher childNameBinding="creating@defaultBean@servletRequest">                      
				    <uix:case name="true">                        
				      <uix:textInput  id="objectName" name="objectName" textBinding="objectName@defaultBean@servletRequest" />                      
				    </uix:case>                         
				    <uix:case name="false">                        
				      <uix:styledText styleClass="OraDataText" textBinding="objectName@defaultBean@servletRequest"/>                      
				    </uix:case>                             
				  </uix:switcher>                    
				  <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>                  
			    </uix:stackLayout>               				                 
			  </uix:rowLayout>                                
			  <uix:rowLayout>                  
			    <uix:cellFormat hAlign="right">                    
			      <uix:messagePrompt promptBinding="RESOURCE_PLAN@DBObjectMsgBundle@servletRequest" labeledNodeId="resourcePlan"/>                  
			    </uix:cellFormat>                  
			  <uix:cellFormat>                    
			    <oem:choice id="resourcePlan" name="resourcePlan"                            
					optionsBinding="resourcePlans@defaultBean@servletRequest"                            
					selectedValueBinding="resourcePlan@defaultBean@servletRequest"/>                    
			    <uix:spacer width="10"/>                    
			    <uix:submitButton textBinding="VIEW_RESOURCE_PLAN@ResourceBundle@servletRequest"                            
					name="event" value="viewResourcePlan"/>                     
			    <uix:spacer width="10"/>                    
			    <uix:submitButton textBinding="CREATE_RESOURCE_PLAN@ResourceBundle@servletRequest"                            
					name="event" value="createResourcePlan"/>                   
			  </uix:cellFormat>                
		    </uix:rowLayout>                
		    <uix:switcher childNameBinding="creating@defaultBean@servletRequest">                
		      <uix:case name="false">                
			    <uix:rowLayout>                  
			      <uix:cellFormat hAlign="right">                    
				    <uix:messagePrompt promptBinding="ENABLED@DBObjectMsgBundle@servletRequest"/>                   
				  </uix:cellFormat>               
				  <uix:cellFormat>                    
				    <uix:radioButton name="enabled"                         
						value="TRUE"                         
						selectedValueBinding="enabled@defaultBean@servletRequest"                         
						textBinding="YES@DBObjectMsgBundle@servletRequest" />                    
				    <uix:radioButton name="enabled"                         
						value="FALSE"                         
						selectedValueBinding="enabled@defaultBean@servletRequest"                         
						textBinding="NO@DBObjectMsgBundle@servletRequest" />                  
				  </uix:cellFormat>                
			    </uix:rowLayout>                
			  </uix:case>                
		    </uix:switcher>                                
		    <uix:rowLayout>                  
		      <uix:cellFormat hAlign="right">                    
			    <uix:messagePrompt promptBinding="PRIORITY@ResourceBundle@servletRequest"/>                   
			  </uix:cellFormat>                   
			  <uix:cellFormat>                    
			    <uix:radioButton name="priority"                         
					value="LOW"                         
					selectedValueBinding="priority@defaultBean@servletRequest"                         
					textBinding="LOW@ResourceBundle@servletRequest" />                    
			    <uix:radioButton name="priority"                         
					value="HIGH"                         
					selectedValueBinding="priority@defaultBean@servletRequest"                         
					textBinding="HIGH@ResourceBundle@servletRequest" />                  
			  </uix:cellFormat>                  
			  <%--                  
			  <uix:choice name="priority"                         
				selectedValueBinding="priority@defaultBean@servletRequest">                    
			    <uix:option text="HIGH" value="HIGH"/>                    
			    <uix:option text="LOW" value="LOW"/>                  
			  </uix:choice>                  
			  --%>                
		    </uix:rowLayout>                   
		    <uix:rowLayout>                  
		      <uix:cellFormat hAlign="right" vAlign="top">                    
			    <uix:messagePrompt promptBinding="DESCRIPTION@DBObjectMsgBundle@servletRequest" labeledNodeId="comment"/>                  
			  </uix:cellFormat>                   
		      <uix:textInput  id="comment" name="comment" textBinding="comment@defaultBean@servletRequest" columns="80"/>                
		    </uix:rowLayout>              
		  </uix:tableLayout>            
	<%--
	    </uix:header>                        
	--%>
	    <uix:header textBinding="SCHEDULE@ResourceBundle@servletRequest">          
	      <uix:stackLayout>            
  		    <uix:spacer height ="10"/>                                           
		      <uix:switcher childNameBinding="creating@defaultBean@servletRequest">            
			    <uix:case name="true">            
			      <uix:tableLayout width="50%">              
				    <uix:cellFormat width="70%">                
				      <uix:rowLayout>                  
					    <uix:radioButton name="scheduleType"                          
							textBinding="SCHE_CAL@ResourceBundle@servletRequest"                          
							value="CALENDAR_STRING"                          
							selectedValueBinding="scheduleType@defaultBean@servletRequest"                           
							onClick="submitForm('winForm', true, {'event':'changeScheduleType'})"/>
							
							<uix:spacer width ="10"/>
							<uix:choice id="eventScheduleTypeSB" name="eventScheduleTypeSB" 
                              onChange="submitForm('winForm', true,{event:'changeScheduleType'})" 
                              selectedValueBinding="eventScheduleTypeSB@scheduleBean@servletRequest"> 
			                  <uix:contents childDataBinding="windowScheduleTypeChoicesSB@scheduleBean@servletRequest">
			                    <uix:option textBinding="stext"
			                                 valueBinding="sval"/>
			                  </uix:contents>
			              </uix:choice>
							
							                  
					  </uix:rowLayout>                
					  <uix:rowLayout>                                      
 					    <uix:cellFormat hAlign="left" >                    
					      <uix:radioButton name="scheduleType"                          
							textBinding="SCHE_NAME@ResourceBundle@servletRequest"                          
							value="NAMED"                          
							selectedValueBinding="scheduleType@defaultBean@servletRequest"                          
							onClick="submitForm('winForm', true, {'event':'changeScheduleType'})"/>                    
					    </uix:cellFormat>                
					  </uix:rowLayout>                  
				    </uix:cellFormat>                                             
				    <%--                                  
				    <uix:cellFormat vAlign="bottom"  hAlign="right" width="30%">                
				      <uix:submitButton textBinding="GO@DBObjectMsgBundle@servletRequest" name="event" value="changeScheduleType" />                                     
				    </uix:cellFormat>              
				    --%>                     
				  </uix:tableLayout>            
			    </uix:case>            
			  </uix:switcher>                              
			  <uix:spacer height ="10"/>                  
			  <uix:switcher childNameBinding="scheduleType@defaultBean@servletRequest">              
			  <%-- ICAL --%>              
			    <uix:case name="CALENDAR_STRING">                
			      <uix:stackLayout>    
             <%@ include file="schedule/timezone.jspf" %>
				       <uix:switcher childNameBinding="eventScheduleTypeSB@scheduleBean@servletRequest">
			                <uix:case name="ical"> 
			                    <jsp:include page="/database/instance/scheduler/schedule/scheduleCal.jsp" /> 
			                    <uix:ref refID="scheduleCal" />
			                </uix:case>
			                <uix:default>
			                    <jsp:include page="/database/instance/scheduler/schedule/schedule.jsp" />
                                            <uix:ref refID="schedule" />  
			                </uix:default>
	            		</uix:switcher>                                                
				  </uix:stackLayout>              
			    </uix:case>                               
			    <%-- NAMED SCHEDULE --%>              
			    <uix:case name="NAMED">              
				  <uix:header textBinding="SCHEDULE@ResourceBundle@servletRequest">                
  				    <uix:tableLayout cellSpacing="5">                
				      <uix:rowLayout>                  
					    <uix:cellFormat hAlign="right">                    
					      <uix:messagePrompt promptBinding="SCHEDULE_NAME@ResourceBundle@servletRequest"/>                    
						  <%--                    
						  <uix:lovField name="scheduleName"                            
							textBinding="scheduleName@defaultBean@servletRequest"                             
							destinationBinding="scheduleDestination@defaultBean@servletRequest"/>                    
						  <uix:spacer width="10"/>                    
						  <uix:submitButton textBinding="VIEW_DETAIL@ResourceBundle@servletRequest"                            
							name="event" value="viewSchedule"/>                     
						  --%>                    
						  <uix:spacer width="10"/>                    
						<%--
						  <uix:textInput name="scheduleName" textBinding="scheduleName@defaultBean@servletRequest" readOnly="true"/>                    
						--%>
						  <uix:styledText styleClass="OraDataText" textBinding="displaySchedule@defaultBean@servletRequest"/>
						  <uix:spacer width="10"/>                    
						  <uix:submitButton textBinding="SELECT_SCHEDULE@ResourceBundle@servletRequest"                            
							name="event" value="selectSchemaAndObject"/>                    
						  <uix:spacer width="10"/>                    
						  <uix:submitButton textBinding="CREATE_SCHEDULE@ResourceBundle@servletRequest"                            
							name="event" value="createSchedule"/>                   
					    </uix:cellFormat>                
					  </uix:rowLayout>                
				    </uix:tableLayout>                 
				    <uix:switcher childNameBinding="showNamedScheduleDetail@defaultBean@servletRequest">         
					  <uix:case name="true">                
					    <jsp:include page="schedViewInclude.jsp" />                  
					    <uix:ref refID="schedViewInclude" />                  
					  </uix:case>                  
				    </uix:switcher>                  
				    <uix:switcher childNameBinding="showNamedScheduleDetail@defaultBean@servletRequest">         
					  <uix:case name="true">                

						<uix:header textBinding="DURATION@scheduleBundle@servletRequest"> 
						  <uix:tableLayout cellSpacing="5">
							<uix:rowLayout>
							  <uix:cellFormat hAlign="left">
								<uix:messagePrompt promptBinding="DURATION@scheduleBundle@servletRequest" labeledNodeId="duration"/> 
								<uix:spacer width="5"/>
								<uix:textInput id="duration" name="durationHourSB" textBinding="durationHourSB@scheduleBean@servletRequest" columns="10">
                <uix:onSubmitValidater>
                  <uix:regExp pattern="[0-9]+" />
                </uix:onSubmitValidater>
                </uix:textInput>
								<uix:styledText styleClass="OraInstructionText" textBinding="HOURS@scheduleBundle@servletRequest" />
								<uix:textInput   name="durationMinuteSB" textBinding="durationMinuteSB@scheduleBean@servletRequest" columns="10"  shortDescBinding="DURATION@scheduleBundle@servletRequest">
                <uix:onSubmitValidater>
                  <uix:regExp pattern="[0-9]+" />
                </uix:onSubmitValidater>
                </uix:textInput>                
								<uix:styledText styleClass="OraInstructionText" textBinding="MINUTES@scheduleBundle@servletRequest" />
							  </uix:cellFormat>
							</uix:rowLayout>
						  </uix:tableLayout>
						</uix:header>

					  </uix:case>                  
				    </uix:switcher>                  
				  </uix:header>              


			    </uix:case>                               
			  </uix:switcher>                                                 
		    </uix:stackLayout>                        
		  </uix:header>            
		
		  <%-- Create/Edit Buttons --%>            
		  <uix:pageButtons>              
  		    <uix:pageButtonBar>                
		      <jsp:include page="/database/schema/pageButtonInclude.jsp" />                  
			  <uix:ref refID="pageButtonInclude" />              
		    </uix:pageButtonBar>            
		  </uix:pageButtons>          
	    </uix:pageLayout>        
	  </db:form>        
	  <%-- END: HTML Form --%>    
    </uix:body>  
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>  
